/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.tests.tasks;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.Sejda;
import org.sejda.core.notification.context.GlobalNotificationContext;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.model.notification.EventListener;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.sejda.model.notification.event.TaskExecutionWarningEvent;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.MultipleTaskOutput;
import org.sejda.model.output.SingleOrMultipleTaskOutput;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.parameter.base.MultipleOutputTaskParameters;
import org.sejda.model.parameter.base.SingleOrMultipleOutputTaskParameters;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.sambox.input.PDFParser;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.sejda.tests.PixelCompareUtils;
import org.sejda.tests.TestListenerFactory;

public class TaskTestContext
implements Closeable {
    private ByteArrayOutputStream streamOutput;
    private File fileOutput;
    private PDDocument outputDocument;
    Throwable taskFailureCause = null;
    String failedSource;
    List<String> taskWarnings = new ArrayList<String>();
    private TestListenerFactory.TestListenerStart startListener = TestListenerFactory.newStartListener();
    private EventListener<TaskExecutionWarningEvent> warningsListener = new EventListener<TaskExecutionWarningEvent>(){

        public void onEvent(TaskExecutionWarningEvent event) {
            TaskTestContext.this.taskWarnings.add(event.getWarning());
        }
    };
    private EventListener<TaskExecutionFailedEvent> failureListener = new EventListener<TaskExecutionFailedEvent>(){

        public void onEvent(TaskExecutionFailedEvent event) {
            TaskTestContext.this.taskFailureCause = event.getFailingCause();
            TaskTestContext.this.failedSource = event.getNotifiableTaskMetadata().getCurrentSource();
        }
    };

    public TaskTestContext pdfOutputTo(SingleOutputTaskParameters params) throws IOException {
        this.fileOutput = File.createTempFile("SejdaTest", ".pdf");
        this.fileOutput.deleteOnExit();
        params.setOutput((SingleTaskOutput)new FileTaskOutput(this.fileOutput));
        return this;
    }

    public TaskTestContext fileOutputTo(SingleOutputTaskParameters params, String extension) throws IOException {
        this.fileOutput = File.createTempFile("SejdaTest", extension);
        this.fileOutput.deleteOnExit();
        params.setOutput((SingleTaskOutput)new FileTaskOutput(this.fileOutput));
        return this;
    }

    public TaskTestContext directoryOutputTo(MultipleOutputTaskParameters params) throws IOException {
        this.fileOutput = Files.createTempDirectory("SejdaTest", new FileAttribute[0]).toFile();
        this.fileOutput.deleteOnExit();
        params.setOutput((MultipleTaskOutput)new DirectoryTaskOutput(this.fileOutput));
        return this;
    }

    public TaskTestContext directoryOutputTo(SingleOrMultipleOutputTaskParameters params) throws IOException {
        this.fileOutput = Files.createTempDirectory("SejdaTest", new FileAttribute[0]).toFile();
        this.fileOutput.deleteOnExit();
        params.setOutput((SingleOrMultipleTaskOutput)new FileOrDirectoryTaskOutput(this.fileOutput));
        return this;
    }

    public TaskTestContext pdfOutputTo(SingleOrMultipleOutputTaskParameters params) throws IOException {
        this.fileOutput = Files.createTempFile("SejdaTest", ".pdf", new FileAttribute[0]).toFile();
        this.fileOutput.deleteOnExit();
        params.setOutput((SingleOrMultipleTaskOutput)new FileOrDirectoryTaskOutput(this.fileOutput));
        return this;
    }

    public TaskTestContext assertCreator() {
        this.requirePDDocument();
        Assertions.assertEquals((Object)Sejda.CREATOR, (Object)this.outputDocument.getDocumentInformation().getCreator());
        return this;
    }

    public TaskTestContext assertVersion(PdfVersion version) {
        this.requirePDDocument();
        Assertions.assertEquals((Object)version.getVersionString(), (Object)this.outputDocument.getVersion(), (String)"Wrong output PDF version");
        return this;
    }

    public TaskTestContext assertPages(int expected) {
        this.requirePDDocument();
        Assertions.assertEquals((int)expected, (int)this.outputDocument.getNumberOfPages(), (String)"Wrong number of pages");
        return this;
    }

    public TaskTestContext assertPages(String filename, int expected) throws IOException {
        this.assertOutputContainsFilenames(filename);
        try (PDDocument doc = PDFParser.parse((SeekableSource)SeekableSources.seekableSourceFrom((File)new File(this.fileOutput, filename)));){
            Assertions.assertEquals((int)expected, (int)doc.getNumberOfPages());
        }
        return this;
    }

    public TaskTestContext assertHasOutline(boolean hasOutline) {
        this.requirePDDocument();
        if (hasOutline) {
            Assertions.assertNotNull((Object)this.outputDocument.getDocumentCatalog().getDocumentOutline());
        } else {
            Assertions.assertNull((Object)this.outputDocument.getDocumentCatalog().getDocumentOutline());
        }
        return this;
    }

    public TaskTestContext assertHasAcroforms(boolean hasForms) {
        this.requirePDDocument();
        if (hasForms) {
            Assertions.assertNotNull((Object)this.outputDocument.getDocumentCatalog().getAcroForm());
            Assertions.assertTrue((this.outputDocument.getDocumentCatalog().getAcroForm().getFields().size() > 0 ? 1 : 0) != 0);
        } else {
            Assertions.assertNull((Object)this.outputDocument.getDocumentCatalog().getAcroForm());
        }
        return this;
    }

    public TaskTestContext assertOutlineContains(String title) {
        this.requirePDDocument();
        PDDocumentOutline outline = this.outputDocument.getDocumentCatalog().getDocumentOutline();
        Assertions.assertNotNull((Object)outline);
        if (!this.findOutlineItem(title, (PDOutlineNode)outline)) {
            Assertions.fail((String)("Unable to find outline node with title: " + title));
        }
        return this;
    }

    public TaskTestContext assertOutlineDoesntContain(String title) {
        this.requirePDDocument();
        PDDocumentOutline outline = this.outputDocument.getDocumentCatalog().getDocumentOutline();
        if (Objects.nonNull(outline) && this.findOutlineItem(title, (PDOutlineNode)outline)) {
            Assertions.fail((String)("Found outline node with title: " + title));
        }
        return this;
    }

    private boolean findOutlineItem(String title, PDOutlineNode node) {
        boolean found = false;
        if (node.hasChildren()) {
            for (PDOutlineItem current : node.children()) {
                found = this.findOutlineItem(title, (PDOutlineNode)current);
                if (!found) continue;
                return true;
            }
        }
        return node instanceof PDOutlineItem && title.equals(((PDOutlineItem)node).getTitle());
    }

    public TaskTestContext assertOutputSize(int size) throws IOException {
        if (size == 0) {
            return this.assertEmptyMultipleOutput();
        }
        this.requireMultipleOutputs();
        Assertions.assertEquals((long)size, (long)Files.list(this.fileOutput.toPath()).filter(p -> {
            if (SystemUtils.IS_OS_WINDOWS) {
                try {
                    return (Boolean)Files.getAttribute(p, "dos:hidden", new LinkOption[0]) == false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return !p.getFileName().toString().startsWith(".");
        }).count(), (String)"An unexpected number of output files has been created");
        return this;
    }

    public TaskTestContext assertOutputSizeIncludingHidden(int size) {
        if (size == 0) {
            return this.assertEmptyMultipleOutput();
        }
        this.requireMultipleOutputs();
        Object[] files = this.fileOutput.list();
        Assertions.assertEquals((int)size, (int)files.length, (String)("An unexpected number of output files has been created: " + StringUtils.join((Object[])files, (String)",")));
        return this;
    }

    public TaskTestContext assertEmptyMultipleOutput() {
        Assertions.assertNotNull((Object)this.fileOutput);
        Assertions.assertTrue((boolean)this.fileOutput.isDirectory(), (String)"Expected an output directory");
        Assertions.assertEquals((int)0, (int)this.fileOutput.listFiles((d, n) -> !n.endsWith(".tmp")).length, (String)"Found output files while expecting none");
        return this;
    }

    public TaskTestContext assertOutputContainsFilenames(String ... filenames) {
        this.requireMultipleOutputs();
        Set outputFiles = Arrays.stream(this.fileOutput.listFiles()).map(File::getName).collect(Collectors.toSet());
        Arrays.stream(filenames).forEach(f -> Assertions.assertTrue((boolean)outputFiles.contains(f), (String)(f + " missing but expected. Files were: " + StringUtils.join((Object[])new Set[]{outputFiles}))));
        return this;
    }

    public TaskTestContext forEachPdfOutput(Consumer<PDDocument> consumer) throws IOException {
        if (Objects.nonNull(this.outputDocument)) {
            this.requirePDDocument();
            consumer.accept(this.outputDocument);
        } else if (Objects.nonNull(this.fileOutput) && this.fileOutput.isDirectory()) {
            this.requireMultipleOutputs();
            for (File current : this.fileOutput.listFiles()) {
                try (PDDocument doc = PDFParser.parse((SeekableSource)SeekableSources.seekableSourceFrom((File)current));){
                    consumer.accept(doc);
                }
            }
        } else {
            Assertions.fail((String)"No output to apply to");
        }
        return this;
    }

    public TaskTestContext forPdfOutput(Consumer<PDDocument> consumer) {
        this.requirePDDocument();
        consumer.accept(this.outputDocument);
        return this;
    }

    public TaskTestContext forPdfOutput(String filename, Consumer<PDDocument> consumer) throws IOException {
        this.requireMultipleOutputs();
        Assertions.assertTrue((StringUtils.isNotEmpty((CharSequence)filename) && filename.toLowerCase().endsWith("pdf") ? 1 : 0) != 0, (String)"Not a PDF output");
        try (PDDocument doc = PDFParser.parse((SeekableSource)SeekableSources.seekableSourceFrom((File)new File(this.fileOutput, filename)));){
            consumer.accept(doc);
        }
        return this;
    }

    public TaskTestContext forEachRawOutput(Consumer<Path> consumer) throws IOException {
        this.requireMultipleOutputs();
        Files.list(this.fileOutput.toPath()).forEach(consumer);
        return this;
    }

    public TaskTestContext forRawOutput(Consumer<Path> consumer) {
        Assertions.assertNotNull((Object)this.fileOutput);
        consumer.accept(this.fileOutput.toPath());
        return this;
    }

    public TaskTestContext forRawOutput(String filename, Consumer<Path> consumer) {
        this.requireMultipleOutputs();
        File file = new File(this.fileOutput, filename);
        Assertions.assertTrue((boolean)file.exists());
        consumer.accept(file.toPath());
        return this;
    }

    private void requireMultipleOutputs() {
        Assertions.assertNotNull((Object)this.fileOutput);
        Assertions.assertTrue((boolean)this.fileOutput.isDirectory(), (String)"Expected an output directory");
        Assertions.assertTrue((this.fileOutput.listFiles().length > 0 ? 1 : 0) != 0, (String)"No output has been created");
    }

    private void requirePDDocument() {
        Assertions.assertNotNull((Object)this.outputDocument, (String)"No output document, make sure to call TaskTestContext::assertTaskCompleted before any other assert method");
    }

    public PDDocument assertTaskCompleted() throws IOException {
        return this.assertTaskCompleted(null);
    }

    public PDDocument assertTaskCompleted(String password) throws IOException {
        this.assertTaskDidNotFail();
        if (Objects.nonNull(this.fileOutput)) {
            if (this.fileOutput.isDirectory()) {
                File[] files = this.fileOutput.listFiles();
                Assertions.assertTrue((files.length > 0 ? 1 : 0) != 0, (String)"No output has been created");
                if (files.length == 1) {
                    this.initOutputFromSource(files[0], password);
                }
            } else {
                this.initOutputFromSource(this.fileOutput, password);
            }
        } else if (Objects.nonNull(this.streamOutput)) {
            IOUtils.close((Closeable)this.streamOutput);
            this.initOutputFromSource(SeekableSources.inMemorySeekableSourceFrom((byte[])this.streamOutput.toByteArray()), password);
        }
        return this.outputDocument;
    }

    public List<String> getTaskWarnings() {
        return Collections.unmodifiableList(this.taskWarnings);
    }

    public void listenForTaskFailure() {
        this.taskFailureCause = null;
        GlobalNotificationContext.getContext().removeListener(this.failureListener);
        GlobalNotificationContext.getContext().addListener(this.failureListener);
    }

    public void listenForTaskStart() {
        GlobalNotificationContext.getContext().removeListener((EventListener)this.startListener);
        GlobalNotificationContext.getContext().addListener((EventListener)this.startListener);
    }

    public TaskTestContext assertTaskFailed(String message) {
        Assertions.assertNotNull((Object)this.taskFailureCause);
        MatcherAssert.assertThat((Object)this.taskFailureCause.getMessage(), (Matcher)CoreMatchers.startsWith((String)message));
        return this;
    }

    public TaskTestContext assertTaskFailed(Class<? extends Throwable> cause) {
        Assertions.assertNotNull((Object)this.taskFailureCause);
        MatcherAssert.assertThat((Object)this.taskFailureCause, (Matcher)CoreMatchers.instanceOf(cause));
        return this;
    }

    public TaskTestContext assertTaskFailed() {
        Assertions.assertNotNull((Object)this.taskFailureCause);
        return this;
    }

    public TaskTestContext assertFailedSource(String source) {
        Assertions.assertEquals((Object)source, (Object)this.failedSource);
        return this;
    }

    public TaskTestContext assertTaskStarted() {
        Assertions.assertTrue((boolean)this.startListener.isStarted());
        return this;
    }

    public TaskTestContext assertTaskDidNotFail() {
        Assertions.assertNull((Object)this.taskFailureCause, (String)"Task failed");
        return this;
    }

    @Deprecated
    public void expectTaskWillProduceWarnings() {
        this.listenForTaskWarnings();
    }

    public void listenForTaskWarnings() {
        this.taskWarnings = new ArrayList<String>();
        GlobalNotificationContext.getContext().removeListener(this.warningsListener);
        GlobalNotificationContext.getContext().addListener(this.warningsListener);
    }

    public TaskTestContext assertTaskWarning(String message) {
        MatcherAssert.assertThat(this.taskWarnings, (Matcher)CoreMatchers.hasItem((Matcher)Matchers.containsString((String)message)));
        return this;
    }

    public TaskTestContext assertTaskWarnings(List<String> messages) {
        Assertions.assertEquals(this.taskWarnings, messages);
        return this;
    }

    public TaskTestContext assertNoTaskWarnings() {
        Assertions.assertEquals((int)this.taskWarnings.size(), (int)0, (String)("Expected no warnings but got: " + StringUtils.join(this.taskWarnings, (String)",")));
        return this;
    }

    private void initOutputFromSource(File source, String password) throws IOException {
        if (source.getName().toLowerCase().endsWith("pdf")) {
            this.outputDocument = PDFParser.parse((SeekableSource)SeekableSources.seekableSourceFrom((File)source), (String)password);
            Assertions.assertNotNull((Object)this.outputDocument);
        }
    }

    private void initOutputFromSource(SeekableSource source, String password) throws IOException {
        this.outputDocument = PDFParser.parse((SeekableSource)source, (String)password);
        Assertions.assertNotNull((Object)this.outputDocument);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.streamOutput);
        this.streamOutput = null;
        IOUtils.closeQuietly((Closeable)this.outputDocument);
        this.outputDocument = null;
        if (Objects.nonNull(this.fileOutput)) {
            if (this.fileOutput.isDirectory()) {
                Files.walkFileTree(this.fileOutput.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            Files.deleteIfExists(this.fileOutput.toPath());
        }
        this.fileOutput = null;
    }

    public File getFileOutput() {
        return this.fileOutput;
    }

    public void assertSimilar(String filename, String resourcePath) throws IOException {
        this.forPdfOutput(filename, actual -> new PixelCompareUtils().assertSimilar((PDDocument)actual, resourcePath));
    }

    public void assertSimilar(String resourcePath) {
        this.forPdfOutput(actual -> new PixelCompareUtils().assertSimilar((PDDocument)actual, resourcePath));
    }

    public void assertSimilar(String resourcePath, double similarityThreshold) {
        this.forPdfOutput(actual -> new PixelCompareUtils(similarityThreshold).assertSimilar((PDDocument)actual, resourcePath));
    }

    public void assertSimilar(String filename, String resourcePath, double similarityThreshold) throws IOException {
        this.forPdfOutput(filename, actual -> new PixelCompareUtils(similarityThreshold).assertSimilar((PDDocument)actual, resourcePath));
    }

    public void debug(String filename) {
        File dest = new File(SystemUtils.getJavaIoTmpDir(), filename);
        this.debugTo(dest.getAbsolutePath());
        System.out.println(dest);
    }

    public void debugTo(String destPath) {
        try {
            this.forEachRawOutput(path -> {
                try {
                    FileUtils.copyFile((File)path.toFile(), (File)new File(destPath));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

