/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.selenoid;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SelenoidClient {
    private static final Logger log = LoggerFactory.getLogger(SelenoidClient.class);
    private static final Type listType = new TypeToken<List<String>>(){}.getType();
    private static final Gson gson = new Gson();
    final String baseUrl;
    private final String sessionId;

    public SelenoidClient(String hubUrl, String sessionId) {
        if (!hubUrl.endsWith("/wd/hub")) {
            throw new IllegalArgumentException("Expect hub url to end with /wd/hub, but received: " + hubUrl);
        }
        this.baseUrl = hubUrl.replace("/wd/hub", "");
        this.sessionId = sessionId;
    }

    @CheckReturnValue
    @Nonnull
    public List<String> downloads() {
        URL url = this.url(this.baseUrl + "/download/" + this.sessionId + "/?json");
        String fileNamesJson = this.readToString(url);
        List fileNames = (List)gson.fromJson(fileNamesJson, listType);
        log.debug("Retrieved files from {}: {}", (Object)url, (Object)fileNames);
        return fileNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    @Nonnull
    public File download(String fileName) {
        URL url = this.urlOfDownloadedFile(fileName);
        try (InputStream in = this.connectionFromUrl(url).getInputStream();){
            Path uniqueDir = Files.createTempDirectory("selenoid-download", new FileAttribute[0]);
            File file = new File(uniqueDir.toFile(), fileName);
            try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            }
            log.debug("Downloaded file from {} to {}", (Object)url, (Object)file.getAbsolutePath());
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to download file " + url, e);
        }
    }

    public void deleteDownloadedFiles() {
        log.debug("Deleting downloaded files...");
        List<String> downloadedFiles = this.downloads();
        downloadedFiles.forEach(this::deleteDownloadedFile);
        log.debug("Deleted {} downloaded files", (Object)downloadedFiles.size());
    }

    public void deleteDownloadedFile(String fileName) {
        URL url = this.urlOfDownloadedFile(fileName);
        try {
            HttpURLConnection connection = this.connectionFromUrl(url);
            connection.setRequestMethod("DELETE");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new RuntimeException("Failed to deleted downloaded file " + fileName + ", received http status " + responseCode);
            }
            log.debug("Deleted downloaded file {}", (Object)url);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to download file " + url, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    @Nonnull
    public String getClipboardText() {
        try {
            HttpURLConnection connection = this.connectionFromUrl(this.url(this.baseUrl, "clipboard", this.sessionId));
            int code = connection.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("Something went wrong while getting clipboard! Response code: " + code);
            }
            try (InputStream in = connection.getInputStream();){
                String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Something went wrong while getting clipboard!", e);
        }
    }

    public void setClipboardText(String text) {
        try {
            HttpURLConnection connection = this.connectionFromUrl(this.url(this.baseUrl, "clipboard", this.sessionId));
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setConnectTimeout(10000);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());){
                writer.write(text);
            }
            int code = connection.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("Something went wrong while writing clipboard! Response code: " + code);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't set clipboard content! ", e);
        }
    }

    @CheckReturnValue
    @Nonnull
    URL urlOfDownloadedFile(String fileName) {
        return this.url(this.baseUrl, "download", this.sessionId, fileName);
    }

    @CheckReturnValue
    @Nonnull
    private URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to build valid URL from " + url, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    private URL url(String base, String ... pathSegments) {
        try {
            return new URIBuilder(base).setPathSegments(pathSegments).build().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Failed to build valid URL from " + base + '+' + Arrays.toString(pathSegments), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    @Nonnull
    private String readToString(URL url) {
        try (InputStream in = this.connectionFromUrl(url).getInputStream();){
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch data from " + url, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    private HttpURLConnection connectionFromUrl(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (url.getUserInfo() != null) {
            String basicAuth = "Basic " + new String(Base64.getEncoder().encode(url.getUserInfo().getBytes()));
            connection.setRequestProperty("Authorization", basicAuth);
        }
        return connection;
    }
}

