/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.OngoingMultipleElements;
import org.seleniumhq.selenium.fluent.OngoingSingleElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FluentCore {
    protected final WebDriver delegate;
    protected final String context;

    public FluentCore(WebDriver delegate, String context) {
        this.delegate = delegate;
        this.context = context;
    }

    public OngoingSingleElement span() {
        return this.single(By.tagName((String)"span"), "span");
    }

    public OngoingSingleElement span(By by) {
        return this.single(by, "span");
    }

    public OngoingMultipleElements spans() {
        return this.multiple(By.tagName((String)"span"), "span");
    }

    public OngoingMultipleElements spans(By by) {
        return this.multiple(by, "span");
    }

    public OngoingSingleElement div() {
        return this.single(By.tagName((String)"div"), "div");
    }

    public OngoingSingleElement div(By by) {
        return this.single(by, "div");
    }

    public OngoingMultipleElements divs() {
        return this.multiple(By.tagName((String)"div"), "div");
    }

    public OngoingMultipleElements divs(By by) {
        return this.multiple(by, "div");
    }

    public OngoingSingleElement button() {
        return this.single(By.tagName((String)"button"), "button");
    }

    public OngoingSingleElement button(By by) {
        return this.single(by, "button");
    }

    public OngoingMultipleElements buttons() {
        return this.multiple(By.tagName((String)"button"), "button");
    }

    public OngoingMultipleElements buttons(By by) {
        return this.multiple(by, "button");
    }

    public OngoingSingleElement link() {
        return this.single(By.tagName((String)"a"), "a");
    }

    public OngoingSingleElement link(By by) {
        return this.single(by, "a");
    }

    public OngoingMultipleElements links() {
        return this.multiple(By.tagName((String)"a"), "a");
    }

    public OngoingMultipleElements links(By by) {
        return this.multiple(by, "a");
    }

    public OngoingSingleElement input() {
        return this.single(By.tagName((String)"input"), "input");
    }

    public OngoingSingleElement input(By by) {
        return this.single(by, "input");
    }

    public OngoingMultipleElements inputs() {
        return this.multiple(By.tagName((String)"input"), "input");
    }

    public OngoingMultipleElements inputs(By by) {
        return this.multiple(by, "input");
    }

    public OngoingSingleElement select() {
        return this.single(By.tagName((String)"select"), "select");
    }

    public OngoingSingleElement select(By by) {
        return this.single(by, "select");
    }

    public OngoingMultipleElements selects() {
        return this.multiple(By.tagName((String)"select"), "select");
    }

    public OngoingMultipleElements selects(By by) {
        return this.multiple(by, "select");
    }

    public OngoingSingleElement h1() {
        return this.single(By.tagName((String)"h1"), "h1");
    }

    public OngoingSingleElement h1(By by) {
        return this.single(by, "h1");
    }

    public OngoingMultipleElements h1s() {
        return this.multiple(By.tagName((String)"h1"), "h1");
    }

    public OngoingMultipleElements h1s(By by) {
        return this.multiple(by, "h1");
    }

    public OngoingSingleElement h2() {
        return this.single(By.tagName((String)"h2"), "h2");
    }

    public OngoingSingleElement h2(By by) {
        return this.single(by, "h2");
    }

    public OngoingMultipleElements h2s() {
        return this.multiple(By.tagName((String)"h2"), "h2");
    }

    public OngoingMultipleElements h2s(By by) {
        return this.multiple(by, "h2");
    }

    public OngoingSingleElement h3() {
        return this.single(By.tagName((String)"h3"), "h3");
    }

    public OngoingMultipleElements h3s() {
        return this.multiple(By.tagName((String)"h3"), "h3");
    }

    public OngoingSingleElement h3(By by) {
        return this.single(by, "h3");
    }

    public OngoingMultipleElements h3s(By by) {
        return this.multiple(by, "h3");
    }

    public OngoingSingleElement h4() {
        return this.single(By.tagName((String)"h4"), "h4");
    }

    public OngoingMultipleElements h4s() {
        return this.multiple(By.tagName((String)"h4"), "h4");
    }

    public OngoingSingleElement h4(By by) {
        return this.single(by, "h4");
    }

    public OngoingMultipleElements h4s(By by) {
        return this.multiple(by, "h4");
    }

    public OngoingSingleElement p() {
        return this.single(By.tagName((String)"p"), "p");
    }

    public OngoingMultipleElements ps() {
        return this.multiple(By.tagName((String)"p"), "p");
    }

    public OngoingSingleElement p(By by) {
        return this.single(by, "p");
    }

    public OngoingMultipleElements ps(By by) {
        return this.multiple(by, "p");
    }

    public OngoingSingleElement img() {
        return this.single(By.tagName((String)"img"), "img");
    }

    public OngoingMultipleElements imgs() {
        return this.multiple(By.tagName((String)"img"), "img");
    }

    public OngoingSingleElement img(By by) {
        return this.single(by, "img");
    }

    public OngoingMultipleElements imgs(By by) {
        return this.multiple(by, "img");
    }

    public OngoingSingleElement table() {
        return this.single(By.tagName((String)"table"), "table");
    }

    public OngoingMultipleElements tables() {
        return this.multiple(By.tagName((String)"table"), "table");
    }

    public OngoingSingleElement table(By by) {
        return this.single(by, "table");
    }

    public OngoingMultipleElements tables(By by) {
        return this.multiple(by, "table");
    }

    public OngoingSingleElement tr() {
        return this.single(By.tagName((String)"tr"), "tr");
    }

    public OngoingMultipleElements trs() {
        return this.multiple(By.tagName((String)"tr"), "tr");
    }

    public OngoingSingleElement tr(By by) {
        return this.single(by, "tr");
    }

    public OngoingMultipleElements trs(By by) {
        return this.multiple(by, "tr");
    }

    public OngoingSingleElement td() {
        return this.single(By.tagName((String)"td"), "td");
    }

    public OngoingMultipleElements tds() {
        return this.multiple(By.tagName((String)"td"), "td");
    }

    public OngoingSingleElement td(By by) {
        return this.single(by, "td");
    }

    public OngoingMultipleElements tds(By by) {
        return this.multiple(by, "td");
    }

    public OngoingSingleElement th() {
        return this.single(By.tagName((String)"th"), "th");
    }

    public OngoingMultipleElements ths() {
        return this.multiple(By.tagName((String)"th"), "th");
    }

    public OngoingSingleElement th(By by) {
        return this.single(by, "th");
    }

    public OngoingMultipleElements ths(By by) {
        return this.multiple(by, "th");
    }

    public OngoingSingleElement ul() {
        return this.single(By.tagName((String)"ul"), "ul");
    }

    public OngoingMultipleElements uls() {
        return this.multiple(By.tagName((String)"ul"), "ul");
    }

    public OngoingSingleElement ul(By by) {
        return this.single(by, "ul");
    }

    public OngoingMultipleElements uls(By by) {
        return this.multiple(by, "ul");
    }

    public OngoingSingleElement ol() {
        return this.single(By.tagName((String)"ol"), "ol");
    }

    public OngoingMultipleElements ols() {
        return this.multiple(By.tagName((String)"ol"), "ol");
    }

    public OngoingSingleElement ol(By by) {
        return this.single(by, "ol");
    }

    public OngoingMultipleElements ols(By by) {
        return this.multiple(by, "ol");
    }

    public OngoingSingleElement form() {
        return this.single(By.tagName((String)"form"), "form");
    }

    public OngoingMultipleElements forms() {
        return this.multiple(By.tagName((String)"form"), "form");
    }

    public OngoingSingleElement form(By by) {
        return this.single(by, "form");
    }

    public OngoingMultipleElements forms(By by) {
        return this.multiple(by, "form");
    }

    public OngoingSingleElement textarea() {
        return this.single(By.tagName((String)"textarea"), "textarea");
    }

    public OngoingMultipleElements textareas() {
        return this.multiple(By.tagName((String)"textarea"), "textarea");
    }

    public OngoingSingleElement textarea(By by) {
        return this.single(by, "textarea");
    }

    public OngoingMultipleElements textareas(By by) {
        return this.multiple(by, "textarea");
    }

    public OngoingSingleElement option() {
        return this.single(By.tagName((String)"option"), "option");
    }

    public OngoingMultipleElements options() {
        return this.multiple(By.tagName((String)"option"), "option");
    }

    public OngoingSingleElement option(By by) {
        return this.single(by, "option");
    }

    public OngoingMultipleElements options(By by) {
        return this.multiple(by, "option");
    }

    public OngoingSingleElement li() {
        return this.single(By.tagName((String)"li"), "li");
    }

    public OngoingSingleElement li(By by) {
        return this.single(by, "li");
    }

    public OngoingMultipleElements lis() {
        return this.multiple(By.tagName((String)"li"), "li");
    }

    public OngoingMultipleElements lis(By by) {
        return this.multiple(by, "li");
    }

    protected abstract OngoingSingleElement getOngoingSingleElement(WebElement var1, String var2);

    protected abstract OngoingMultipleElements getOngoingMultipleElements(List<WebElement> var1, String var2);

    protected final By fixupBy(By by, String tagName) {
        if (by.getClass().getName().contains("ByXPath")) {
            by = By.xpath((String)(".//" + tagName + "[" + by.toString().substring(by.toString().indexOf(":") + 1).trim() + "]"));
        }
        return by;
    }

    protected final void assertTagIs(String is, String shouldBe) {
        if (!is.equals(shouldBe)) {
            throw new AssertionError((Object)("tag was incorrect, should have been " + shouldBe + " but was " + is));
        }
    }

    protected abstract WebElement findIt(By var1);

    protected abstract List<WebElement> findThem(By var1);

    private OngoingSingleElement single(By by, String tagName) {
        by = this.fixupBy(by, tagName);
        WebElement result = null;
        String ctx = this.contextualize(by.toString(), tagName);
        try {
            result = this.findIt(by);
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
        this.assertTagIs(result.getTagName(), tagName);
        return this.getOngoingSingleElement(result, ctx);
    }

    private String contextualize(String by, String tagName) {
        if (by.equals("By.tagName: " + tagName)) {
            by = "";
        }
        return this.context + "." + tagName + "(" + by + ")";
    }

    private OngoingMultipleElements multiple(By by, String tagName) {
        List<WebElement> results;
        by = this.fixupBy(by, tagName);
        String ctx = this.context + "." + tagName + "s(" + by + ")";
        try {
            results = this.findThem(by);
            for (WebElement webElement : results) {
                this.assertTagIs(webElement.getTagName(), tagName);
            }
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
        return this.getOngoingMultipleElements(results, ctx);
    }

    protected RuntimeException decorateWebDriverException(String ctx, WebDriverException e) {
        return new RuntimeException("WebDriver exception during invocation of : " + ctx, e);
    }
}

