/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentMatcher;
import org.seleniumhq.selenium.fluent.NothingMatches;
import org.seleniumhq.selenium.fluent.OngoingFluentWebDriver;
import org.seleniumhq.selenium.fluent.OngoingSingleElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OngoingMultipleElements
extends OngoingFluentWebDriver
implements List<WebElement> {
    private final List<WebElement> currentElements;

    public OngoingMultipleElements(WebDriver delegate, List<WebElement> currentElements, String context) {
        super(delegate, context);
        this.currentElements = currentElements;
    }

    @Override
    protected WebElement findIt(By by) {
        throw new UnsupportedOperationException("not applicable to this impl");
    }

    @Override
    protected List<WebElement> findThem(By by) {
        throw new UnsupportedOperationException("not applicable to this impl");
    }

    @Override
    public OngoingFluentWebDriver click() {
        String ctx = this.context + ".click()";
        try {
            for (WebElement webElement : this) {
                webElement.click();
            }
            return this.getOngoingMultipleElements(this, ctx);
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public OngoingFluentWebDriver clearField() {
        String ctx = this.context + ".clearField()";
        try {
            for (WebElement webElement : this) {
                webElement.clear();
            }
            return this.getOngoingMultipleElements(this, ctx);
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public OngoingFluentWebDriver submit() {
        String ctx = this.context + ".submit()";
        try {
            for (WebElement webElement : this) {
                webElement.submit();
            }
            return this.getOngoingMultipleElements(this, ctx);
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public OngoingFluentWebDriver sendKeys(CharSequence ... keysToSend) {
        String ctx = this.context + ".sendKeys(" + this.charSeqArrayAsHumanString(keysToSend) + ")";
        try {
            for (WebElement webElement : this) {
                webElement.sendKeys(keysToSend);
            }
            return this.getOngoingMultipleElements(this, ctx);
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public boolean isSelected() {
        String ctx = this.context + ".isSelected()";
        try {
            boolean areSelected = true;
            for (WebElement webElement : this) {
                areSelected &= webElement.isSelected();
            }
            return areSelected;
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public boolean isEnabled() {
        String ctx = this.context + ".isEnabled()";
        try {
            boolean areEnabled = true;
            for (WebElement webElement : this) {
                areEnabled &= webElement.isEnabled();
            }
            return areEnabled;
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public boolean isDisplayed() {
        String ctx = this.context + ".isDisplayed()";
        try {
            boolean areDisplayed = true;
            for (WebElement webElement : this) {
                areDisplayed &= webElement.isDisplayed();
            }
            return areDisplayed;
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public String getText() {
        String ctx = this.context + ".getText()";
        try {
            String text = "";
            for (WebElement webElement : this) {
                text = text + webElement.getText();
            }
            return text;
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public Point getLocation() {
        throw new UnsupportedOperationException("getLocation() has no meaning for multiple elements");
    }

    @Override
    public String getCssValue(String cssName) {
        throw new UnsupportedOperationException("getCssValue() has no meaning for multiple elements");
    }

    @Override
    public String getAttribute(String attrName) {
        throw new UnsupportedOperationException("getAttribute() has no meaning for multiple elements");
    }

    @Override
    public String getTagName() {
        throw new UnsupportedOperationException("getTagName() has no meaning for multiple elements");
    }

    @Override
    public Dimension getSize() {
        throw new UnsupportedOperationException("getSize() has no meaning for multiple elements");
    }

    public OngoingMultipleElements filter(FluentMatcher matcher) {
        String ctx = this.context + ".filter(" + matcher + ")";
        try {
            ArrayList<WebElement> results = new ArrayList<WebElement>();
            for (WebElement webElement : this) {
                if (!matcher.matches(webElement)) continue;
                results.add(webElement);
            }
            return this.getOngoingMultipleElements(results, ctx);
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    public OngoingSingleElement first(FluentMatcher matcher) {
        String ctx = this.context + ".filter(" + matcher + ")";
        try {
            WebElement result = null;
            for (WebElement webElement : this) {
                if (!matcher.matches(webElement)) continue;
                result = webElement;
                break;
            }
            if (result == null) {
                throw new NothingMatches();
            }
            return this.getOngoingSingleElement(result, this.context);
        }
        catch (WebDriverException e) {
            throw this.decorateWebDriverException(ctx, e);
        }
    }

    @Override
    public void clear() {
        this.currentElements.clear();
    }

    @Override
    public int size() {
        return this.currentElements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentElements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.currentElements.contains(o);
    }

    @Override
    public Iterator<WebElement> iterator() {
        return this.currentElements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.currentElements.toArray();
    }

    @Override
    public <WebElement> WebElement[] toArray(WebElement[] ts) {
        return this.currentElements.toArray(ts);
    }

    @Override
    public boolean add(WebElement webElement) {
        return this.currentElements.add(webElement);
    }

    @Override
    public boolean remove(Object o) {
        return this.currentElements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.currentElements.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends WebElement> webElements) {
        return this.currentElements.addAll(webElements);
    }

    @Override
    public boolean addAll(int i, Collection<? extends WebElement> webElements) {
        return this.currentElements.addAll(webElements);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.currentElements.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.currentElements.retainAll(objects);
    }

    @Override
    public WebElement get(int i) {
        return this.currentElements.get(i);
    }

    @Override
    public WebElement set(int i, WebElement webElement) {
        return this.currentElements.set(i, webElement);
    }

    @Override
    public void add(int i, WebElement webElement) {
        this.currentElements.add(i, webElement);
    }

    @Override
    public WebElement remove(int i) {
        return this.currentElements.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.currentElements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.currentElements.lastIndexOf(o);
    }

    @Override
    public ListIterator<WebElement> listIterator() {
        return this.currentElements.listIterator();
    }

    @Override
    public ListIterator<WebElement> listIterator(int i) {
        return this.currentElements.listIterator(i);
    }

    @Override
    public List<WebElement> subList(int i, int i1) {
        return this.currentElements.subList(i, i1);
    }
}

