/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.IllegalLocatorException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByXPath;

public abstract class FluentBy {
    public static By strictClassName(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        if (className.matches(".*\\s+.*")) {
            throw new IllegalLocatorException("Compound class names are not supported. Consider searching for one class name and filtering the results.");
        }
        return new ByStrictClassName(className);
    }

    public static By attribute(String name) {
        return FluentBy.attribute(name, null);
    }

    public static By attribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find elements when the attribute name is null");
        }
        return new ByAttribute(name, value);
    }

    public static By composite(By ... bys) {
        if (bys == null) {
            throw new IllegalArgumentException("Cannot make composite with no varargs of Bys");
        }
        if (!(bys.length == 2 && (FluentBy.isTagName(bys[0]) || FluentBy.isClassName(bys[1]) && bys[1] instanceof ByAttribute))) {
            throw new IllegalArgumentException("can only do this with By.tagName followed one of By.className or FluentBy.attribute");
        }
        return new ByComposite(bys);
    }

    private static boolean isTagName(By by) {
        String name = by.getClass().getName();
        return name.equals("org.openqa.selenium.By$ByTagName");
    }

    private static boolean isClassName(By by) {
        String name = by.getClass().getName();
        return name.equals("org.openqa.selenium.By$ByClassName");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByAttribute
    extends By {
        private final String name;
        private final String value;

        public ByAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public WebElement findElement(SearchContext context) {
            return this.makeXPath().findElement(context);
        }

        private By makeXPath() {
            return By.xpath((String)(".//*[" + this.nameAndValue() + "]"));
        }

        private String nameAndValue() {
            return "@" + this.name + this.val();
        }

        private String val() {
            return this.value == null ? "" : " = '" + this.value + "'";
        }

        public List<WebElement> findElements(SearchContext context) {
            return this.makeXPath().findElements(context);
        }

        public String toString() {
            return "By.attribute: " + this.name + this.val();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByStrictClassName
    extends By {
        private final String className;

        public ByStrictClassName(String className) {
            this.className = className;
        }

        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)context).findElementsByClassName(this.className);
            }
            return ((FindsByXPath)context).findElementsByXPath(".//*[@class = '" + this.className + "']");
        }

        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)context).findElementByClassName(this.className);
            }
            return ((FindsByXPath)context).findElementByXPath(".//*[@class = '" + this.className + "']");
        }

        public String toString() {
            return "By.strictClassName: " + this.className;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByComposite
    extends By {
        private final By[] bys;

        public ByComposite(By ... bys) {
            this.bys = bys;
        }

        public List<WebElement> findElements(SearchContext context) {
            return this.makeByXPath().findElements(context);
        }

        private String containingWord(String attribute, String word) {
            return "contains(concat(' ',normalize-space(@" + attribute + "),' '),' " + word + " ')";
        }

        private By makeByXPath() {
            String xpathExpression = ".//" + this.getTagName();
            if (FluentBy.isClassName(this.bys[1])) {
                String className = this.bys[1].toString().substring("By.className: ".length());
                xpathExpression = xpathExpression + "[" + this.containingWord("class", className) + "]";
            } else if (this.bys[1] instanceof ByAttribute) {
                ByAttribute by = (ByAttribute)this.bys[1];
                xpathExpression = xpathExpression + "[" + by.nameAndValue() + "]";
            } else {
                System.out.println();
            }
            return By.xpath((String)xpathExpression);
        }

        private String getTagName() {
            return this.bys[0].toString().substring("By.tagName: ".length());
        }

        public WebElement findElement(SearchContext context) {
            return this.makeByXPath().findElement(context);
        }

        public String toString() {
            return "composite(" + Arrays.asList(this.bys) + ")";
        }
    }
}

