/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentBy;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentSelect;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.FluentWebElements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FluentCore {
    protected final WebDriver delegate;
    protected final String context;

    public FluentCore(WebDriver delegate, String context) {
        this.delegate = delegate;
        this.context = context;
    }

    protected final <T> T makeFluentWebElement(WebDriver delegate, WebElement result, String context, Constructor<?> constructor) {
        try {
            return (T)constructor.newInstance(delegate, result, context);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public FluentWebElement span() {
        return this.single(By.tagName((String)"span"), "span", FluentWebElement.class);
    }

    public FluentWebElement span(By by) {
        return this.single(by, "span", FluentWebElement.class);
    }

    public FluentWebElements spans() {
        return this.multiple(By.tagName((String)"span"), "span");
    }

    public FluentWebElements spans(By by) {
        return this.multiple(by, "span");
    }

    public FluentWebElement div() {
        return this.single(By.tagName((String)"div"), "div", FluentWebElement.class);
    }

    public FluentWebElement div(By by) {
        return this.single(by, "div", FluentWebElement.class);
    }

    public FluentWebElements divs() {
        return this.multiple(By.tagName((String)"div"), "div");
    }

    public FluentWebElements divs(By by) {
        return this.multiple(by, "div");
    }

    public FluentWebElement button() {
        return this.single(By.tagName((String)"button"), "button", FluentWebElement.class);
    }

    public FluentWebElement button(By by) {
        return this.single(by, "button", FluentWebElement.class);
    }

    public FluentWebElements buttons() {
        return this.multiple(By.tagName((String)"button"), "button");
    }

    public FluentWebElements buttons(By by) {
        return this.multiple(by, "button");
    }

    public FluentWebElement link() {
        return this.single(By.tagName((String)"a"), "a", FluentWebElement.class);
    }

    public FluentWebElement link(By by) {
        return this.single(by, "a", FluentWebElement.class);
    }

    public FluentWebElements links() {
        return this.multiple(By.tagName((String)"a"), "a");
    }

    public FluentWebElements links(By by) {
        return this.multiple(by, "a");
    }

    public FluentWebElement input() {
        return this.single(By.tagName((String)"input"), "input", FluentWebElement.class);
    }

    public FluentWebElement input(By by) {
        return this.single(by, "input", FluentWebElement.class);
    }

    public FluentWebElements inputs() {
        return this.multiple(By.tagName((String)"input"), "input");
    }

    public FluentWebElements inputs(By by) {
        return this.multiple(by, "input");
    }

    public FluentSelect select() {
        return this.single(By.tagName((String)"select"), "select", FluentSelect.class);
    }

    public FluentSelect select(By by) {
        return this.single(by, "select", FluentSelect.class);
    }

    public FluentWebElements selects() {
        return this.multiple(By.tagName((String)"select"), "select");
    }

    public FluentWebElements selects(By by) {
        return this.multiple(by, "select");
    }

    public FluentWebElement h1() {
        return this.single(By.tagName((String)"h1"), "h1", FluentWebElement.class);
    }

    public FluentWebElement h1(By by) {
        return this.single(by, "h1", FluentWebElement.class);
    }

    public FluentWebElements h1s() {
        return this.multiple(By.tagName((String)"h1"), "h1");
    }

    public FluentWebElements h1s(By by) {
        return this.multiple(by, "h1");
    }

    public FluentWebElement h2() {
        return this.single(By.tagName((String)"h2"), "h2", FluentWebElement.class);
    }

    public FluentWebElement h2(By by) {
        return this.single(by, "h2", FluentWebElement.class);
    }

    public FluentWebElements h2s() {
        return this.multiple(By.tagName((String)"h2"), "h2");
    }

    public FluentWebElements h2s(By by) {
        return this.multiple(by, "h2");
    }

    public FluentWebElement h3() {
        return this.single(By.tagName((String)"h3"), "h3", FluentWebElement.class);
    }

    public FluentWebElements h3s() {
        return this.multiple(By.tagName((String)"h3"), "h3");
    }

    public FluentWebElement h3(By by) {
        return this.single(by, "h3", FluentWebElement.class);
    }

    public FluentWebElements h3s(By by) {
        return this.multiple(by, "h3");
    }

    public FluentWebElement h4() {
        return this.single(By.tagName((String)"h4"), "h4", FluentWebElement.class);
    }

    public FluentWebElements h4s() {
        return this.multiple(By.tagName((String)"h4"), "h4");
    }

    public FluentWebElement h4(By by) {
        return this.single(by, "h4", FluentWebElement.class);
    }

    public FluentWebElements h4s(By by) {
        return this.multiple(by, "h4");
    }

    public FluentWebElement p() {
        return this.single(By.tagName((String)"p"), "p", FluentWebElement.class);
    }

    public FluentWebElements ps() {
        return this.multiple(By.tagName((String)"p"), "p");
    }

    public FluentWebElement p(By by) {
        return this.single(by, "p", FluentWebElement.class);
    }

    public FluentWebElements ps(By by) {
        return this.multiple(by, "p");
    }

    public FluentWebElement img() {
        return this.single(By.tagName((String)"img"), "img", FluentWebElement.class);
    }

    public FluentWebElements imgs() {
        return this.multiple(By.tagName((String)"img"), "img");
    }

    public FluentWebElement img(By by) {
        return this.single(by, "img", FluentWebElement.class);
    }

    public FluentWebElements imgs(By by) {
        return this.multiple(by, "img");
    }

    public FluentWebElement table() {
        return this.single(By.tagName((String)"table"), "table", FluentWebElement.class);
    }

    public FluentWebElements tables() {
        return this.multiple(By.tagName((String)"table"), "table");
    }

    public FluentWebElement table(By by) {
        return this.single(by, "table", FluentWebElement.class);
    }

    public FluentWebElements tables(By by) {
        return this.multiple(by, "table");
    }

    public FluentWebElement tr() {
        return this.single(By.tagName((String)"tr"), "tr", FluentWebElement.class);
    }

    public FluentWebElements trs() {
        return this.multiple(By.tagName((String)"tr"), "tr");
    }

    public FluentWebElement tr(By by) {
        return this.single(by, "tr", FluentWebElement.class);
    }

    public FluentWebElements trs(By by) {
        return this.multiple(by, "tr");
    }

    public FluentWebElement td() {
        return this.single(By.tagName((String)"td"), "td", FluentWebElement.class);
    }

    public FluentWebElements tds() {
        return this.multiple(By.tagName((String)"td"), "td");
    }

    public FluentWebElement td(By by) {
        return this.single(by, "td", FluentWebElement.class);
    }

    public FluentWebElements tds(By by) {
        return this.multiple(by, "td");
    }

    public FluentWebElement th() {
        return this.single(By.tagName((String)"th"), "th", FluentWebElement.class);
    }

    public FluentWebElements ths() {
        return this.multiple(By.tagName((String)"th"), "th");
    }

    public FluentWebElement th(By by) {
        return this.single(by, "th", FluentWebElement.class);
    }

    public FluentWebElements ths(By by) {
        return this.multiple(by, "th");
    }

    public FluentWebElement ul() {
        return this.single(By.tagName((String)"ul"), "ul", FluentWebElement.class);
    }

    public FluentWebElements uls() {
        return this.multiple(By.tagName((String)"ul"), "ul");
    }

    public FluentWebElement ul(By by) {
        return this.single(by, "ul", FluentWebElement.class);
    }

    public FluentWebElements uls(By by) {
        return this.multiple(by, "ul");
    }

    public FluentWebElement ol() {
        return this.single(By.tagName((String)"ol"), "ol", FluentWebElement.class);
    }

    public FluentWebElements ols() {
        return this.multiple(By.tagName((String)"ol"), "ol");
    }

    public FluentWebElement ol(By by) {
        return this.single(by, "ol", FluentWebElement.class);
    }

    public FluentWebElements ols(By by) {
        return this.multiple(by, "ol");
    }

    public FluentWebElement form() {
        return this.single(By.tagName((String)"form"), "form", FluentWebElement.class);
    }

    public FluentWebElements forms() {
        return this.multiple(By.tagName((String)"form"), "form");
    }

    public FluentWebElement form(By by) {
        return this.single(by, "form", FluentWebElement.class);
    }

    public FluentWebElements forms(By by) {
        return this.multiple(by, "form");
    }

    public FluentWebElement textarea() {
        return this.single(By.tagName((String)"textarea"), "textarea", FluentWebElement.class);
    }

    public FluentWebElements textareas() {
        return this.multiple(By.tagName((String)"textarea"), "textarea");
    }

    public FluentWebElement textarea(By by) {
        return this.single(by, "textarea", FluentWebElement.class);
    }

    public FluentWebElements textareas(By by) {
        return this.multiple(by, "textarea");
    }

    public FluentWebElement option() {
        return this.single(By.tagName((String)"option"), "option", FluentWebElement.class);
    }

    public FluentWebElements options() {
        return this.multiple(By.tagName((String)"option"), "option");
    }

    public FluentWebElement option(By by) {
        return this.single(by, "option", FluentWebElement.class);
    }

    public FluentWebElements options(By by) {
        return this.multiple(by, "option");
    }

    public FluentWebElement li() {
        return this.single(By.tagName((String)"li"), "li", FluentWebElement.class);
    }

    public FluentWebElement li(By by) {
        return this.single(by, "li", FluentWebElement.class);
    }

    public FluentWebElements lis() {
        return this.multiple(By.tagName((String)"li"), "li");
    }

    public FluentWebElements lis(By by) {
        return this.multiple(by, "li");
    }

    protected abstract <T> T getFluentWebElement(WebElement var1, String var2, Class<T> var3);

    protected abstract FluentWebElements getOngoingMultipleElements(List<WebElement> var1, String var2);

    protected final By fixupBy(By by, String tagName) {
        if (by.getClass().getName().equals("org.openqa.selenium.By$ByXPath")) {
            by = By.xpath((String)(".//" + tagName + "[" + by.toString().substring(by.toString().indexOf(":") + 1).trim() + "]"));
        }
        if (by.getClass().getName().equals("org.openqa.selenium.By$ByClassName")) {
            by = FluentBy.composite(By.tagName((String)tagName), by);
        }
        return by;
    }

    protected final void assertTagIs(String is, String shouldBe) {
        if (!is.equals(shouldBe)) {
            throw new AssertionError((Object)("tag was incorrect, should have been " + shouldBe + " but was " + is));
        }
    }

    protected abstract WebElement findIt(By var1);

    protected abstract List<WebElement> findThem(By var1);

    private <T> T single(By by, String tagName, Class<T> resultingClass) {
        final By by2 = this.fixupBy(by, tagName);
        final WebElement[] result = new WebElement[1];
        String ctx = this.contextualize(by.toString(), tagName);
        this.execute(new Execution(){

            public void execute() {
                result[0] = FluentCore.this.findIt(by2);
            }
        }, ctx);
        this.assertTagIs(result[0].getTagName(), tagName);
        return this.getFluentWebElement(result[0], ctx, resultingClass);
    }

    private String contextualize(String by, String tagName) {
        if (by.equals("By.tagName: " + tagName)) {
            by = "";
        }
        return this.context + "." + tagName + "(" + by + ")";
    }

    private FluentWebElements multiple(By by, final String tagName) {
        final By by2 = this.fixupBy(by, tagName);
        String ctx = this.context + "." + tagName + "s(" + by + ")";
        final Object[] result = new Object[1];
        this.execute(new Execution(){

            public void execute() {
                List<WebElement> results = FluentCore.this.findThem(by2);
                for (WebElement webElement : results) {
                    FluentCore.this.assertTagIs(webElement.getTagName(), tagName);
                }
                result[0] = results;
            }
        }, ctx);
        return this.getOngoingMultipleElements((List)result[0], ctx);
    }

    protected RuntimeException decorateRuntimeException(String ctx, RuntimeException e) {
        return new FluentExecutionStopped("RuntimeException during invocation of: " + ctx, e);
    }

    protected RuntimeException decorateAssertionError(String ctx, AssertionError e) {
        return new FluentExecutionStopped("AssertionError during invocation of: " + ctx, (Throwable)((Object)e));
    }

    protected void execute(Execution execution, String ctx) {
        try {
            execution.execute();
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw this.decorateAssertionError(ctx, e);
        }
    }

    protected static interface Execution {
        public void execute();
    }
}

