/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentCore;
import org.seleniumhq.selenium.fluent.OngoingFluentWebDriver;
import org.seleniumhq.selenium.fluent.WebElementValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElement
extends OngoingFluentWebDriver {
    protected final WebElement currentElement;

    public FluentWebElement(WebDriver delegate, WebElement currentElement, String context) {
        super(delegate, context);
        this.currentElement = currentElement;
    }

    @Override
    protected WebElement findIt(By by) {
        return this.currentElement.findElement(by);
    }

    @Override
    protected List<WebElement> findThem(By by) {
        return this.currentElement.findElements(by);
    }

    public FluentWebElement click() {
        String ctx = this.context + ".click()";
        this.execute(new FluentCore.Execution(){

            public void execute() {
                FluentWebElement.this.currentElement.click();
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, ctx, FluentWebElement.class);
    }

    public FluentWebElement clearField() {
        String ctx = this.context + ".clearField()";
        this.execute(new FluentCore.Execution(){

            public void execute() {
                FluentWebElement.this.currentElement.clear();
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, ctx, FluentWebElement.class);
    }

    public FluentWebElement submit() {
        String ctx = this.context + ".submit()";
        this.execute(new FluentCore.Execution(){

            public void execute() {
                FluentWebElement.this.currentElement.submit();
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, ctx, FluentWebElement.class);
    }

    public FluentWebElement sendKeys(final CharSequence ... keysToSend) {
        String ctx = this.context + ".sendKeys(" + this.charSeqArrayAsHumanString(keysToSend) + ")";
        this.execute(new FluentCore.Execution(){

            public void execute() {
                FluentWebElement.this.currentElement.sendKeys(keysToSend);
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, ctx, FluentWebElement.class);
    }

    @Override
    public String getTagName() {
        String ctx = this.context + ".getTagName()";
        final String[] tn = new String[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                tn[0] = FluentWebElement.this.currentElement.getTagName();
            }
        }, ctx);
        return tn[0];
    }

    @Override
    public boolean isSelected() {
        String ctx = this.context + ".isSelected()";
        final boolean[] is = new boolean[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                is[0] = FluentWebElement.this.currentElement.isSelected();
            }
        }, ctx);
        return is[0];
    }

    @Override
    public boolean isEnabled() {
        String ctx = this.context + ".isEnabled()";
        final boolean[] is = new boolean[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                is[0] = FluentWebElement.this.currentElement.isEnabled();
            }
        }, ctx);
        return is[0];
    }

    @Override
    public boolean isDisplayed() {
        String ctx = this.context + ".isDisplayed()";
        final boolean[] is = new boolean[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                is[0] = FluentWebElement.this.currentElement.isDisplayed();
            }
        }, ctx);
        return is[0];
    }

    @Override
    public Point getLocation() {
        String ctx = this.context + ".getLocation()";
        final Point[] locn = new Point[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                locn[0] = FluentWebElement.this.currentElement.getLocation();
            }
        }, ctx);
        return locn[0];
    }

    @Override
    public Dimension getSize() {
        String ctx = this.context + ".getSize()";
        final Dimension[] dim = new Dimension[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                dim[0] = FluentWebElement.this.currentElement.getSize();
            }
        }, ctx);
        return dim[0];
    }

    @Override
    public String getCssValue(final String cssName) {
        String ctx = this.context + ".getCssValue(" + cssName + ")";
        final String[] val = new String[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                val[0] = FluentWebElement.this.currentElement.getCssValue(cssName);
            }
        }, ctx);
        return val[0];
    }

    @Override
    public String getAttribute(final String attr) {
        String ctx = this.context + ".getAttribute(" + attr + ")";
        final String[] val = new String[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                val[0] = FluentWebElement.this.currentElement.getAttribute(attr);
            }
        }, ctx);
        return val[0];
    }

    @Override
    public String getText() {
        String ctx = this.context + ".getText()";
        final String[] val = new String[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                val[0] = FluentWebElement.this.currentElement.getText();
            }
        }, ctx);
        return val[0];
    }

    public WebElementValue<Point> location() {
        return new WebElementValue<Point>(this.currentElement.getLocation(), this.context + ".location()");
    }

    public WebElementValue<Dimension> size() {
        return new WebElementValue<Dimension>(this.currentElement.getSize(), this.context + ".size()");
    }

    public WebElementValue<String> cssValue(String name) {
        return new WebElementValue<String>(this.currentElement.getCssValue(name), this.context + ".cssValue(" + name + ")");
    }

    public WebElementValue<String> attribute(String name) {
        return new WebElementValue<String>(this.currentElement.getAttribute(name), this.context + ".attribute(" + name + ")");
    }

    public WebElementValue<String> tagName() {
        return new WebElementValue<String>(this.currentElement.getTagName(), this.context + ".tagName()");
    }

    public WebElementValue<Boolean> selected() {
        return new WebElementValue<Boolean>(this.currentElement.isSelected(), this.context + ".selected()");
    }

    public WebElementValue<Boolean> enabled() {
        return new WebElementValue<Boolean>(this.currentElement.isEnabled(), this.context + ".enabled()");
    }

    public WebElementValue<Boolean> displayed() {
        return new WebElementValue<Boolean>(this.currentElement.isDisplayed(), this.context + ".displayed()");
    }

    public WebElementValue<String> text() {
        return new WebElementValue<String>(this.currentElement.getText(), this.context + ".text()");
    }
}

