/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentCore;
import org.seleniumhq.selenium.fluent.FluentMatcher;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.NothingMatches;
import org.seleniumhq.selenium.fluent.OngoingFluentWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FluentWebElements
extends OngoingFluentWebDriver
implements List<WebElement> {
    private final List<WebElement> currentElements;

    public FluentWebElements(WebDriver delegate, List<WebElement> currentElements, String context) {
        super(delegate, context);
        this.currentElements = currentElements;
    }

    @Override
    protected WebElement findIt(By by) {
        throw new UnsupportedOperationException("not applicable to this impl");
    }

    @Override
    protected List<WebElement> findThem(By by) {
        throw new UnsupportedOperationException("not applicable to this impl");
    }

    public FluentWebElements click() {
        String ctx = this.context + ".click()";
        this.execute(new FluentCore.Execution(){

            public void execute() {
                for (WebElement webElement : FluentWebElements.this) {
                    webElement.click();
                }
            }
        }, ctx);
        return this.getOngoingMultipleElements(this, ctx);
    }

    public FluentWebElements clearField() {
        String ctx = this.context + ".clearField()";
        this.execute(new FluentCore.Execution(){

            public void execute() {
                for (WebElement webElement : FluentWebElements.this) {
                    webElement.clear();
                }
            }
        }, ctx);
        return this.getOngoingMultipleElements(this, ctx);
    }

    public FluentWebElements submit() {
        String ctx = this.context + ".submit()";
        this.execute(new FluentCore.Execution(){

            public void execute() {
                for (WebElement webElement : FluentWebElements.this) {
                    webElement.submit();
                }
            }
        }, ctx);
        return this.getOngoingMultipleElements(this, ctx);
    }

    public FluentWebElements sendKeys(final CharSequence ... keysToSend) {
        String ctx = this.context + ".sendKeys(" + this.charSeqArrayAsHumanString(keysToSend) + ")";
        this.execute(new FluentCore.Execution(){

            public void execute() {
                for (WebElement webElement : FluentWebElements.this) {
                    webElement.sendKeys(keysToSend);
                }
            }
        }, ctx);
        return this.getOngoingMultipleElements(this, ctx);
    }

    @Override
    public boolean isSelected() {
        String ctx = this.context + ".isSelected()";
        final boolean[] are = new boolean[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                boolean areSelected = true;
                for (WebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isSelected();
                }
                are[0] = areSelected;
            }
        }, ctx);
        return are[0];
    }

    @Override
    public boolean isEnabled() {
        String ctx = this.context + ".isEnabled()";
        final boolean[] are = new boolean[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                boolean areSelected = true;
                for (WebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isEnabled();
                }
                are[0] = areSelected;
            }
        }, ctx);
        return are[0];
    }

    @Override
    public boolean isDisplayed() {
        String ctx = this.context + ".isDisplayed()";
        final boolean[] are = new boolean[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                boolean areSelected = true;
                for (WebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isDisplayed();
                }
                are[0] = areSelected;
            }
        }, ctx);
        return are[0];
    }

    @Override
    public String getText() {
        String ctx = this.context + ".getText()";
        final String[] val = new String[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                String text = "";
                for (WebElement webElement : FluentWebElements.this) {
                    text = text + webElement.getText();
                }
                val[0] = text;
            }
        }, ctx);
        return val[0];
    }

    @Override
    public Point getLocation() {
        throw new UnsupportedOperationException("getLocation() has no meaning for multiple elements");
    }

    @Override
    public String getCssValue(String cssName) {
        throw new UnsupportedOperationException("getCssValue() has no meaning for multiple elements");
    }

    @Override
    public String getAttribute(String attrName) {
        throw new UnsupportedOperationException("getAttribute() has no meaning for multiple elements");
    }

    @Override
    public String getTagName() {
        throw new UnsupportedOperationException("getTagName() has no meaning for multiple elements");
    }

    @Override
    public Dimension getSize() {
        throw new UnsupportedOperationException("getSize() has no meaning for multiple elements");
    }

    public FluentWebElements filter(final FluentMatcher matcher) {
        String ctx = this.context + ".filter(" + matcher + ")";
        final Object[] val = new Object[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                ArrayList<WebElement> results = new ArrayList<WebElement>();
                for (WebElement webElement : FluentWebElements.this) {
                    if (!matcher.matches(webElement)) continue;
                    results.add(webElement);
                }
                val[0] = results;
            }
        }, ctx);
        return this.getOngoingMultipleElements((List)val[0], ctx);
    }

    public FluentWebElement first(final FluentMatcher matcher) {
        String ctx = this.context + ".filter(" + matcher + ")";
        final Object[] val = new Object[1];
        this.execute(new FluentCore.Execution(){

            public void execute() {
                WebElement result = null;
                for (WebElement webElement : FluentWebElements.this) {
                    if (!matcher.matches(webElement)) continue;
                    result = webElement;
                    break;
                }
                val[0] = result == null ? new NothingMatches() : result;
            }
        }, ctx);
        if (val[0] instanceof NothingMatches) {
            throw (NothingMatches)val[0];
        }
        return this.getFluentWebElement((WebElement)val[0], this.context, FluentWebElement.class);
    }

    @Override
    public void clear() {
        this.currentElements.clear();
    }

    @Override
    public int size() {
        return this.currentElements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentElements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.currentElements.contains(o);
    }

    @Override
    public Iterator<WebElement> iterator() {
        return this.currentElements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.currentElements.toArray();
    }

    @Override
    public <WebElement> WebElement[] toArray(WebElement[] ts) {
        return this.currentElements.toArray(ts);
    }

    @Override
    public boolean add(WebElement webElement) {
        return this.currentElements.add(webElement);
    }

    @Override
    public boolean remove(Object o) {
        return this.currentElements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.currentElements.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends WebElement> webElements) {
        return this.currentElements.addAll(webElements);
    }

    @Override
    public boolean addAll(int i, Collection<? extends WebElement> webElements) {
        return this.currentElements.addAll(webElements);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.currentElements.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.currentElements.retainAll(objects);
    }

    @Override
    public WebElement get(int i) {
        return this.currentElements.get(i);
    }

    @Override
    public WebElement set(int i, WebElement webElement) {
        return this.currentElements.set(i, webElement);
    }

    @Override
    public void add(int i, WebElement webElement) {
        this.currentElements.add(i, webElement);
    }

    @Override
    public WebElement remove(int i) {
        return this.currentElements.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.currentElements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.currentElements.lastIndexOf(o);
    }

    @Override
    public ListIterator<WebElement> listIterator() {
        return this.currentElements.listIterator();
    }

    @Override
    public ListIterator<WebElement> listIterator(int i) {
        return this.currentElements.listIterator(i);
    }

    @Override
    public List<WebElement> subList(int i, int i1) {
        return this.currentElements.subList(i, i1);
    }
}

