/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentSelect
extends FluentWebElement {
    private Select currentSelect;

    public FluentSelect(WebDriver delegate, WebElement currentElement, String context) {
        super(delegate, currentElement, context);
    }

    private FluentSelect(WebDriver delegate, Select currentSelect, WebElement currentElement, String context) {
        super(delegate, currentElement, context);
        this.currentSelect = currentSelect;
    }

    public boolean isMultiple() {
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                return FluentSelect.this.getSelect().isMultiple();
            }
        }, this.context + ".isMultiple()");
    }

    public List<WebElement> getOptions() {
        return this.decorateExecution(new Execution<List<WebElement>>(){

            @Override
            public List<WebElement> execute() {
                return FluentSelect.this.getSelect().getOptions();
            }
        }, this.context + ".getOptions()");
    }

    public List<WebElement> getAllSelectedOptions() {
        return this.decorateExecution(new Execution<List<WebElement>>(){

            @Override
            public List<WebElement> execute() {
                return FluentSelect.this.getSelect().getAllSelectedOptions();
            }
        }, this.context + ".getAllSelectedOptions()");
    }

    public WebElement getFirstSelectedOption() {
        return this.decorateExecution(new Execution<WebElement>(){

            @Override
            public WebElement execute() {
                return FluentSelect.this.getSelect().getFirstSelectedOption();
            }
        }, this.context + ".getFirstSelectedOption()");
    }

    public FluentSelect selectByVisibleText(final String text) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().selectByVisibleText(text);
                return true;
            }
        }, this.context + ".selectByVisibleText(" + text + ")");
        return this.getFluentWebElement(this.currentElement, this.context, FluentSelect.class);
    }

    public FluentSelect selectByIndex(final int index) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().selectByIndex(index);
                return true;
            }
        }, this.context + ".selectByIndex(" + index + ")");
        return this.getFluentWebElement(this.currentElement, this.context, FluentSelect.class);
    }

    public FluentSelect selectByValue(final String value) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().selectByValue(value);
                return true;
            }
        }, this.context + ".selectByValue(" + value + ")");
        return this.getFluentWebElement(this.currentElement, this.context, FluentSelect.class);
    }

    public FluentSelect deselectAll() {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().deselectAll();
                return true;
            }
        }, this.context + ".deselectAll()");
        return this.getFluentWebElement(this.currentElement, this.context, FluentSelect.class);
    }

    public FluentSelect deselectByValue(final String value) {
        String ctx = this.context + ".deselectByValue(" + value + ")";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().deselectByValue(value);
                return true;
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, this.context, FluentSelect.class);
    }

    public FluentSelect deselectByIndex(final int index) {
        String ctx = this.context + ".deselectByIndex(" + index + ")";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().deselectByIndex(index);
                return true;
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, this.context, FluentSelect.class);
    }

    public FluentSelect deselectByVisibleText(final String text) {
        String ctx = this.context + ".deselectByVisibleText(" + text + ")";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().deselectByVisibleText(text);
                return true;
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, this.context, FluentSelect.class);
    }

    protected synchronized Select getSelect() {
        if (this.currentSelect == null) {
            this.currentSelect = new Select(this.currentElement);
        }
        return this.currentSelect;
    }

    @Override
    public FluentSelect within(Period period) {
        return new MorePatientFluentSelect(this.delegate, this.context + ".within(" + period + ")", this.currentSelect, this.currentElement, period);
    }

    private class MorePatientFluentSelect
    extends FluentSelect {
        private final Period period;

        public MorePatientFluentSelect(WebDriver webDriver, String context, Select currentSelect, WebElement currentElement, Period period) {
            super(webDriver, currentSelect, currentElement, context);
            this.period = period;
        }

        protected Period getPeriod() {
            return this.period;
        }

        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
        }

        protected void resetTimeout() {
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

