/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.BaseFluentWebDriver;
import org.seleniumhq.selenium.fluent.FluentWebDriver;
import org.seleniumhq.selenium.fluent.FluentWebElements;
import org.seleniumhq.selenium.fluent.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebDriverImpl
extends BaseFluentWebDriver
implements FluentWebDriver {
    public FluentWebDriverImpl(WebDriver delegate) {
        super(delegate, "?");
    }

    protected FluentWebDriverImpl(WebDriver delegate, String context) {
        super(delegate, context);
    }

    @Override
    protected <T> T getFluentWebElement(WebElement result, String context, Class<T> webElementClass) {
        return this.makeFluentWebElement(this.delegate, result, context, webElementClass.getConstructors()[0]);
    }

    @Override
    protected FluentWebElements getFluentWebElements(List<WebElement> results, String context) {
        return new FluentWebElements(this.delegate, results, context);
    }

    @Override
    protected WebElement findIt(By by) {
        return this.delegate.findElement(by);
    }

    @Override
    protected List<WebElement> findThem(By by) {
        return this.delegate.findElements(by);
    }

    @Override
    public FluentWebDriverImpl within(Period period) {
        return new RetryingFluentWebDriver(this.delegate, period, this.context + ".within(" + period + ")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RetryingFluentWebDriver
    extends FluentWebDriverImpl {
        private final Period period;

        public RetryingFluentWebDriver(WebDriver webDriver, Period period, String context) {
            super(webDriver, context);
            this.period = period;
        }

        @Override
        protected WebElement findIt(By by) {
            long endMillis = this.period.getEndMillis();
            Throwable exceptionToRetry = new RuntimeException();
            WebElement it = null;
            while (exceptionToRetry != null && endMillis - System.currentTimeMillis() > 0L) {
                try {
                    it = super.findIt(by);
                    exceptionToRetry = null;
                    return it;
                }
                catch (WebDriverException e) {
                    exceptionToRetry = e;
                }
            }
            if (exceptionToRetry != null) {
                throw exceptionToRetry;
            }
            return it;
        }

        @Override
        protected List<WebElement> findThem(By by) {
            long endMillis = this.period.getEndMillis();
            Throwable exceptionToRetry = new RuntimeException();
            List<WebElement> them = null;
            while (exceptionToRetry != null && endMillis - System.currentTimeMillis() > 0L) {
                try {
                    them = super.findThem(by);
                    exceptionToRetry = null;
                    return them;
                }
                catch (WebDriverException e) {
                    exceptionToRetry = e;
                }
            }
            if (exceptionToRetry != null) {
                throw exceptionToRetry;
            }
            return them;
        }

        @Override
        protected Period getPeriod() {
            return this.period;
        }

        @Override
        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
            waiting.set(new BaseFluentWebDriver.WaitContext(this.period));
        }

        @Override
        protected void resetTimeout() {
            waiting.set(null);
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

