/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.BaseFluentWebElement;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.WebElementValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElement
extends BaseFluentWebElement {
    protected final WebElement currentElement;

    public FluentWebElement(WebDriver delegate, WebElement currentElement, String context) {
        super(delegate, context);
        this.currentElement = currentElement;
    }

    @Override
    protected WebElement findIt(By by) {
        return this.currentElement.findElement(by);
    }

    @Override
    protected List<WebElement> findThem(By by) {
        return this.currentElement.findElements(by);
    }

    public FluentWebElement click() {
        String ctx = this.context + ".click()";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentWebElement.this.currentElement.click();
                return true;
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, ctx, FluentWebElement.class);
    }

    public FluentWebElement clearField() {
        String ctx = this.context + ".clearField()";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentWebElement.this.currentElement.clear();
                return true;
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, ctx, FluentWebElement.class);
    }

    public FluentWebElement submit() {
        String ctx = this.context + ".submit()";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentWebElement.this.currentElement.submit();
                return true;
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, ctx, FluentWebElement.class);
    }

    public FluentWebElement sendKeys(final CharSequence ... keysToSend) {
        String ctx = this.context + ".sendKeys(" + this.charSeqArrayAsHumanString(keysToSend) + ")";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentWebElement.this.currentElement.sendKeys(keysToSend);
                return true;
            }
        }, ctx);
        return this.getFluentWebElement(this.currentElement, ctx, FluentWebElement.class);
    }

    @Override
    public TestableString getTagName() {
        return new TestableString(this.getPeriod(), new Execution<String>(){

            @Override
            public String execute() {
                return FluentWebElement.this.currentElement.getTagName();
            }
        }, this.context + ".getTagName()");
    }

    @Override
    public boolean isSelected() {
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                return FluentWebElement.this.currentElement.isSelected();
            }
        }, this.context + ".isSelected()");
    }

    @Override
    public boolean isEnabled() {
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                return FluentWebElement.this.currentElement.isEnabled();
            }
        }, this.context + ".isEnabled()");
    }

    @Override
    public boolean isDisplayed() {
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                return FluentWebElement.this.currentElement.isDisplayed();
            }
        }, this.context + ".isDisplayed()");
    }

    @Override
    public Point getLocation() {
        return this.decorateExecution(new Execution<Point>(){

            @Override
            public Point execute() {
                return FluentWebElement.this.currentElement.getLocation();
            }
        }, this.context + ".getLocation()");
    }

    @Override
    public Dimension getSize() {
        return this.decorateExecution(new Execution<Dimension>(){

            @Override
            public Dimension execute() {
                return FluentWebElement.this.currentElement.getSize();
            }
        }, this.context + ".getSize()");
    }

    @Override
    public TestableString getCssValue(final String cssName) {
        return new TestableString(this.getPeriod(), new Execution<String>(){

            @Override
            public String execute() {
                return FluentWebElement.this.currentElement.getCssValue(cssName);
            }
        }, this.context + ".getCssValue(" + cssName + ")");
    }

    @Override
    public TestableString getAttribute(final String attr) {
        return new TestableString(this.getPeriod(), new Execution<String>(){

            @Override
            public String execute() {
                return FluentWebElement.this.currentElement.getAttribute(attr);
            }
        }, this.context + ".getAttribute(" + attr + ")");
    }

    @Override
    public TestableString getText() {
        return new TestableString(this.getPeriod(), new Execution<String>(){

            @Override
            public String execute() {
                return FluentWebElement.this.currentElement.getText();
            }
        }, this.context + ".getText()");
    }

    public WebElementValue<Point> location() {
        return new WebElementValue<Point>(this.currentElement.getLocation(), this.context + ".location()");
    }

    public WebElementValue<Dimension> size() {
        return new WebElementValue<Dimension>(this.currentElement.getSize(), this.context + ".size()");
    }

    public WebElementValue<String> cssValue(String name) {
        return new WebElementValue<String>(this.currentElement.getCssValue(name), this.context + ".cssValue(" + name + ")");
    }

    public WebElementValue<String> attribute(String name) {
        return new WebElementValue<String>(this.currentElement.getAttribute(name), this.context + ".attribute(" + name + ")");
    }

    public WebElementValue<String> tagName() {
        return new WebElementValue<String>(this.currentElement.getTagName(), this.context + ".tagName()");
    }

    public WebElementValue<Boolean> selected() {
        return new WebElementValue<Boolean>(this.currentElement.isSelected(), this.context + ".selected()");
    }

    public WebElementValue<Boolean> enabled() {
        return new WebElementValue<Boolean>(this.currentElement.isEnabled(), this.context + ".enabled()");
    }

    public WebElementValue<Boolean> displayed() {
        return new WebElementValue<Boolean>(this.currentElement.isDisplayed(), this.context + ".displayed()");
    }

    public WebElementValue<String> text() {
        return new WebElementValue<String>(this.currentElement.getText(), this.context + ".text()");
    }

    @Override
    public FluentWebElement within(Period period) {
        return new RetryingFluentWebElement(this.delegate, this.currentElement, this.context + ".within(" + period + ")", period);
    }

    private class RetryingFluentWebElement
    extends FluentWebElement {
        private final Period period;

        public RetryingFluentWebElement(WebDriver webDriver, WebElement currentElement, String context, Period period) {
            super(webDriver, currentElement, context);
            this.period = period;
        }

        protected Period getPeriod() {
            return this.period;
        }

        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
        }

        protected void resetTimeout() {
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

