/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.BaseFluentWebElement;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.FluentMatcher;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.NothingMatches;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FluentWebElements
extends BaseFluentWebElement
implements List<WebElement> {
    private final List<WebElement> currentElements;

    public FluentWebElements(WebDriver delegate, List<WebElement> currentElements, String context) {
        super(delegate, context);
        this.currentElements = currentElements;
    }

    public FluentWebElements click() {
        String ctx = this.context + ".click()";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                for (WebElement webElement : FluentWebElements.this) {
                    webElement.click();
                }
                return true;
            }
        }, ctx);
        return this.getFluentWebElements(this, ctx);
    }

    public FluentWebElements clearField() {
        String ctx = this.context + ".clearField()";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                for (WebElement webElement : FluentWebElements.this) {
                    webElement.clear();
                }
                return true;
            }
        }, ctx);
        return this.getFluentWebElements(this, ctx);
    }

    public FluentWebElements submit() {
        String ctx = this.context + ".submit()";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                for (WebElement webElement : FluentWebElements.this) {
                    webElement.submit();
                }
                return true;
            }
        }, ctx);
        return this.getFluentWebElements(this, ctx);
    }

    public FluentWebElements sendKeys(final CharSequence ... keysToSend) {
        String ctx = this.context + ".sendKeys(" + this.charSeqArrayAsHumanString(keysToSend) + ")";
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                for (WebElement webElement : FluentWebElements.this) {
                    webElement.sendKeys(keysToSend);
                }
                return true;
            }
        }, ctx);
        return this.getFluentWebElements(this, ctx);
    }

    @Override
    public boolean isSelected() {
        String ctx = this.context + ".isSelected()";
        boolean areSelected = this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                boolean areSelected = true;
                for (WebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isSelected();
                }
                return areSelected;
            }
        }, ctx);
        return areSelected;
    }

    @Override
    public boolean isEnabled() {
        String ctx = this.context + ".isEnabled()";
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                boolean areSelected = true;
                for (WebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isEnabled();
                }
                return areSelected;
            }
        }, ctx);
    }

    @Override
    public boolean isDisplayed() {
        String ctx = this.context + ".isDisplayed()";
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                boolean areSelected = true;
                for (WebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isDisplayed();
                }
                return areSelected;
            }
        }, ctx);
    }

    @Override
    public TestableString getText() {
        String ctx = this.context + ".getText()";
        Execution<String> execution = new Execution<String>(){

            @Override
            public String execute() {
                String text = "";
                for (WebElement webElement : FluentWebElements.this) {
                    text = text + webElement.getText();
                }
                return text;
            }
        };
        return new TestableString(this.getPeriod(), execution, ctx);
    }

    @Override
    protected WebElement findIt(By by) {
        throw this.meaningless("findIt('" + by + "')");
    }

    @Override
    protected List<WebElement> findThem(By by) {
        throw this.meaningless("findThem('" + by + "')");
    }

    @Override
    public Point getLocation() {
        throw this.meaningless("getLocation()");
    }

    private UnsupportedOperationException meaningless(String invocation) {
        return new UnsupportedOperationException(invocation + " has no meaning for multiple elements");
    }

    @Override
    public TestableString getCssValue(String cssName) {
        throw this.meaningless("getCssValue('" + cssName + "')");
    }

    @Override
    public TestableString getAttribute(String attrName) {
        throw this.meaningless("getAttribute('" + attrName + "')");
    }

    @Override
    public TestableString getTagName() {
        throw this.meaningless("getTagName()");
    }

    @Override
    public Dimension getSize() {
        throw this.meaningless("getSize()");
    }

    @Override
    public FluentWebElements within(Period p) {
        throw this.meaningless("within(" + p + ")");
    }

    public FluentWebElements filter(final FluentMatcher matcher) {
        String ctx = this.context + ".filter(" + matcher + ")";
        List<WebElement> subset = this.decorateExecution(new Execution<List<WebElement>>(){

            @Override
            public List<WebElement> execute() {
                ArrayList<WebElement> results = new ArrayList<WebElement>();
                for (WebElement webElement : FluentWebElements.this) {
                    if (!matcher.matches(webElement)) continue;
                    results.add(webElement);
                }
                return results;
            }
        }, ctx);
        return this.getFluentWebElements(subset, ctx);
    }

    public FluentWebElement first(final FluentMatcher matcher) {
        String ctx = this.context + ".filter(" + matcher + ")";
        WebElement first = this.decorateExecution(new Execution<WebElement>(){

            @Override
            public WebElement execute() {
                WebElement result = null;
                for (WebElement webElement : FluentWebElements.this) {
                    if (!matcher.matches(webElement)) continue;
                    result = webElement;
                    break;
                }
                if (result == null) {
                    throw new NothingMatches();
                }
                return result;
            }
        }, ctx);
        return this.getFluentWebElement(first, this.context, FluentWebElement.class);
    }

    @Override
    public void clear() {
        this.currentElements.clear();
    }

    @Override
    public int size() {
        return this.currentElements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentElements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.currentElements.contains(o);
    }

    @Override
    public Iterator<WebElement> iterator() {
        return this.currentElements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.currentElements.toArray();
    }

    @Override
    public <WebElement> WebElement[] toArray(WebElement[] ts) {
        return this.currentElements.toArray(ts);
    }

    @Override
    public boolean add(WebElement webElement) {
        return this.currentElements.add(webElement);
    }

    @Override
    public boolean remove(Object o) {
        return this.currentElements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.currentElements.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends WebElement> webElements) {
        return this.currentElements.addAll(webElements);
    }

    @Override
    public boolean addAll(int i, Collection<? extends WebElement> webElements) {
        return this.currentElements.addAll(webElements);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.currentElements.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.currentElements.retainAll(objects);
    }

    @Override
    public WebElement get(int i) {
        return this.currentElements.get(i);
    }

    @Override
    public WebElement set(int i, WebElement webElement) {
        return this.currentElements.set(i, webElement);
    }

    @Override
    public void add(int i, WebElement webElement) {
        this.currentElements.add(i, webElement);
    }

    @Override
    public WebElement remove(int i) {
        return this.currentElements.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.currentElements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.currentElements.lastIndexOf(o);
    }

    @Override
    public ListIterator<WebElement> listIterator() {
        return this.currentElements.listIterator();
    }

    @Override
    public ListIterator<WebElement> listIterator(int i) {
        return this.currentElements.listIterator(i);
    }

    @Override
    public List<WebElement> subList(int i, int i1) {
        return this.currentElements.subList(i, i1);
    }
}

