/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentWebElements;
import org.seleniumhq.selenium.fluent.Internal;
import org.seleniumhq.selenium.fluent.Monitor;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.TestableValue;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElement
extends Internal.BaseFluentWebElement {
    protected final Internal.BaseFluentWebDriver.WebElementHolder currentElement;

    protected FluentWebElement(WebDriver delegate, Internal.BaseFluentWebDriver.WebElementHolder currentElement, Context context, Monitor monitor) {
        super(delegate, context, monitor);
        this.currentElement = currentElement;
    }

    @Override
    protected SearchContext getSearchContext() {
        return this.currentElement.getFound();
    }

    protected WebElement getWebElement() {
        return this.currentElement.getFound();
    }

    @Override
    protected WebElement findIt(By by, Context ctx) {
        return this.actualFindIt(by, ctx);
    }

    @Override
    protected List<WebElement> findThem(By by, Context ctx) {
        return this.actualFindThem(by, ctx);
    }

    @Override
    protected WebElement actualFindIt(By by, Context ctx) {
        return this.currentElement.getFound().findElement(by);
    }

    @Override
    protected List<WebElement> actualFindThem(By by, Context ctx) {
        return this.currentElement.getFound().findElements(by);
    }

    public FluentWebElement click() {
        Context ctx = Context.singular(this.context, "click");
        this.decorateExecution(new Click(), ctx);
        return new FluentWebElement(this.delegate, this.currentElement, ctx, this.monitor);
    }

    public FluentWebElement clearField() {
        Context ctx = Context.singular(this.context, "clearField");
        this.decorateExecution(new Clear(), ctx);
        return new FluentWebElement(this.delegate, this.currentElement, ctx, this.monitor);
    }

    public FluentWebElement submit() {
        this.decorateExecution(new Submit(), Context.singular(this.context, "submit"));
        return new FluentWebElement(this.delegate, this.currentElement, this.context, this.monitor);
    }

    public FluentWebElement sendKeys(CharSequence ... keysToSend) {
        this.decorateExecution(new SendKeys(keysToSend), Context.singular(this.context, "sendKeys", null, this.charSeqArrayAsHumanString(keysToSend)));
        return new FluentWebElement(this.delegate, this.currentElement, this.context, this.monitor);
    }

    public TestableString getTagName() {
        return new TestableString(new GetTagName(), Context.singular(this.context, "getTagName"));
    }

    public TestableValue<Boolean> isSelected() {
        Context isSelected = Context.singular(this.context, "isSelected");
        return new TestableValue<Boolean>(new IsSelected(), isSelected);
    }

    public TestableValue<Boolean> isEnabled() {
        Context isEnabled = Context.singular(this.context, "isEnabled");
        return new TestableValue<Boolean>(new IsEnabled(), isEnabled);
    }

    public TestableValue<Boolean> isDisplayed() {
        Context isDisplayed = Context.singular(this.context, "isDisplayed");
        return new TestableValue<Boolean>(new IsDisplayed(), isDisplayed);
    }

    public TestableValue<Point> getLocation() {
        Context getLocation = Context.singular(this.context, "getLocation");
        return new TestableValue<Point>(new GetLocation(), getLocation);
    }

    public TestableValue<Dimension> getSize() {
        Context getSize = Context.singular(this.context, "getSize");
        return new TestableValue<Dimension>(new GetSize(), getSize);
    }

    public TestableString getCssValue(String cssName) {
        return new TestableString(new GetCssValue(cssName), Context.singular(this.context, "getCssValue", null, cssName)).within(this.getPeriod());
    }

    public TestableString getAttribute(String attr) {
        return new TestableString(new GetAttribute(attr), Context.singular(this.context, "getAttribute", null, attr)).within(this.getPeriod());
    }

    public TestableString getText() {
        return new TestableString(new GetText(), Context.singular(this.context, "getText")).within(this.getPeriod());
    }

    public FluentWebElement within(Period period) {
        return new RetryingFluentWebElement(this.delegate, this.currentElement, Context.singular(this.context, "within", null, period), period, this.monitor);
    }

    public NegatingFluentWebElement without(Period period) {
        return new NegatingFluentWebElement(this.delegate, this.currentElement, period, Context.singular(this.context, "without", null, period), this.monitor);
    }

    @Override
    public FluentWebElement span() {
        return (FluentWebElement)super.span();
    }

    @Override
    public FluentWebElement span(By by) {
        return (FluentWebElement)super.span(by);
    }

    @Override
    public FluentWebElements spans() {
        return (FluentWebElements)super.spans();
    }

    @Override
    public FluentWebElements spans(By by) {
        return (FluentWebElements)super.spans(by);
    }

    @Override
    public FluentWebElement div() {
        return (FluentWebElement)super.div();
    }

    @Override
    public FluentWebElement div(By by) {
        return (FluentWebElement)super.div(by);
    }

    @Override
    public FluentWebElements divs() {
        return (FluentWebElements)super.divs();
    }

    @Override
    public FluentWebElements divs(By by) {
        return (FluentWebElements)super.divs(by);
    }

    @Override
    public FluentWebElement button() {
        return (FluentWebElement)super.button();
    }

    @Override
    public FluentWebElement button(By by) {
        return (FluentWebElement)super.button(by);
    }

    @Override
    public FluentWebElements buttons() {
        return (FluentWebElements)super.buttons();
    }

    @Override
    public FluentWebElements buttons(By by) {
        return (FluentWebElements)super.buttons(by);
    }

    @Override
    public FluentWebElement link() {
        return (FluentWebElement)super.link();
    }

    @Override
    public FluentWebElement link(By by) {
        return (FluentWebElement)super.link(by);
    }

    @Override
    public FluentWebElements links() {
        return (FluentWebElements)super.links();
    }

    @Override
    public FluentWebElements links(By by) {
        return (FluentWebElements)super.links(by);
    }

    @Override
    public FluentWebElement input() {
        return (FluentWebElement)super.input();
    }

    @Override
    public FluentWebElement input(By by) {
        return (FluentWebElement)super.input(by);
    }

    @Override
    public FluentWebElements inputs() {
        return (FluentWebElements)super.inputs();
    }

    @Override
    public FluentWebElements inputs(By by) {
        return (FluentWebElements)super.inputs(by);
    }

    @Override
    public FluentWebElement option() {
        return (FluentWebElement)super.option();
    }

    @Override
    public FluentWebElements options() {
        return (FluentWebElements)super.options();
    }

    @Override
    public FluentWebElement option(By by) {
        return (FluentWebElement)super.option(by);
    }

    @Override
    public FluentWebElements options(By by) {
        return (FluentWebElements)super.options(by);
    }

    @Override
    public FluentWebElement textarea() {
        return (FluentWebElement)super.textarea();
    }

    @Override
    public FluentWebElements textareas() {
        return (FluentWebElements)super.textareas();
    }

    @Override
    public FluentWebElement textarea(By by) {
        return (FluentWebElement)super.textarea(by);
    }

    @Override
    public FluentWebElements textareas(By by) {
        return (FluentWebElements)super.textareas(by);
    }

    @Override
    public FluentWebElement h1() {
        return (FluentWebElement)super.h1();
    }

    @Override
    public FluentWebElement h1(By by) {
        return (FluentWebElement)super.h1(by);
    }

    @Override
    public FluentWebElements h1s() {
        return (FluentWebElements)super.h1s();
    }

    @Override
    public FluentWebElements h1s(By by) {
        return (FluentWebElements)super.h1s(by);
    }

    @Override
    public FluentWebElement h2() {
        return (FluentWebElement)super.h2();
    }

    @Override
    public FluentWebElement h2(By by) {
        return (FluentWebElement)super.h2(by);
    }

    @Override
    public FluentWebElements h2s() {
        return (FluentWebElements)super.h2s();
    }

    @Override
    public FluentWebElements h2s(By by) {
        return (FluentWebElements)super.h2s(by);
    }

    @Override
    public FluentWebElement h3() {
        return (FluentWebElement)super.h3();
    }

    @Override
    public FluentWebElement h3(By by) {
        return (FluentWebElement)super.h3(by);
    }

    @Override
    public FluentWebElements h3s() {
        return (FluentWebElements)super.h3s();
    }

    @Override
    public FluentWebElements h3s(By by) {
        return (FluentWebElements)super.h3s(by);
    }

    @Override
    public FluentWebElement h4() {
        return (FluentWebElement)super.h4();
    }

    @Override
    public FluentWebElement h4(By by) {
        return (FluentWebElement)super.h4(by);
    }

    @Override
    public FluentWebElements h4s() {
        return (FluentWebElements)super.h4s();
    }

    @Override
    public FluentWebElements h4s(By by) {
        return (FluentWebElements)super.h4s(by);
    }

    @Override
    public FluentWebElement td() {
        return (FluentWebElement)super.td();
    }

    @Override
    public FluentWebElement td(By by) {
        return (FluentWebElement)super.td(by);
    }

    @Override
    public FluentWebElements tds() {
        return (FluentWebElements)super.tds();
    }

    @Override
    public FluentWebElements tds(By by) {
        return (FluentWebElements)super.tds(by);
    }

    @Override
    public FluentWebElement form() {
        return (FluentWebElement)super.form();
    }

    @Override
    public FluentWebElement form(By by) {
        return (FluentWebElement)super.form(by);
    }

    @Override
    public FluentWebElements forms() {
        return (FluentWebElements)super.forms();
    }

    @Override
    public FluentWebElements forms(By by) {
        return (FluentWebElements)super.forms(by);
    }

    @Override
    public FluentWebElement table() {
        return (FluentWebElement)super.table();
    }

    @Override
    public FluentWebElement table(By by) {
        return (FluentWebElement)super.table(by);
    }

    @Override
    public FluentWebElements tables() {
        return (FluentWebElements)super.tables();
    }

    @Override
    public FluentWebElements tables(By by) {
        return (FluentWebElements)super.tables(by);
    }

    @Override
    public FluentWebElement fieldset() {
        return (FluentWebElement)super.fieldset();
    }

    @Override
    public FluentWebElement fieldset(By by) {
        return (FluentWebElement)super.fieldset(by);
    }

    @Override
    public FluentWebElements fieldsets() {
        return (FluentWebElements)super.fieldsets();
    }

    @Override
    public FluentWebElements fieldsets(By by) {
        return (FluentWebElements)super.fieldsets(by);
    }

    @Override
    public FluentWebElement tr() {
        return (FluentWebElement)super.tr();
    }

    @Override
    public FluentWebElement tr(By by) {
        return (FluentWebElement)super.tr(by);
    }

    @Override
    public FluentWebElements trs() {
        return (FluentWebElements)super.trs();
    }

    @Override
    public FluentWebElements trs(By by) {
        return (FluentWebElements)super.trs(by);
    }

    @Override
    public FluentWebElement img() {
        return (FluentWebElement)super.img();
    }

    @Override
    public FluentWebElement img(By by) {
        return (FluentWebElement)super.img(by);
    }

    @Override
    public FluentWebElements imgs() {
        return (FluentWebElements)super.imgs();
    }

    @Override
    public FluentWebElements imgs(By by) {
        return (FluentWebElements)super.imgs(by);
    }

    @Override
    public FluentWebElement legend() {
        return (FluentWebElement)super.legend();
    }

    @Override
    public FluentWebElement legend(By by) {
        return (FluentWebElement)super.legend(by);
    }

    @Override
    public FluentWebElements legends() {
        return (FluentWebElements)super.legends();
    }

    @Override
    public FluentWebElements legends(By by) {
        return (FluentWebElements)super.legends(by);
    }

    @Override
    public FluentWebElement th() {
        return (FluentWebElement)super.th();
    }

    @Override
    public FluentWebElement th(By by) {
        return (FluentWebElement)super.th(by);
    }

    @Override
    public FluentWebElements ths() {
        return (FluentWebElements)super.ths();
    }

    @Override
    public FluentWebElements ths(By by) {
        return (FluentWebElements)super.ths(by);
    }

    @Override
    public FluentWebElement map() {
        return (FluentWebElement)super.map();
    }

    @Override
    public FluentWebElement map(By by) {
        return (FluentWebElement)super.map(by);
    }

    @Override
    public FluentWebElements maps() {
        return (FluentWebElements)super.maps();
    }

    @Override
    public FluentWebElements maps(By by) {
        return (FluentWebElements)super.maps(by);
    }

    @Override
    public FluentWebElement ol() {
        return (FluentWebElement)super.ol();
    }

    @Override
    public FluentWebElement ol(By by) {
        return (FluentWebElement)super.ol(by);
    }

    @Override
    public FluentWebElements ols() {
        return (FluentWebElements)super.ols();
    }

    @Override
    public FluentWebElements ols(By by) {
        return (FluentWebElements)super.ols(by);
    }

    @Override
    public FluentWebElement li() {
        return (FluentWebElement)super.li();
    }

    @Override
    public FluentWebElement li(By by) {
        return (FluentWebElement)super.li(by);
    }

    @Override
    public FluentWebElements lis() {
        return (FluentWebElements)super.lis();
    }

    @Override
    public FluentWebElements lis(By by) {
        return (FluentWebElements)super.lis(by);
    }

    @Override
    public FluentWebElement p() {
        return (FluentWebElement)super.p();
    }

    @Override
    public FluentWebElement p(By by) {
        return (FluentWebElement)super.p(by);
    }

    @Override
    public FluentWebElements ps() {
        return (FluentWebElements)super.ps();
    }

    @Override
    public FluentWebElements ps(By by) {
        return (FluentWebElements)super.ps(by);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Submit
    extends StaleElementRecoveringExecution<Boolean> {
        private Submit() {
        }

        @Override
        public Boolean execute() {
            FluentWebElement.this.currentElement.getFound().submit();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SendKeys
    extends StaleElementRecoveringExecution<Boolean> {
        private final CharSequence[] keysToSend;

        public SendKeys(CharSequence ... keysToSend) {
            this.keysToSend = keysToSend;
        }

        @Override
        public Boolean execute() {
            FluentWebElement.this.currentElement.getFound().sendKeys(this.keysToSend);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsSelected
    extends StaleElementRecoveringExecution<Boolean> {
        private IsSelected() {
        }

        @Override
        public Boolean execute() {
            return FluentWebElement.this.currentElement.getFound().isSelected();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsEnabled
    extends StaleElementRecoveringExecution<Boolean> {
        private IsEnabled() {
        }

        @Override
        public Boolean execute() {
            return FluentWebElement.this.currentElement.getFound().isEnabled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsDisplayed
    extends StaleElementRecoveringExecution<Boolean> {
        private IsDisplayed() {
        }

        @Override
        public Boolean execute() {
            return FluentWebElement.this.currentElement.getFound().isDisplayed();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetLocation
    extends StaleElementRecoveringExecution<Point> {
        private GetLocation() {
        }

        @Override
        public Point execute() {
            return FluentWebElement.this.currentElement.getFound().getLocation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetSize
    extends StaleElementRecoveringExecution<Dimension> {
        private GetSize() {
        }

        @Override
        public Dimension execute() {
            return FluentWebElement.this.currentElement.getFound().getSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetText
    extends StaleElementRecoveringExecution<String> {
        private GetText() {
        }

        @Override
        public String execute() {
            return FluentWebElement.this.currentElement.getFound().getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetCssValue
    extends StaleElementRecoveringExecution<String> {
        private final String cssName;

        public GetCssValue(String cssName) {
            this.cssName = cssName;
        }

        @Override
        public String execute() {
            return FluentWebElement.this.currentElement.getFound().getCssValue(this.cssName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetAttribute
    extends StaleElementRecoveringExecution<String> {
        private final String attr;

        public GetAttribute(String attr) {
            this.attr = attr;
        }

        @Override
        public String execute() {
            try {
                return FluentWebElement.this.currentElement.getFound().getAttribute(this.attr);
            }
            catch (StaleElementReferenceException orig) {
                try {
                    FluentWebElement.this.currentElement.reFindElement();
                    return FluentWebElement.this.currentElement.getFound().getAttribute(this.attr);
                }
                catch (StaleElementReferenceException e) {
                    throw orig;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class StaleElementRecoveringExecution<T>
    extends Execution<T> {
        private StaleElementRecoveringExecution() {
        }

        @Override
        public T doExecution() {
            try {
                return this.execute();
            }
            catch (StaleElementReferenceException orig) {
                try {
                    FluentWebElement.this.currentElement.reFindElement();
                    return this.execute();
                }
                catch (WebDriverException e) {
                    throw orig;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Click
    extends StaleElementRecoveringExecution<Boolean> {
        private Click() {
        }

        @Override
        public Boolean execute() {
            FluentWebElement.this.currentElement.getFound().click();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetTagName
    extends StaleElementRecoveringExecution<String> {
        private GetTagName() {
        }

        @Override
        public String execute() {
            return FluentWebElement.this.currentElement.getFound().getTagName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Clear
    extends StaleElementRecoveringExecution<Boolean> {
        private Clear() {
        }

        @Override
        public Boolean execute() {
            FluentWebElement.this.currentElement.getFound().clear();
            return true;
        }
    }

    public static class NegatingFluentWebElement {
        private final Internal.BaseFluentWebElement delegate;
        private final Period duration;
        private final Long startedAt;

        protected NegatingFluentWebElement(WebDriver delegate, Internal.BaseFluentWebDriver.WebElementHolder currentElement, Period duration, Context context, Monitor monitor) {
            this.delegate = new FluentWebElement(delegate, currentElement, context, monitor){

                @Override
                protected <T> T decorateExecution(Execution<T> execution, Context ctx) {
                    T successfullyAbsent = null;
                    while (!NegatingFluentWebElement.this.durationHasElapsed(NegatingFluentWebElement.this.startedAt).booleanValue()) {
                        try {
                            super.decorateExecution(execution, ctx);
                        }
                        catch (FluentExecutionStopped executionStopped) {
                            boolean elementGone = executionStopped.getCause() instanceof NotFoundException;
                            if (!elementGone) continue;
                            return successfullyAbsent;
                        }
                    }
                    throw 1.decorateAssertionError(ctx, new AssertionError((Object)"Element never disappeared"));
                }
            };
            this.duration = duration;
            this.startedAt = System.currentTimeMillis();
        }

        protected Boolean durationHasElapsed(Long startMillis) {
            return this.duration.getEndMillis(startMillis) <= System.currentTimeMillis();
        }

        public void span() {
            this.delegate.span();
        }

        public void span(By by) {
            this.delegate.span(by);
        }

        public void div() {
            this.delegate.div();
        }

        public void div(By by) {
            this.delegate.div(by);
        }

        public void button() {
            this.delegate.button();
        }

        public void button(By by) {
            this.delegate.button(by);
        }

        public void link() {
            this.delegate.link();
        }

        public void link(By by) {
            this.delegate.link(by);
        }

        public void input() {
            this.delegate.input();
        }

        public void input(By by) {
            this.delegate.input(by);
        }

        public void select() {
            this.delegate.select();
        }

        public void select(By by) {
            this.delegate.select(by);
        }

        public void h1() {
            this.delegate.h1();
        }

        public void h1(By by) {
            this.delegate.h1(by);
        }

        public void h2() {
            this.delegate.h2();
        }

        public void h2(By by) {
            this.delegate.h2(by);
        }

        public void h3() {
            this.delegate.h3();
        }

        public void h3(By by) {
            this.delegate.h3(by);
        }

        public void h4() {
            this.delegate.h4();
        }

        public void h4(By by) {
            this.delegate.h4(by);
        }

        public void p() {
            this.delegate.p();
        }

        public void p(By by) {
            this.delegate.p(by);
        }

        public void img() {
            this.delegate.img();
        }

        public void img(By by) {
            this.delegate.img(by);
        }

        public void table() {
            this.delegate.table();
        }

        public void table(By by) {
            this.delegate.table(by);
        }

        public void fieldset() {
            this.delegate.fieldset();
        }

        public void fieldset(By by) {
            this.delegate.fieldset(by);
        }

        public void legend() {
            this.delegate.legend();
        }

        public void legend(By by) {
            this.delegate.legend(by);
        }

        public void tr() {
            this.delegate.tr();
        }

        public void tr(By by) {
            this.delegate.tr(by);
        }

        public void td() {
            this.delegate.td();
        }

        public void td(By by) {
            this.delegate.td(by);
        }

        public void th() {
            this.delegate.th();
        }

        public void th(By by) {
            this.delegate.th(by);
        }

        public void ul() {
            this.delegate.ul();
        }

        public void ul(By by) {
            this.delegate.ul(by);
        }

        public void ol() {
            this.delegate.ol();
        }

        public void ol(By by) {
            this.delegate.ol(by);
        }

        public void form() {
            this.delegate.form();
        }

        public void form(By by) {
            this.delegate.form(by);
        }

        public void textarea() {
            this.delegate.textarea();
        }

        public void textarea(By by) {
            this.delegate.textarea(by);
        }

        public void option() {
            this.delegate.option();
        }

        public void option(By by) {
            this.delegate.option(by);
        }

        public void li() {
            this.delegate.li();
        }

        public void li(By by) {
            this.delegate.li(by);
        }

        public void map() {
            this.delegate.map();
        }

        public void map(By by) {
            this.delegate.map(by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RetryingFluentWebElement
    extends FluentWebElement {
        private final Period period;

        public RetryingFluentWebElement(WebDriver webDriver, Internal.BaseFluentWebDriver.WebElementHolder currentElement, Context context, Period period, Monitor monitor) {
            super(webDriver, currentElement, context, monitor);
            this.period = period;
        }

        @Override
        protected Period getPeriod() {
            return this.period;
        }

        @Override
        protected WebElement findIt(By by, Context ctx) {
            return this.retryingFindIt(by);
        }

        @Override
        protected List<WebElement> findThem(By by, Context ctx) {
            return this.retryingFindThem(by);
        }

        @Override
        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
        }

        @Override
        protected void resetTimeout() {
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

