/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentMatcher;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.Internal;
import org.seleniumhq.selenium.fluent.Monitor;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElements
extends Internal.BaseFluentWebElements {
    private final List<FluentWebElement> currentElements;

    protected FluentWebElements(WebDriver delegate, List<FluentWebElement> currentElements, Context context, Monitor monitor) {
        super(delegate, context, monitor);
        this.currentElements = currentElements;
    }

    @Override
    protected Internal.BaseFluentWebElements newFluentWebElements(Internal.BaseFluentWebDriver.MultipleResult multiple) {
        List<WebElement> result = multiple.getResult();
        Context ctx = multiple.getCtx();
        ArrayList<FluentWebElement> elems = new ArrayList<FluentWebElement>();
        for (WebElement aResult : result) {
            elems.add(new FluentWebElement(this.delegate, new Internal.BaseFluentWebDriver.WebElementHolder(null, aResult, null), ctx, this.monitor));
        }
        return new FluentWebElements(this.delegate, elems, ctx, this.monitor);
    }

    public FluentWebElements click() {
        Context ctx = Context.singular(this.context, "click");
        this.decorateExecution(new Click(), ctx);
        return this.makeFluentWebElements(this, ctx, this.monitor);
    }

    public FluentWebElements clearField() {
        Context ctx = Context.singular(this.context, "clearField");
        this.decorateExecution(new Clear(), ctx);
        return this.makeFluentWebElements(this, ctx, this.monitor);
    }

    public FluentWebElements submit() {
        Context ctx = Context.singular(this.context, "submit");
        this.decorateExecution(new Submit(), ctx);
        return this.makeFluentWebElements(this, ctx, this.monitor);
    }

    public FluentWebElements sendKeys(CharSequence ... keysToSend) {
        Context ctx = Context.singular(this.context, "sendKeys", this.charSeqArrayAsHumanString(keysToSend));
        this.decorateExecution(new SendKeys(keysToSend), ctx);
        return this.makeFluentWebElements(this, ctx, this.monitor);
    }

    public boolean isSelected() {
        Context ctx = Context.singular(this.context, "isSelected");
        return this.decorateExecution(new IsSelected(), ctx);
    }

    public boolean isEnabled() {
        Context ctx = Context.singular(this.context, "isEnabled");
        return this.decorateExecution(new IsEnabled(), ctx);
    }

    public boolean isDisplayed() {
        Context ctx = Context.singular(this.context, "isDisplayed");
        return this.decorateExecution(new IsDisplayed(), ctx);
    }

    public TestableString getText() {
        Context ctx = Context.singular(this.context, "getText");
        return new TestableString(new GetText(), ctx).within(this.getPeriod());
    }

    @Override
    protected final WebElement findIt(By by, Context ctx) {
        return null;
    }

    @Override
    protected final List<WebElement> findThem(By by, Context ctx) {
        return null;
    }

    @Override
    protected final WebElement actualFindIt(By by, Context ctx) {
        return null;
    }

    @Override
    protected final List<WebElement> actualFindThem(By by, Context ctx) {
        return null;
    }

    public FluentWebElements filter(FluentMatcher matcher) {
        Context ctx = Context.singular(this.context, "filter", null, matcher);
        return this.makeFluentWebElements(this.decorateExecution(new FilterMatches(matcher), ctx), ctx, this.monitor);
    }

    public FluentWebElement first(FluentMatcher matcher) {
        Context ctx = Context.singular(this.context, "first", null, matcher);
        return this.decorateExecution(new MatchesFirst(matcher), ctx);
    }

    @Override
    public int size() {
        return this.currentElements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentElements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.currentElements.contains(o);
    }

    @Override
    public Iterator<FluentWebElement> iterator() {
        return this.currentElements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.currentElements.toArray();
    }

    @Override
    public <FluentWebElement> FluentWebElement[] toArray(FluentWebElement[] ts) {
        return this.currentElements.toArray(ts);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.currentElements.containsAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.currentElements.retainAll(objects);
    }

    @Override
    public FluentWebElement get(int i) {
        return this.currentElements.get(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.currentElements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.currentElements.lastIndexOf(o);
    }

    @Override
    public ListIterator<FluentWebElement> listIterator() {
        return this.currentElements.listIterator();
    }

    @Override
    public ListIterator<FluentWebElement> listIterator(int i) {
        return this.currentElements.listIterator(i);
    }

    @Override
    public List<FluentWebElement> subList(int i, int i1) {
        return this.currentElements.subList(i, i1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Submit
    extends Execution<Boolean> {
        private Submit() {
        }

        @Override
        public Boolean execute() {
            for (FluentWebElement fwe : FluentWebElements.this) {
                fwe.submit();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SendKeys
    extends Execution<Boolean> {
        private final CharSequence[] keysToSend;

        public SendKeys(CharSequence ... keysToSend) {
            this.keysToSend = keysToSend;
        }

        @Override
        public Boolean execute() {
            for (FluentWebElement fwe : FluentWebElements.this) {
                fwe.sendKeys(this.keysToSend);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsSelected
    extends Execution<Boolean> {
        private IsSelected() {
        }

        @Override
        public Boolean execute() {
            boolean areSelected = true;
            for (FluentWebElement fwe : FluentWebElements.this) {
                areSelected &= fwe.isSelected().value().booleanValue();
            }
            return areSelected;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsEnabled
    extends Execution<Boolean> {
        private IsEnabled() {
        }

        @Override
        public Boolean execute() {
            boolean areEnabled = true;
            for (FluentWebElement fwe : FluentWebElements.this) {
                areEnabled &= fwe.isEnabled().value().booleanValue();
            }
            return areEnabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsDisplayed
    extends Execution<Boolean> {
        private IsDisplayed() {
        }

        @Override
        public Boolean execute() {
            boolean areDisplayed = true;
            for (FluentWebElement fwe : FluentWebElements.this) {
                areDisplayed &= fwe.isDisplayed().value().booleanValue();
            }
            return areDisplayed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetText
    extends Execution<String> {
        private GetText() {
        }

        @Override
        public String execute() {
            String text = "";
            for (FluentWebElement fwe : FluentWebElements.this) {
                text = text + fwe.getText();
            }
            return text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterMatches
    extends Execution<List<FluentWebElement>> {
        private final FluentMatcher matcher;

        public FilterMatches(FluentMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public List<FluentWebElement> execute() {
            ArrayList<FluentWebElement> results = new ArrayList<FluentWebElement>();
            for (FluentWebElement fwe : FluentWebElements.this) {
                if (!this.matcher.matches(fwe.getWebElement())) continue;
                results.add(fwe);
            }
            if (results.size() == 0) {
                throw new Internal.NothingMatches();
            }
            return results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchesFirst
    extends Execution<FluentWebElement> {
        private final FluentMatcher matcher;

        public MatchesFirst(FluentMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public FluentWebElement execute() {
            FluentWebElement result = null;
            for (FluentWebElement fwe : FluentWebElements.this) {
                if (!this.matcher.matches(fwe.getWebElement())) continue;
                result = fwe;
                break;
            }
            if (result == null) {
                throw new Internal.NothingMatches();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Click
    extends Execution<Boolean> {
        private Click() {
        }

        @Override
        public Boolean execute() {
            for (FluentWebElement fwe : FluentWebElements.this) {
                fwe.click();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Clear
    extends Execution<Boolean> {
        private Clear() {
        }

        @Override
        public Boolean execute() {
            for (FluentWebElement fwe : FluentWebElements.this) {
                fwe.clearField();
            }
            return true;
        }
    }
}

