/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentBy;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentSelect;
import org.seleniumhq.selenium.fluent.FluentSelects;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.FluentWebElements;
import org.seleniumhq.selenium.fluent.Monitor;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

public class Internal {

    public static class NothingMatches
    extends RuntimeException {
    }

    public static abstract class Validation {
        public abstract void validate(long var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseTestableObject<T> {
        protected final Period within;
        protected final Execution<T> execution;
        protected final Context context;
        protected T is;

        public BaseTestableObject(Period within, Execution<T> execution, Context context) {
            this.within = within;
            this.execution = execution;
            this.context = context;
        }

        protected long calcEndMillis() {
            return this.within.getEndMillis(System.currentTimeMillis());
        }

        protected void validateWrapRethrow(Validation validation, Context ctx) {
            try {
                validation.validate(System.currentTimeMillis());
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
            }
            catch (AssertionError e) {
                throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
            }
        }

        protected void assignValueIfNeeded() {
            if (this.is != null) {
                return;
            }
            this.is = this.execution.doExecution();
        }

        protected String durationIfNotZero(long start) {
            long duration = System.currentTimeMillis() - start;
            if (duration > 0L) {
                return "(after " + duration + " ms)";
            }
            return "";
        }

        public void baseShouldBe(final T shouldBe) {
            Context ctx = Context.singular(this.context, "shouldBe", null, shouldBe);
            this.validateWrapRethrow(new Validation(){

                public void validate(long start) {
                    if (!shouldBe.equals(BaseTestableObject.this.is)) {
                        if (BaseTestableObject.this.within != null) {
                            boolean passed;
                            long endMillis = BaseTestableObject.this.calcEndMillis();
                            do {
                                BaseTestableObject.this.is = BaseTestableObject.this.execution.doExecution();
                                boolean bl = passed = BaseTestableObject.this.is != null && BaseTestableObject.this.is.equals(shouldBe);
                            } while (System.currentTimeMillis() < endMillis && !passed);
                        } else {
                            BaseTestableObject.this.assignValueIfNeeded();
                        }
                    }
                    MatcherAssert.assertThat((String)BaseTestableObject.this.durationIfNotZero(start), BaseTestableObject.this.is, (Matcher)CoreMatchers.equalTo((Object)shouldBe));
                }
            }, ctx);
        }

        public void baseShouldNotBe(final T shouldNotBe) {
            Context ctx = Context.singular(this.context, "shouldNotBe", null, shouldNotBe);
            this.validateWrapRethrow(new Validation(){

                public void validate(long start) {
                    BaseTestableObject.this.assignValueIfNeeded();
                    if (shouldNotBe.equals(BaseTestableObject.this.is) && BaseTestableObject.this.within != null) {
                        boolean passed;
                        long endMillis = BaseTestableObject.this.calcEndMillis();
                        do {
                            BaseTestableObject.this.is = BaseTestableObject.this.execution.doExecution();
                            boolean bl = passed = BaseTestableObject.this.is != null && !BaseTestableObject.this.is.equals(shouldNotBe);
                        } while (System.currentTimeMillis() < endMillis && !passed);
                    }
                    MatcherAssert.assertThat((String)BaseTestableObject.this.durationIfNotZero(start), BaseTestableObject.this.is, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)shouldNotBe)));
                }
            }, ctx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseFluentWebElements
    extends BaseFluentWebElement
    implements List<FluentWebElement> {
        protected BaseFluentWebElements(WebDriver delegate, Context context, Monitor monitor) {
            super(delegate, context, monitor);
        }

        @Override
        public final FluentWebElement set(int i, FluentWebElement fwe) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void add(int index, FluentWebElement element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final FluentWebElement remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends FluentWebElement> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(int index, Collection<? extends FluentWebElement> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean add(FluentWebElement fluentWebElement) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseFluentWebElement
    extends BaseFluentWebDriver {
        public BaseFluentWebElement(WebDriver delegate, Context context, Monitor monitor) {
            super(delegate, context, monitor);
        }

        @Override
        protected FluentWebElements makeFluentWebElements(List<FluentWebElement> results, Context context, Monitor monitor1) {
            return new FluentWebElements(this.delegate, results, context, this.monitor);
        }

        protected String charSeqArrayAsHumanString(CharSequence[] keysToSend) {
            String keys = "";
            for (CharSequence charSequence : keysToSend) {
                keys = keys + ", " + charSequence;
            }
            return keys.substring(2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseFluentWebDriver {
        protected final WebDriver delegate;
        protected final Context context;
        protected final Monitor monitor;

        protected BaseFluentWebDriver(WebDriver delegate, Context context, Monitor monitor) {
            this.delegate = delegate;
            this.context = context;
            this.monitor = monitor;
        }

        protected SearchContext getSearchContext() {
            return this.delegate;
        }

        protected BaseFluentWebElement span() {
            SingleResult single = this.single(By.tagName((String)"span"), "span");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement span(By by) {
            SingleResult single = this.single(by, "span");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements spans() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"span"), "span"));
        }

        protected BaseFluentWebElements newFluentWebElements(MultipleResult multiple) {
            List<WebElement> result = multiple.getResult();
            Context ctx = multiple.getCtx();
            ArrayList<FluentWebElement> elems = new ArrayList<FluentWebElement>();
            for (WebElement aResult : result) {
                elems.add(new FluentWebElement(this.delegate, new WebElementHolder(null, aResult, null), ctx, this.monitor));
            }
            return new FluentWebElements(this.delegate, elems, ctx, this.monitor);
        }

        private FluentSelects newFluentSelects(List<WebElement> result, Context ctx) {
            ArrayList<FluentWebElement> elems = new ArrayList<FluentWebElement>();
            for (WebElement aResult : result) {
                elems.add(new FluentSelect(this.delegate, aResult, ctx, this.monitor));
            }
            return new FluentSelects(this.delegate, elems, ctx, this.monitor);
        }

        protected BaseFluentWebElements spans(By by) {
            return this.newFluentWebElements(this.multiple(by, "span"));
        }

        protected BaseFluentWebElement div() {
            SingleResult single = this.single(By.tagName((String)"div"), "div");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement div(By by) {
            SingleResult single = this.single(by, "div");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements divs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"div"), "div"));
        }

        protected BaseFluentWebElements divs(By by) {
            return this.newFluentWebElements(this.multiple(by, "div"));
        }

        protected BaseFluentWebElement button() {
            SingleResult single = this.single(By.tagName((String)"button"), "button");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement button(By by) {
            SingleResult single = this.single(by, "button");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements buttons() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"button"), "button"));
        }

        protected BaseFluentWebElements buttons(By by) {
            return this.newFluentWebElements(this.multiple(by, "button"));
        }

        protected BaseFluentWebElement link() {
            SingleResult single = this.single(By.tagName((String)"a"), "a");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement link(By by) {
            SingleResult single = this.single(by, "a");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements links() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"a"), "a"));
        }

        protected BaseFluentWebElements links(By by) {
            return this.newFluentWebElements(this.multiple(by, "a"));
        }

        protected BaseFluentWebElement input() {
            SingleResult single = this.single(By.tagName((String)"input"), "input");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement input(By by) {
            SingleResult single = this.single(by, "input");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements inputs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"input"), "input"));
        }

        protected BaseFluentWebElements inputs(By by) {
            return this.newFluentWebElements(this.multiple(by, "input"));
        }

        public FluentSelect select() {
            SingleResult single = this.single(By.tagName((String)"select"), "select");
            return new FluentSelect(this.delegate, single.getResult().getFound(), single.getCtx(), this.monitor);
        }

        public FluentSelect select(By by) {
            SingleResult single = this.single(by, "select");
            return new FluentSelect(this.delegate, single.getResult().getFound(), single.getCtx(), this.monitor);
        }

        public FluentSelects selects() {
            MultipleResult multiple = this.multiple(By.tagName((String)"select"), "select");
            return this.newFluentSelects(multiple.getResult(), multiple.getCtx());
        }

        public FluentSelects selects(By by) {
            MultipleResult multiple = this.multiple(by, "select");
            return this.newFluentSelects(multiple.getResult(), multiple.getCtx());
        }

        protected BaseFluentWebElement h1() {
            SingleResult single = this.single(By.tagName((String)"h1"), "h1");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement h1(By by) {
            SingleResult single = this.single(by, "h1");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h1s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h1"), "h1"));
        }

        protected BaseFluentWebElements h1s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h1"));
        }

        protected BaseFluentWebElement h2() {
            SingleResult single = this.single(By.tagName((String)"h2"), "h2");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement h2(By by) {
            SingleResult single = this.single(by, "h2");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h2s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h2"), "h2"));
        }

        protected BaseFluentWebElements h2s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h2"));
        }

        protected BaseFluentWebElement h3() {
            SingleResult single = this.single(By.tagName((String)"h3"), "h3");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h3s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h3"), "h3"));
        }

        protected BaseFluentWebElement h3(By by) {
            SingleResult single = this.single(by, "h3");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h3s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h3"));
        }

        protected BaseFluentWebElement h4() {
            SingleResult single = this.single(By.tagName((String)"h4"), "h4");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h4s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h4"), "h4"));
        }

        protected BaseFluentWebElement h4(By by) {
            SingleResult single = this.single(by, "h4");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h4s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h4"));
        }

        protected BaseFluentWebElement p() {
            SingleResult single = this.single(By.tagName((String)"p"), "p");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ps() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"p"), "p"));
        }

        protected BaseFluentWebElement p(By by) {
            SingleResult single = this.single(by, "p");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ps(By by) {
            return this.newFluentWebElements(this.multiple(by, "p"));
        }

        protected BaseFluentWebElement img() {
            SingleResult single = this.single(By.tagName((String)"img"), "img");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements imgs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"img"), "img"));
        }

        protected BaseFluentWebElement img(By by) {
            SingleResult single = this.single(by, "img");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements imgs(By by) {
            return this.newFluentWebElements(this.multiple(by, "img"));
        }

        protected BaseFluentWebElement table() {
            SingleResult single = this.single(By.tagName((String)"table"), "table");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tables() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"table"), "table"));
        }

        protected BaseFluentWebElement table(By by) {
            SingleResult single = this.single(by, "table");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tables(By by) {
            return this.newFluentWebElements(this.multiple(by, "table"));
        }

        protected BaseFluentWebElement fieldset() {
            SingleResult single = this.single(By.tagName((String)"fieldset"), "fieldset");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements fieldsets() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"fieldset"), "fieldset"));
        }

        protected BaseFluentWebElement fieldset(By by) {
            SingleResult single = this.single(by, "fieldset");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements fieldsets(By by) {
            return this.newFluentWebElements(this.multiple(by, "fieldset"));
        }

        protected BaseFluentWebElement legend() {
            SingleResult single = this.single(By.tagName((String)"legend"), "legend");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements legends() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"legend"), "legend"));
        }

        protected BaseFluentWebElement legend(By by) {
            SingleResult single = this.single(by, "legend");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements legends(By by) {
            return this.newFluentWebElements(this.multiple(by, "legend"));
        }

        protected BaseFluentWebElement tr() {
            SingleResult single = this.single(By.tagName((String)"tr"), "tr");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements trs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"tr"), "tr"));
        }

        protected BaseFluentWebElement tr(By by) {
            SingleResult single = this.single(by, "tr");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements trs(By by) {
            return this.newFluentWebElements(this.multiple(by, "tr"));
        }

        protected BaseFluentWebElement td() {
            SingleResult single = this.single(By.tagName((String)"td"), "td");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tds() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"td"), "td"));
        }

        protected BaseFluentWebElement td(By by) {
            SingleResult single = this.single(by, "td");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tds(By by) {
            return this.newFluentWebElements(this.multiple(by, "td"));
        }

        protected BaseFluentWebElement th() {
            SingleResult single = this.single(By.tagName((String)"th"), "th");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ths() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"th"), "th"));
        }

        protected BaseFluentWebElement th(By by) {
            SingleResult single = this.single(by, "th");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ths(By by) {
            return this.newFluentWebElements(this.multiple(by, "th"));
        }

        protected BaseFluentWebElement ul() {
            SingleResult single = this.single(By.tagName((String)"ul"), "ul");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements uls() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"ul"), "ul"));
        }

        protected BaseFluentWebElement ul(By by) {
            SingleResult single = this.single(by, "ul");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements uls(By by) {
            return this.newFluentWebElements(this.multiple(by, "ul"));
        }

        protected BaseFluentWebElement ol() {
            SingleResult single = this.single(By.tagName((String)"ol"), "ol");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ols() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"ol"), "ol"));
        }

        protected BaseFluentWebElement ol(By by) {
            SingleResult single = this.single(by, "ol");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ols(By by) {
            return this.newFluentWebElements(this.multiple(by, "ol"));
        }

        protected BaseFluentWebElement form() {
            SingleResult single = this.single(By.tagName((String)"form"), "form");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements forms() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"form"), "form"));
        }

        protected BaseFluentWebElement form(By by) {
            SingleResult single = this.single(by, "form");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements forms(By by) {
            return this.newFluentWebElements(this.multiple(by, "form"));
        }

        protected BaseFluentWebElement textarea() {
            SingleResult single = this.single(By.tagName((String)"textarea"), "textarea");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements textareas() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"textarea"), "textarea"));
        }

        protected BaseFluentWebElement textarea(By by) {
            SingleResult single = this.single(by, "textarea");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements textareas(By by) {
            return this.newFluentWebElements(this.multiple(by, "textarea"));
        }

        protected BaseFluentWebElement option() {
            SingleResult single = this.single(By.tagName((String)"option"), "option");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements options() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"option"), "option"));
        }

        protected BaseFluentWebElement option(By by) {
            SingleResult single = this.single(by, "option");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements options(By by) {
            return this.newFluentWebElements(this.multiple(by, "option"));
        }

        protected BaseFluentWebElement li() {
            SingleResult single = this.single(By.tagName((String)"li"), "li");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement li(By by) {
            SingleResult single = this.single(by, "li");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements lis() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"li"), "li"));
        }

        protected BaseFluentWebElements lis(By by) {
            return this.newFluentWebElements(this.multiple(by, "li"));
        }

        protected BaseFluentWebElement map() {
            SingleResult single = this.single(By.tagName((String)"map"), "map");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements maps() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"map"), "map"));
        }

        protected BaseFluentWebElement map(By by) {
            SingleResult single = this.single(by, "map");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements maps(By by) {
            return this.newFluentWebElements(this.multiple(by, "map"));
        }

        protected BaseFluentWebElement newFluentWebElement(WebDriver delegate, WebElementHolder result, Context context) {
            return new FluentWebElement(delegate, result, context, this.monitor);
        }

        public TestableString url() {
            CurrentUrl execution = new CurrentUrl();
            Context ctx = Context.singular(this.context, "url");
            return new TestableString(execution, ctx).within(this.getPeriod());
        }

        protected Period getPeriod() {
            return null;
        }

        public TestableString title() {
            GetTitle execution = new GetTitle();
            Context ctx = Context.singular(this.context, "title");
            return new TestableString(execution, ctx).within(this.getPeriod());
        }

        protected abstract FluentWebElements makeFluentWebElements(List<FluentWebElement> var1, Context var2, Monitor var3);

        protected final By fixupBy(By by, String tagName) {
            if (by.getClass().getName().equals("org.openqa.selenium.By$ByXPath")) {
                by = By.xpath((String)(".//" + tagName + "[" + by.toString().substring(by.toString().indexOf(":") + 1).trim() + "]"));
            }
            if (by.getClass().getName().equals("org.openqa.selenium.By$ByClassName")) {
                by = FluentBy.composite(new By.ByTagName(tagName), (By.ByClassName)by);
            }
            return by;
        }

        protected final void assertTagIs(String is, String shouldBe) {
            if (!is.equals(shouldBe)) {
                throw new AssertionError((Object)("tag was incorrect, should have been " + shouldBe + " but was " + is));
            }
        }

        protected abstract WebElement findIt(By var1, Context var2);

        protected abstract List<WebElement> findThem(By var1, Context var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SingleResult single(By by, String tagName) {
            WebElementHolder result;
            By by2 = this.fixupBy(by, tagName);
            Context ctx = this.contextualize(by, tagName);
            try {
                this.changeTimeout();
                FindIt execution = new FindIt(by2, tagName, ctx);
                WebElement found = this.decorateExecution(execution, ctx);
                result = new WebElementHolder(this.getSearchContext(), found, by2);
            }
            finally {
                this.resetTimeout();
            }
            return new SingleResult(result, ctx);
        }

        private Context contextualize(By by, String tagName) {
            if (by.toString().equals("By.tagName: " + tagName)) {
                by = null;
            }
            return Context.singular(this.context, tagName, by);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MultipleResult multiple(By by, String tagName) {
            List<WebElement> result;
            By by2 = this.fixupBy(by, tagName);
            Context ctx = Context.plural(this.context, tagName, by);
            try {
                this.changeTimeout();
                FindThem execution = new FindThem(by2, tagName, ctx);
                result = this.decorateExecution(execution, ctx);
            }
            finally {
                this.resetTimeout();
            }
            return new MultipleResult(result, ctx);
        }

        protected static RuntimeException decorateRuntimeException(Context ctx, RuntimeException e) {
            FluentExecutionStopped rv = null;
            rv = e instanceof StaleElementReferenceException ? new FluentExecutionStopped.BecauseOfStaleElement(BaseFluentWebDriver.replacePkgNames(e) + ctx, e) : (e instanceof NothingMatches ? new FluentExecutionStopped.BecauseNothingMatchesInFilter("Nothing matched filter, during invocation of: " + ctx) : new FluentExecutionStopped(BaseFluentWebDriver.replacePkgNames(e) + ctx, e));
            return rv;
        }

        private static String replacePkgNames(Throwable e) {
            return e.getClass().getName().replace("java.lang.", "").replace("org.openqa.selenium.", "") + " during invocation of: ";
        }

        protected static RuntimeException decorateAssertionError(Context ctx, AssertionError e) {
            FluentExecutionStopped rv = new FluentExecutionStopped(BaseFluentWebDriver.replacePkgNames((Throwable)((Object)e)) + ctx, (Throwable)((Object)e));
            return rv;
        }

        protected <T> T decorateExecution(Execution<T> execution, Context ctx) {
            Monitor.Timer timer = this.monitor.start(ctx.toString().substring(2));
            try {
                T t = execution.doExecution();
                return t;
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
            }
            catch (AssertionError e) {
                throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
            }
            finally {
                timer.end();
            }
        }

        protected void changeTimeout() {
        }

        protected void resetTimeout() {
        }

        protected final WebElement retryingFindIt(By by) {
            long endMillis = this.getPeriod().getEndMillis(System.currentTimeMillis());
            WebDriverException exceptionCausingRetry = null;
            boolean toRetry = true;
            WebElement it = null;
            while (toRetry && endMillis - System.currentTimeMillis() > 0L) {
                try {
                    it = this.actualFindIt(by, this.context);
                    toRetry = false;
                    return it;
                }
                catch (WebDriverException e) {
                    exceptionCausingRetry = e;
                }
            }
            if (toRetry) {
                throw exceptionCausingRetry;
            }
            return it;
        }

        protected final List<WebElement> retryingFindThem(By by) {
            long endMillis = this.getPeriod().getEndMillis(System.currentTimeMillis());
            WebDriverException exceptionCausingRetry = null;
            boolean toRetry = true;
            List<WebElement> them = null;
            while (toRetry && endMillis - System.currentTimeMillis() > 0L) {
                try {
                    them = this.actualFindThem(by, this.context);
                    toRetry = false;
                    return them;
                }
                catch (WebDriverException e) {
                    exceptionCausingRetry = e;
                }
            }
            if (toRetry) {
                throw exceptionCausingRetry;
            }
            return them;
        }

        protected abstract WebElement actualFindIt(By var1, Context var2);

        protected abstract List<WebElement> actualFindThem(By var1, Context var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class GetTitle
        extends Execution<String> {
            private GetTitle() {
            }

            @Override
            public String execute() {
                return BaseFluentWebDriver.this.delegate.getTitle();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CurrentUrl
        extends Execution<String> {
            private CurrentUrl() {
            }

            @Override
            public String execute() {
                return BaseFluentWebDriver.this.delegate.getCurrentUrl();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FindThem
        extends Execution<List<WebElement>> {
            private final By by2;
            private final String tagName;
            private final Context ctx;

            public FindThem(By by2, String tagName, Context ctx) {
                this.by2 = by2;
                this.tagName = tagName;
                this.ctx = ctx;
            }

            @Override
            public List<WebElement> execute() {
                List<WebElement> results = BaseFluentWebDriver.this.findThem(this.by2, this.ctx);
                for (WebElement webElement : results) {
                    BaseFluentWebDriver.this.assertTagIs(webElement.getTagName(), this.tagName);
                }
                return results;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class MultipleResult {
            private final List<WebElement> result;
            private final Context ctx;

            public MultipleResult(List<WebElement> result, Context ctx) {
                this.result = result;
                this.ctx = ctx;
            }

            public List<WebElement> getResult() {
                return this.result;
            }

            public Context getCtx() {
                return this.ctx;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FindIt
        extends Execution<WebElement> {
            private final By by2;
            private final String tagName;
            private final Context ctx;

            public FindIt(By by2, String tagName, Context ctx) {
                this.by2 = by2;
                this.tagName = tagName;
                this.ctx = ctx;
            }

            @Override
            public WebElement execute() {
                WebElement it = BaseFluentWebDriver.this.findIt(this.by2, this.ctx);
                BaseFluentWebDriver.this.assertTagIs(it.getTagName(), this.tagName);
                return it;
            }
        }

        public static class SingleResult {
            private final WebElementHolder result;
            private final Context ctx;

            public SingleResult(WebElementHolder result, Context ctx) {
                this.result = result;
                this.ctx = ctx;
            }

            public WebElementHolder getResult() {
                return this.result;
            }

            public Context getCtx() {
                return this.ctx;
            }
        }

        public static class WebElementHolder {
            private final SearchContext parent;
            protected WebElement foundElement;
            private final By locator;

            public WebElementHolder(SearchContext parent, WebElement found, By locator) {
                this.parent = parent;
                this.foundElement = found;
                this.locator = locator;
            }

            public WebElement getFound() {
                return this.foundElement;
            }

            public void reFindElement() {
                if (this.parent != null) {
                    this.foundElement = this.parent.findElement(this.locator);
                }
            }
        }
    }
}

