/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.seleniumhq.selenium.fluent.Internal;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestableString
extends Internal.BaseTestableObject<String> {
    protected TestableString(Execution<String> execution, Context ctx) {
        this((Period)null, execution, ctx);
    }

    private TestableString(Period within, Execution<String> execution, Context ctx) {
        super(within, execution, ctx);
    }

    public TestableString shouldBe(String shouldBe) {
        this.baseShouldBe(shouldBe);
        return this;
    }

    public TestableString within(Period period) {
        Context ctx = Context.singular(this.context, "within", null, period);
        return new TestableString(period, this.execution, ctx);
    }

    public TestableString shouldNotBe(String shouldNotBe) {
        this.baseShouldNotBe(shouldNotBe);
        return this;
    }

    public TestableString shouldContain(final String shouldContain) {
        Context ctx = Context.singular(this.context, "shouldContain", null, shouldContain);
        this.validateWrapRethrow(new Internal.Validation(){

            public void validate(long start) {
                TestableString.this.assignValueIfNeeded();
                if (((String)TestableString.this.is).indexOf(shouldContain) == -1 && TestableString.this.within != null) {
                    boolean passed;
                    long endMillis = TestableString.this.calcEndMillis();
                    do {
                        TestableString.this.is = TestableString.this.execution.doExecution();
                        boolean bl = passed = TestableString.this.is != null && ((String)TestableString.this.is).indexOf(shouldContain) > -1;
                    } while (System.currentTimeMillis() < endMillis && !passed);
                }
                MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)Matchers.containsString((String)shouldContain));
            }
        }, ctx);
        return this;
    }

    public TestableString shouldNotContain(final String shouldNotContain) {
        Context ctx = Context.singular(this.context, "shouldNotContain", null, shouldNotContain);
        this.validateWrapRethrow(new Internal.Validation(){

            public void validate(long start) {
                TestableString.this.assignValueIfNeeded();
                if (((String)TestableString.this.is).indexOf(shouldNotContain) > -1 && TestableString.this.within != null) {
                    boolean passed;
                    long endMillis = TestableString.this.calcEndMillis();
                    do {
                        TestableString.this.is = TestableString.this.execution.doExecution();
                        boolean bl = passed = TestableString.this.is != null && ((String)TestableString.this.is).indexOf(shouldNotContain) == -1;
                    } while (System.currentTimeMillis() < endMillis && !passed);
                }
                MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)shouldNotContain)));
            }
        }, ctx);
        return this;
    }

    public String toString() {
        Context ctx = Context.singular(this.context, "toString", null, "");
        this.validateWrapRethrow(new Internal.Validation(){

            public void validate(long start) {
                if (TestableString.this.is != null) {
                    return;
                }
                TestableString.this.is = TestableString.this.execution.doExecution();
            }
        }, ctx);
        return (String)this.is;
    }

    public TestableString shouldMatch(String regex) {
        Context ctx = Context.singular(this.context, "shouldMatch", null, regex);
        final MatchesRegex matcher = new MatchesRegex(regex);
        this.validateWrapRethrow(new Internal.Validation(){

            public void validate(long start) {
                TestableString.this.assignValueIfNeeded();
                if (TestableString.this.is != null && !matcher.matches(TestableString.this.is) && TestableString.this.within != null) {
                    boolean passed;
                    long endMillis = TestableString.this.calcEndMillis();
                    do {
                        TestableString.this.is = TestableString.this.execution.doExecution();
                        boolean bl = passed = TestableString.this.is != null && matcher.matches(TestableString.this.is);
                    } while (System.currentTimeMillis() < endMillis && !passed);
                }
                MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)matcher);
            }
        }, ctx);
        return this;
    }

    public TestableString shouldNotMatch(String regex) {
        Context ctx = Context.singular(this.context, "shouldNotMatch", null, regex);
        final MatchesRegex matcher = new MatchesRegex(regex);
        this.validateWrapRethrow(new Internal.Validation(){

            public void validate(long start) {
                TestableString.this.assignValueIfNeeded();
                if (TestableString.this.is != null && matcher.matches(TestableString.this.is) && TestableString.this.within != null) {
                    boolean passed;
                    long endMillis = TestableString.this.calcEndMillis();
                    do {
                        TestableString.this.is = TestableString.this.execution.doExecution();
                        boolean bl = passed = TestableString.this.is != null && !matcher.matches(TestableString.this.is);
                    } while (System.currentTimeMillis() < endMillis && !passed);
                }
                MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)CoreMatchers.not((Matcher)matcher));
            }
        }, ctx);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchesRegex
    extends BaseMatcher<String> {
        private final String regex;
        private final Pattern pattern;

        public MatchesRegex(String regex) {
            this.regex = regex;
            this.pattern = Pattern.compile(regex, 8);
        }

        public void describeTo(Description description) {
            description.appendText("a string matching /" + this.regex + "/");
        }

        public final void describeMismatch(Object item, Description description) {
            description.appendText("was ").appendValue(item);
        }

        public final boolean matches(Object item) {
            return this.pattern.matcher((String)item).find();
        }
    }
}

