/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent.internal;

import org.openqa.selenium.By;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentWebDriver;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

public class NegatingFluentWebDriver {
    private final FluentWebDriver delegate;

    public NegatingFluentWebDriver(WebDriver delegate, Period duration, Context context) {
        this.delegate = this.newDelegateFluentWebDriver(delegate, context, duration);
    }

    protected FluentWebDriver newDelegateFluentWebDriver(WebDriver delegate, Context context, Period duration) {
        return new DelegateNegatingFWD(delegate, context, duration);
    }

    public void span() {
        this.delegate.span();
    }

    public void span(By by) {
        this.delegate.span(by);
    }

    public void div() {
        this.delegate.div();
    }

    public void div(By by) {
        this.delegate.div(by);
    }

    public void button() {
        this.delegate.button();
    }

    public void button(By by) {
        this.delegate.button(by);
    }

    public void link() {
        this.delegate.link();
    }

    public void link(By by) {
        this.delegate.link(by);
    }

    public void input() {
        this.delegate.input();
    }

    public void input(By by) {
        this.delegate.input(by);
    }

    public void select() {
        this.delegate.select();
    }

    public void select(By by) {
        this.delegate.select(by);
    }

    public void h1() {
        this.delegate.h1();
    }

    public void h1(By by) {
        this.delegate.h1(by);
    }

    public void h2() {
        this.delegate.h2();
    }

    public void h2(By by) {
        this.delegate.h2(by);
    }

    public void h3() {
        this.delegate.h3();
    }

    public void h3(By by) {
        this.delegate.h3(by);
    }

    public void h4() {
        this.delegate.h4();
    }

    public void h4(By by) {
        this.delegate.h4(by);
    }

    public void p() {
        this.delegate.p();
    }

    public void p(By by) {
        this.delegate.p(by);
    }

    public void img() {
        this.delegate.img();
    }

    public void img(By by) {
        this.delegate.img(by);
    }

    public void table() {
        this.delegate.table();
    }

    public void table(By by) {
        this.delegate.table(by);
    }

    public void fieldset() {
        this.delegate.fieldset();
    }

    public void fieldset(By by) {
        this.delegate.fieldset(by);
    }

    public void legend() {
        this.delegate.legend();
    }

    public void legend(By by) {
        this.delegate.legend(by);
    }

    public void tr() {
        this.delegate.tr();
    }

    public void tr(By by) {
        this.delegate.tr(by);
    }

    public void td() {
        this.delegate.td();
    }

    public void td(By by) {
        this.delegate.td(by);
    }

    public void th() {
        this.delegate.th();
    }

    public void th(By by) {
        this.delegate.th(by);
    }

    public void ul() {
        this.delegate.ul();
    }

    public void ul(By by) {
        this.delegate.ul(by);
    }

    public void ol() {
        this.delegate.ol();
    }

    public void ol(By by) {
        this.delegate.ol(by);
    }

    public void form() {
        this.delegate.form();
    }

    public void form(By by) {
        this.delegate.form(by);
    }

    public void textarea() {
        this.delegate.textarea();
    }

    public void textarea(By by) {
        this.delegate.textarea(by);
    }

    public void option() {
        this.delegate.option();
    }

    public void option(By by) {
        this.delegate.option(by);
    }

    public void li() {
        this.delegate.li();
    }

    public void li(By by) {
        this.delegate.li(by);
    }

    public void map() {
        this.delegate.map();
    }

    public void map(By by) {
        this.delegate.map(by);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegateNegatingFWD
    extends FluentWebDriver {
        private final long startedAt;
        private final Period duration;

        public DelegateNegatingFWD(WebDriver delegate, Context context, Period duration) {
            super(delegate, context);
            this.duration = duration;
            this.startedAt = System.currentTimeMillis();
        }

        protected Boolean durationHasElapsed(Long startMillis) {
            return this.duration.getEndMillis(startMillis) <= System.currentTimeMillis();
        }

        @Override
        protected <T> T decorateExecution(Execution<T> execution, Context ctx) {
            T successfullyAbsent = null;
            while (!this.durationHasElapsed(this.startedAt).booleanValue()) {
                try {
                    super.decorateExecution(execution, ctx);
                }
                catch (FluentExecutionStopped executionStopped) {
                    boolean elementGone = executionStopped.getCause() instanceof NotFoundException;
                    if (!elementGone) continue;
                    return successfullyAbsent;
                }
            }
            throw DelegateNegatingFWD.decorateAssertionError(ctx, new AssertionError((Object)"Element never disappeared"));
        }
    }
}

