/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentMatcher;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.FluentWebElementMap;
import org.seleniumhq.selenium.fluent.FluentWebElementVistor;
import org.seleniumhq.selenium.fluent.Internal;
import org.seleniumhq.selenium.fluent.Monitor;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElements
extends Internal.BaseFluentWebElements {
    private final List<FluentWebElement> currentElements;

    protected FluentWebElements(WebDriver delegate, List<FluentWebElement> currentElements, Context context, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
        super(delegate, context, monitor, booleanInsteadOfNoSuchElement);
        this.currentElements = currentElements;
    }

    @Override
    protected Internal.BaseFluentWebElements newFluentWebElements(Internal.BaseFluentWebDriver.MultipleResult multiple) {
        List<WebElement> result = multiple.getResult();
        Context ctx = multiple.getCtx();
        ArrayList<FluentWebElement> elems = new ArrayList<FluentWebElement>();
        for (WebElement aResult : result) {
            elems.add(new FluentWebElement(this.delegate, new Internal.WebElementHolder(null, aResult, null), ctx, this.monitor, this.booleanInsteadOfNotFoundException));
        }
        return new FluentWebElements(this.delegate, elems, ctx, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentWebElements click() {
        Context ctx = Context.singular(this.context, "click");
        this.executeAndWrapReThrowIfNeeded(new Click(), ctx);
        return this.makeFluentWebElements(this, ctx, this.monitor);
    }

    private <T> T executeAndWrapReThrowIfNeeded(Execution<T> execution, Context ctx) {
        return this.executeAndWrapReThrowIfNeeded(execution, null, ctx, true);
    }

    public FluentWebElements clearField() {
        Context ctx = Context.singular(this.context, "clearField");
        this.executeAndWrapReThrowIfNeeded(new Clear(), ctx);
        return this.makeFluentWebElements(this, ctx, this.monitor);
    }

    public FluentWebElements submit() {
        Context ctx = Context.singular(this.context, "submit");
        this.executeAndWrapReThrowIfNeeded(new Submit(), ctx);
        return this.makeFluentWebElements(this, ctx, this.monitor);
    }

    public FluentWebElements sendKeys(CharSequence ... keysToSend) {
        Context ctx = Context.singular(this.context, "sendKeys", this.charSeqArrayAsHumanString(keysToSend));
        this.executeAndWrapReThrowIfNeeded(new SendKeys(keysToSend), ctx);
        return this.makeFluentWebElements(this, ctx, this.monitor);
    }

    public boolean isSelected() {
        Context ctx = Context.singular(this.context, "isSelected");
        return this.executeAndWrapReThrowIfNeeded(new IsSelected(), ctx);
    }

    public boolean isEnabled() {
        Context ctx = Context.singular(this.context, "isEnabled");
        return this.executeAndWrapReThrowIfNeeded(new IsEnabled(), ctx);
    }

    public boolean isDisplayed() {
        Context ctx = Context.singular(this.context, "isDisplayed");
        return this.executeAndWrapReThrowIfNeeded(new IsDisplayed(), ctx);
    }

    public TestableString getText() {
        Context ctx = Context.singular(this.context, "getText");
        return new TestableString(new GetText(), ctx, this.monitor).within(this.getPeriod());
    }

    public <K, V> Map<K, V> map(FluentWebElementMap<K, V> mapper) {
        int ix = -1;
        for (FluentWebElement next : this.currentElements) {
            mapper.map(next, ++ix);
        }
        return mapper;
    }

    public FluentWebElements each(FluentWebElementVistor visitor) {
        int ix = -1;
        for (FluentWebElement next : this.currentElements) {
            visitor.visit(next, ++ix);
        }
        return this;
    }

    @Override
    protected final WebElement findElement(By by, Context ctx, SearchContext searchContext) {
        return null;
    }

    @Override
    protected final List<WebElement> findElements(By by, Context ctx) {
        return null;
    }

    @Override
    protected final WebElement actualFindElement(By by, Context ctx, SearchContext searchContext) {
        return null;
    }

    @Override
    protected final List<WebElement> actualFindElements(By by, Context ctx) {
        return null;
    }

    public FluentWebElements filter(FluentMatcher matcher) {
        Context ctx = Context.singular(this.context, "filter", null, matcher);
        return this.makeFluentWebElements(this.executeAndWrapReThrowIfNeeded(new FilterMatches(matcher), ctx), ctx, this.monitor);
    }

    public FluentWebElement first(FluentMatcher matcher) {
        Context ctx = Context.singular(this.context, "first", null, matcher);
        return this.executeAndWrapReThrowIfNeeded(new MatchesFirst(matcher), ctx);
    }

    public FluentWebElement last(FluentMatcher matcher) {
        Context ctx = Context.singular(this.context, "last", null, matcher);
        return this.executeAndWrapReThrowIfNeeded(new MatchesLast(matcher), ctx);
    }

    @Override
    public int size() {
        return this.currentElements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentElements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.currentElements.contains(o);
    }

    @Override
    public Iterator<FluentWebElement> iterator() {
        return this.currentElements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.currentElements.toArray();
    }

    @Override
    public <FluentWebElement> FluentWebElement[] toArray(FluentWebElement[] ts) {
        return this.currentElements.toArray(ts);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.currentElements.containsAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.currentElements.retainAll(objects);
    }

    @Override
    public FluentWebElement get(int i) {
        try {
            return this.currentElements.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FluentExecutionStopped("Element index " + i + " not in collection of " + this.currentElements.size() + " elements", e);
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.currentElements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.currentElements.lastIndexOf(o);
    }

    @Override
    public ListIterator<FluentWebElement> listIterator() {
        return this.currentElements.listIterator();
    }

    @Override
    public ListIterator<FluentWebElement> listIterator(int i) {
        try {
            return this.currentElements.listIterator(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FluentExecutionStopped("Element index " + i + " not in collection of " + this.currentElements.size() + " elements", e);
        }
    }

    @Override
    public List<FluentWebElement> subList(int i, int i1) {
        try {
            return this.currentElements.subList(i, i1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FluentExecutionStopped("Element index " + i + ", or element index " + i1 + " not in collection of " + this.currentElements.size() + " elements", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Submit
    extends Execution<Boolean> {
        private Submit() {
        }

        @Override
        public Boolean execute() {
            for (FluentWebElement fwe : FluentWebElements.this) {
                fwe.submit();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SendKeys
    extends Execution<Boolean> {
        private final CharSequence[] keysToSend;

        public SendKeys(CharSequence ... keysToSend) {
            this.keysToSend = keysToSend;
        }

        @Override
        public Boolean execute() {
            for (FluentWebElement fwe : FluentWebElements.this) {
                fwe.sendKeys(this.keysToSend);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsSelected
    extends Execution<Boolean> {
        private IsSelected() {
        }

        @Override
        public Boolean execute() {
            boolean areSelected = true;
            for (FluentWebElement fwe : FluentWebElements.this) {
                areSelected &= fwe.isSelected().value().booleanValue();
            }
            return areSelected;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsEnabled
    extends Execution<Boolean> {
        private IsEnabled() {
        }

        @Override
        public Boolean execute() {
            boolean areEnabled = true;
            for (FluentWebElement fwe : FluentWebElements.this) {
                areEnabled &= fwe.isEnabled().value().booleanValue();
            }
            return areEnabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsDisplayed
    extends Execution<Boolean> {
        private IsDisplayed() {
        }

        @Override
        public Boolean execute() {
            boolean areDisplayed = true;
            for (FluentWebElement fwe : FluentWebElements.this) {
                areDisplayed &= fwe.isDisplayed().value().booleanValue();
            }
            return areDisplayed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetText
    extends Execution<String> {
        private GetText() {
        }

        @Override
        public String execute() {
            String text = "";
            for (FluentWebElement fwe : FluentWebElements.this) {
                text = text + fwe.getText();
            }
            return text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterMatches
    extends Execution<List<FluentWebElement>> {
        private final FluentMatcher matcher;

        public FilterMatches(FluentMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public List<FluentWebElement> execute() {
            ArrayList<FluentWebElement> results = new ArrayList<FluentWebElement>();
            int ix = -1;
            for (FluentWebElement fwe : FluentWebElements.this) {
                if (!this.matcher.matches(fwe, ++ix)) continue;
                results.add(fwe);
            }
            if (results.size() == 0) {
                throw new Internal.NothingMatches();
            }
            return results;
        }
    }

    private class MatchesLast
    extends MatchesFirst {
        public MatchesLast(FluentMatcher matcher) {
            super(matcher);
        }

        protected boolean shouldBreak() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchesFirst
    extends Execution<FluentWebElement> {
        private final FluentMatcher matcher;

        public MatchesFirst(FluentMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public FluentWebElement execute() {
            FluentWebElement result = null;
            int ix = -1;
            for (FluentWebElement fwe : FluentWebElements.this) {
                if (!this.matcher.matches(fwe, ++ix)) continue;
                result = fwe;
                if (!this.shouldBreak()) continue;
                break;
            }
            if (result == null) {
                throw new Internal.NothingMatches();
            }
            return result;
        }

        protected boolean shouldBreak() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Click
    extends Execution<Boolean> {
        private Click() {
        }

        @Override
        public Boolean execute() {
            for (FluentWebElement fwe : FluentWebElements.this) {
                fwe.click();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Clear
    extends Execution<Boolean> {
        private Clear() {
        }

        @Override
        public Boolean execute() {
            for (FluentWebElement fwe : FluentWebElements.this) {
                fwe.clearField();
            }
            return true;
        }
    }
}

