/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentBy;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentSelect;
import org.seleniumhq.selenium.fluent.FluentSelects;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.FluentWebElements;
import org.seleniumhq.selenium.fluent.Monitor;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

public class Internal {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FoundOrNotFound
    implements WebElement {
        private boolean found;

        public boolean isFound() {
            return this.found;
        }

        public FoundOrNotFound(boolean found) {
            this.found = found;
        }

        public void click() {
            throw new UnsupportedOperationException();
        }

        public void submit() {
            throw new UnsupportedOperationException();
        }

        public void sendKeys(CharSequence ... keysToSend) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String getTagName() {
            throw new UnsupportedOperationException();
        }

        public String getAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public boolean isSelected() {
            throw new UnsupportedOperationException();
        }

        public boolean isEnabled() {
            throw new UnsupportedOperationException();
        }

        public String getText() {
            throw new UnsupportedOperationException();
        }

        public List<WebElement> findElements(By by) {
            throw new UnsupportedOperationException();
        }

        public WebElement findElement(By by) {
            throw new UnsupportedOperationException();
        }

        public boolean isDisplayed() {
            throw new UnsupportedOperationException();
        }

        public Point getLocation() {
            throw new UnsupportedOperationException();
        }

        public Dimension getSize() {
            throw new UnsupportedOperationException();
        }

        public String getCssValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
            throw new UnsupportedOperationException();
        }

        public Rectangle getRect() {
            throw new UnsupportedOperationException();
        }
    }

    public static class NothingMatches
    extends RuntimeException {
    }

    public static abstract class Validation {
        public abstract void validate(long var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseTestableObject<T> {
        protected final Period within;
        protected final Execution<T> execution;
        protected final Context context;
        protected T is;
        protected final Monitor monitor;

        public BaseTestableObject(Period within, Execution<T> execution, Context context, Monitor monitor) {
            this.within = within;
            this.execution = execution;
            this.context = context;
            this.monitor = monitor;
        }

        protected long calcEndMillis() {
            return this.within.getEndMillis(System.currentTimeMillis());
        }

        protected void validateWrapRethrow(Validation validation, Context ctx) {
            try {
                validation.validate(System.currentTimeMillis());
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw this.monitor.exceptionDuringExecution(BaseFluentWebDriver.wrapRuntimeException(ctx, e), this.execution.getWebElement());
            }
            catch (AssertionError e) {
                throw this.monitor.exceptionDuringExecution(BaseFluentWebDriver.wrapAssertionError(ctx, e), this.execution.getWebElement());
            }
        }

        protected void assignValueIfNeeded() {
            if (this.is != null) {
                return;
            }
            this.is = this.execution.doExecution();
        }

        protected String durationIfNotZero(long start) {
            long duration = System.currentTimeMillis() - start;
            if (duration > 0L) {
                return "(after " + duration + " ms)";
            }
            return "";
        }

        public void baseShouldBe(T shouldBe) {
            this.validateWrapRethrow(new ShouldBeValidation<T>(shouldBe), Context.singular(this.context, "shouldBe", null, shouldBe));
        }

        public void baseShouldNotBe(T shouldNotBe) {
            this.validateWrapRethrow(new ShouldNotBeValidation<T>(shouldNotBe), Context.singular(this.context, "shouldNotBe", null, shouldNotBe));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ShouldBeValidation<T>
        extends Validation {
            private final T shouldBe;

            public ShouldBeValidation(T shouldBe) {
                this.shouldBe = shouldBe;
            }

            @Override
            public void validate(long start) {
                if (!this.shouldBe.equals(BaseTestableObject.this.is)) {
                    if (BaseTestableObject.this.within != null) {
                        boolean passed;
                        long endMillis = BaseTestableObject.this.calcEndMillis();
                        do {
                            BaseTestableObject.this.is = BaseTestableObject.this.execution.doExecution();
                            boolean bl = passed = BaseTestableObject.this.is != null && BaseTestableObject.this.is.equals(this.shouldBe);
                        } while (System.currentTimeMillis() < endMillis && !passed);
                    } else {
                        BaseTestableObject.this.assignValueIfNeeded();
                    }
                }
                MatcherAssert.assertThat((String)BaseTestableObject.this.durationIfNotZero(start), BaseTestableObject.this.is, (Matcher)CoreMatchers.equalTo(this.shouldBe));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ShouldNotBeValidation<T>
        extends Validation {
            private final T shouldNotBe;

            public ShouldNotBeValidation(T shouldNotBe) {
                this.shouldNotBe = shouldNotBe;
            }

            @Override
            public void validate(long start) {
                BaseTestableObject.this.assignValueIfNeeded();
                if (this.shouldNotBe.equals(BaseTestableObject.this.is) && BaseTestableObject.this.within != null) {
                    boolean passed;
                    long endMillis = BaseTestableObject.this.calcEndMillis();
                    do {
                        BaseTestableObject.this.is = BaseTestableObject.this.execution.doExecution();
                        boolean bl = passed = BaseTestableObject.this.is != null && !BaseTestableObject.this.is.equals(this.shouldNotBe);
                    } while (System.currentTimeMillis() < endMillis && !passed);
                }
                MatcherAssert.assertThat((String)BaseTestableObject.this.durationIfNotZero(start), BaseTestableObject.this.is, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(this.shouldNotBe)));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseFluentWebElements
    extends BaseFluentWebElement
    implements List<FluentWebElement> {
        protected BaseFluentWebElements(WebDriver delegate, Context context, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
            super(delegate, context, monitor, booleanInsteadOfNoSuchElement);
        }

        @Override
        protected WebElement getWebElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final FluentWebElement set(int i, FluentWebElement fwe) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void add(int index, FluentWebElement element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final FluentWebElement remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends FluentWebElement> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(int index, Collection<? extends FluentWebElement> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean add(FluentWebElement fluentWebElement) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseFluentWebElement
    extends BaseFluentWebDriver {
        public BaseFluentWebElement(WebDriver delegate, Context context, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
            super(delegate, context, monitor, booleanInsteadOfNoSuchElement);
        }

        protected abstract WebElement getWebElement();

        @Override
        protected FluentWebElements makeFluentWebElements(List<FluentWebElement> results, Context context, Monitor monitor1) {
            return new FluentWebElements(this.delegate, results, context, this.monitor, this.booleanInsteadOfNotFoundException);
        }

        protected String charSeqArrayAsHumanString(CharSequence[] keysToSend) {
            String keys = "";
            for (CharSequence charSequence : keysToSend) {
                keys = keys + ", " + charSequence;
            }
            return keys.substring(2);
        }
    }

    public static class WebElementHolder {
        private final SearchContext parent;
        protected WebElement foundElement;
        private final By locator;

        public WebElementHolder(SearchContext parent, WebElement found, By locator) {
            this.parent = parent;
            this.foundElement = found;
            this.locator = locator;
        }

        public WebElement getFound() {
            return this.foundElement;
        }

        public void reFindElement() {
            if (this.parent != null) {
                this.foundElement = this.parent.findElement(this.locator);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseFluentWebDriver {
        protected static final String GENERIC_TAG = "*";
        protected final WebDriver delegate;
        protected final Context context;
        protected final Monitor monitor;
        protected final boolean booleanInsteadOfNotFoundException;

        protected BaseFluentWebDriver(WebDriver delegate, Context context, Monitor monitor, boolean booleanInsteadOfNotFoundException) {
            this.delegate = delegate;
            this.context = context;
            this.monitor = monitor;
            this.booleanInsteadOfNotFoundException = booleanInsteadOfNotFoundException;
        }

        protected void beforeFindElement(By by) {
            if (by instanceof FluentBy) {
                ((FluentBy)by).beforeFindElement(this.delegate);
            }
        }

        protected SearchContext getSearchContext() {
            return this.delegate;
        }

        protected BaseFluentWebElements newFluentWebElements(MultipleResult multiple) {
            List<WebElement> result = multiple.getResult();
            Context ctx = multiple.getCtx();
            ArrayList<FluentWebElement> elems = new ArrayList<FluentWebElement>();
            for (WebElement aResult : result) {
                elems.add(new FluentWebElement(this.delegate, new WebElementHolder(null, aResult, null), ctx, this.monitor, this.booleanInsteadOfNotFoundException));
            }
            return new FluentWebElements(this.delegate, elems, ctx, this.monitor, this.booleanInsteadOfNotFoundException);
        }

        private FluentSelects newFluentSelects(List<WebElement> result, Context ctx) {
            ArrayList<FluentWebElement> elems = new ArrayList<FluentWebElement>();
            for (WebElement aResult : result) {
                elems.add(new FluentSelect(this.delegate, aResult, ctx, this.monitor, this.booleanInsteadOfNotFoundException));
            }
            return new FluentSelects(this.delegate, elems, ctx, this.monitor, this.booleanInsteadOfNotFoundException);
        }

        protected BaseFluentWebElement element() {
            SingleResult single = this.single(By.tagName((String)GENERIC_TAG), GENERIC_TAG);
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement element(By by) {
            SingleResult single = this.single(by, GENERIC_TAG);
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements elements() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)GENERIC_TAG), GENERIC_TAG));
        }

        protected BaseFluentWebElements elements(By by) {
            return this.newFluentWebElements(this.multiple(by, GENERIC_TAG));
        }

        protected BaseFluentWebElement span() {
            SingleResult single = this.single(By.tagName((String)"span"), "span");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement span(By by) {
            SingleResult single = this.single(by, "span");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements spans() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"span"), "span"));
        }

        protected BaseFluentWebElements spans(By by) {
            return this.newFluentWebElements(this.multiple(by, "span"));
        }

        protected BaseFluentWebElement div() {
            SingleResult single = this.single(By.tagName((String)"div"), "div");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement div(By by) {
            SingleResult single = this.single(by, "div");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements divs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"div"), "div"));
        }

        protected BaseFluentWebElements divs(By by) {
            return this.newFluentWebElements(this.multiple(by, "div"));
        }

        protected BaseFluentWebElement button() {
            SingleResult single = this.single(By.tagName((String)"button"), "button");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement button(By by) {
            SingleResult single = this.single(by, "button");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements buttons() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"button"), "button"));
        }

        protected BaseFluentWebElements buttons(By by) {
            return this.newFluentWebElements(this.multiple(by, "button"));
        }

        protected BaseFluentWebElement link() {
            SingleResult single = this.single(By.tagName((String)"a"), "a");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement link(By by) {
            SingleResult single = this.single(by, "a");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements links() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"a"), "a"));
        }

        protected BaseFluentWebElements links(By by) {
            return this.newFluentWebElements(this.multiple(by, "a"));
        }

        protected BaseFluentWebElement input() {
            SingleResult single = this.single(By.tagName((String)"input"), "input");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement input(By by) {
            SingleResult single = this.single(by, "input");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements inputs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"input"), "input"));
        }

        protected BaseFluentWebElements inputs(By by) {
            return this.newFluentWebElements(this.multiple(by, "input"));
        }

        public FluentSelect select() {
            SingleResult single = this.single(By.tagName((String)"select"), "select");
            return new FluentSelect(this.delegate, single.getResult().getFound(), single.getCtx(), this.monitor, this.booleanInsteadOfNotFoundException);
        }

        public FluentSelect select(By by) {
            SingleResult single = this.single(by, "select");
            return new FluentSelect(this.delegate, single.getResult().getFound(), single.getCtx(), this.monitor, this.booleanInsteadOfNotFoundException);
        }

        public FluentSelects selects() {
            MultipleResult multiple = this.multiple(By.tagName((String)"select"), "select");
            return this.newFluentSelects(multiple.getResult(), multiple.getCtx());
        }

        public FluentSelects selects(By by) {
            MultipleResult multiple = this.multiple(by, "select");
            return this.newFluentSelects(multiple.getResult(), multiple.getCtx());
        }

        protected BaseFluentWebElement h1() {
            SingleResult single = this.single(By.tagName((String)"h1"), "h1");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement h1(By by) {
            SingleResult single = this.single(by, "h1");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h1s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h1"), "h1"));
        }

        protected BaseFluentWebElements h1s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h1"));
        }

        protected BaseFluentWebElement h2() {
            SingleResult single = this.single(By.tagName((String)"h2"), "h2");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement h2(By by) {
            SingleResult single = this.single(by, "h2");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h2s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h2"), "h2"));
        }

        protected BaseFluentWebElements h2s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h2"));
        }

        protected BaseFluentWebElement h3() {
            SingleResult single = this.single(By.tagName((String)"h3"), "h3");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h3s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h3"), "h3"));
        }

        protected BaseFluentWebElement h3(By by) {
            SingleResult single = this.single(by, "h3");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h3s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h3"));
        }

        protected BaseFluentWebElement h4() {
            SingleResult single = this.single(By.tagName((String)"h4"), "h4");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h4s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h4"), "h4"));
        }

        protected BaseFluentWebElement h4(By by) {
            SingleResult single = this.single(by, "h4");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h4s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h4"));
        }

        protected BaseFluentWebElement h5() {
            SingleResult single = this.single(By.tagName((String)"h5"), "h5");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h5s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h5"), "h5"));
        }

        protected BaseFluentWebElement h5(By by) {
            SingleResult single = this.single(by, "h5");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h5s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h5"));
        }

        protected BaseFluentWebElement h6() {
            SingleResult single = this.single(By.tagName((String)"h6"), "h6");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h6s() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"h6"), "h6"));
        }

        protected BaseFluentWebElement h6(By by) {
            SingleResult single = this.single(by, "h6");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements h6s(By by) {
            return this.newFluentWebElements(this.multiple(by, "h6"));
        }

        protected BaseFluentWebElement p() {
            SingleResult single = this.single(By.tagName((String)"p"), "p");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ps() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"p"), "p"));
        }

        protected BaseFluentWebElement nav() {
            SingleResult single = this.single(By.tagName((String)"nav"), "nav");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements navs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"nav"), "nav"));
        }

        protected BaseFluentWebElement nav(By by) {
            SingleResult single = this.single(by, "nav");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements navs(By by) {
            return this.newFluentWebElements(this.multiple(by, "nav"));
        }

        protected BaseFluentWebElement tbody() {
            SingleResult single = this.single(By.tagName((String)"tbody"), "tbody");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tbodys() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"tbody"), "tbody"));
        }

        protected BaseFluentWebElement tbody(By by) {
            SingleResult single = this.single(by, "tbody");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tbodys(By by) {
            return this.newFluentWebElements(this.multiple(by, "tbody"));
        }

        protected BaseFluentWebElement p(By by) {
            SingleResult single = this.single(by, "p");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement figure() {
            SingleResult single = this.single(By.tagName((String)"figure"), "figure");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement abbr() {
            SingleResult single = this.single(By.tagName((String)"abbr"), "abbr");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement blockquote() {
            SingleResult single = this.single(By.tagName((String)"blockquote"), "blockquote");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement label() {
            SingleResult single = this.single(By.tagName((String)"label"), "label");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements labels() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"label"), "label"));
        }

        protected BaseFluentWebElement label(By by) {
            SingleResult single = this.single(by, "label");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements labels(By by) {
            return this.newFluentWebElements(this.multiple(by, "label"));
        }

        protected BaseFluentWebElement object() {
            SingleResult single = this.single(By.tagName((String)"object"), "object");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements objects() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"object"), "object"));
        }

        protected BaseFluentWebElement object(By by) {
            SingleResult single = this.single(by, "object");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements objects(By by) {
            return this.newFluentWebElements(this.multiple(by, "object"));
        }

        protected BaseFluentWebElements blockquotes() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"blockquote"), "blockquote"));
        }

        protected BaseFluentWebElement blockquote(By by) {
            SingleResult single = this.single(by, "blockquote");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements blockquotes(By by) {
            return this.newFluentWebElements(this.multiple(by, "blockquote"));
        }

        protected BaseFluentWebElement area() {
            SingleResult single = this.single(By.tagName((String)"area"), "area");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements areas() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"area"), "area"));
        }

        protected BaseFluentWebElement area(By by) {
            SingleResult single = this.single(by, "area");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements areas(By by) {
            return this.newFluentWebElements(this.multiple(by, "area"));
        }

        protected BaseFluentWebElements abbrs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"abbr"), "abbr"));
        }

        protected BaseFluentWebElement abbr(By by) {
            SingleResult single = this.single(by, "abbr");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements abbrs(By by) {
            return this.newFluentWebElements(this.multiple(by, "abbr"));
        }

        protected BaseFluentWebElement address() {
            SingleResult single = this.single(By.tagName((String)"address"), "address");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements addresses() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"address"), "address"));
        }

        protected BaseFluentWebElement address(By by) {
            SingleResult single = this.single(by, "address");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements addresses(By by) {
            return this.newFluentWebElements(this.multiple(by, "address"));
        }

        protected BaseFluentWebElements figures() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"figure"), "figure"));
        }

        protected BaseFluentWebElement figure(By by) {
            SingleResult single = this.single(by, "figure");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements figures(By by) {
            return this.newFluentWebElements(this.multiple(by, "figure"));
        }

        protected BaseFluentWebElement acronym() {
            SingleResult single = this.single(By.tagName((String)"acronym"), "acronym");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements acronyms() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"acronym"), "acronym"));
        }

        protected BaseFluentWebElement acronym(By by) {
            SingleResult single = this.single(by, "acronym");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements acronyms(By by) {
            return this.newFluentWebElements(this.multiple(by, "acronym"));
        }

        protected BaseFluentWebElements ps(By by) {
            return this.newFluentWebElements(this.multiple(by, "p"));
        }

        protected BaseFluentWebElement b() {
            SingleResult single = this.single(By.tagName((String)"b"), "b");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement header() {
            SingleResult single = this.single(By.tagName((String)"header"), "header");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements headers() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"header"), "header"));
        }

        protected BaseFluentWebElement header(By by) {
            SingleResult single = this.single(by, "header");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements headers(By by) {
            return this.newFluentWebElements(this.multiple(by, "header"));
        }

        protected BaseFluentWebElement footer() {
            SingleResult single = this.single(By.tagName((String)"footer"), "footer");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements footers() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"footer"), "footer"));
        }

        protected BaseFluentWebElement footer(By by) {
            SingleResult single = this.single(by, "footer");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements footers(By by) {
            return this.newFluentWebElements(this.multiple(by, "footer"));
        }

        protected BaseFluentWebElements bs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"b"), "b"));
        }

        protected BaseFluentWebElement b(By by) {
            SingleResult single = this.single(by, "b");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements bs(By by) {
            return this.newFluentWebElements(this.multiple(by, "b"));
        }

        protected BaseFluentWebElement pre() {
            SingleResult single = this.single(By.tagName((String)"pre"), "pre");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements pres() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"pre"), "pre"));
        }

        protected BaseFluentWebElement pre(By by) {
            SingleResult single = this.single(by, "pre");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements pres(By by) {
            return this.newFluentWebElements(this.multiple(by, "pre"));
        }

        protected BaseFluentWebElement img() {
            SingleResult single = this.single(By.tagName((String)"img"), "img");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements imgs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"img"), "img"));
        }

        protected BaseFluentWebElement img(By by) {
            SingleResult single = this.single(by, "img");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements imgs(By by) {
            return this.newFluentWebElements(this.multiple(by, "img"));
        }

        protected BaseFluentWebElement table() {
            SingleResult single = this.single(By.tagName((String)"table"), "table");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tables() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"table"), "table"));
        }

        protected BaseFluentWebElement table(By by) {
            SingleResult single = this.single(by, "table");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tables(By by) {
            return this.newFluentWebElements(this.multiple(by, "table"));
        }

        protected BaseFluentWebElement fieldset() {
            SingleResult single = this.single(By.tagName((String)"fieldset"), "fieldset");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements fieldsets() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"fieldset"), "fieldset"));
        }

        protected BaseFluentWebElement fieldset(By by) {
            SingleResult single = this.single(by, "fieldset");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements fieldsets(By by) {
            return this.newFluentWebElements(this.multiple(by, "fieldset"));
        }

        protected BaseFluentWebElement legend() {
            SingleResult single = this.single(By.tagName((String)"legend"), "legend");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements legends() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"legend"), "legend"));
        }

        protected BaseFluentWebElement legend(By by) {
            SingleResult single = this.single(by, "legend");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements legends(By by) {
            return this.newFluentWebElements(this.multiple(by, "legend"));
        }

        protected BaseFluentWebElement tr() {
            SingleResult single = this.single(By.tagName((String)"tr"), "tr");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements trs() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"tr"), "tr"));
        }

        protected BaseFluentWebElement tr(By by) {
            SingleResult single = this.single(by, "tr");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements trs(By by) {
            return this.newFluentWebElements(this.multiple(by, "tr"));
        }

        protected BaseFluentWebElement td() {
            SingleResult single = this.single(By.tagName((String)"td"), "td");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tds() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"td"), "td"));
        }

        protected BaseFluentWebElement td(By by) {
            SingleResult single = this.single(by, "td");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements tds(By by) {
            return this.newFluentWebElements(this.multiple(by, "td"));
        }

        protected BaseFluentWebElement th() {
            SingleResult single = this.single(By.tagName((String)"th"), "th");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ths() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"th"), "th"));
        }

        protected BaseFluentWebElement th(By by) {
            SingleResult single = this.single(by, "th");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ths(By by) {
            return this.newFluentWebElements(this.multiple(by, "th"));
        }

        protected BaseFluentWebElement ul() {
            SingleResult single = this.single(By.tagName((String)"ul"), "ul");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements uls() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"ul"), "ul"));
        }

        protected BaseFluentWebElement ul(By by) {
            SingleResult single = this.single(by, "ul");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements uls(By by) {
            return this.newFluentWebElements(this.multiple(by, "ul"));
        }

        protected BaseFluentWebElement ol() {
            SingleResult single = this.single(By.tagName((String)"ol"), "ol");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ols() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"ol"), "ol"));
        }

        protected BaseFluentWebElement ol(By by) {
            SingleResult single = this.single(by, "ol");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements ols(By by) {
            return this.newFluentWebElements(this.multiple(by, "ol"));
        }

        protected BaseFluentWebElement form() {
            SingleResult single = this.single(By.tagName((String)"form"), "form");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements forms() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"form"), "form"));
        }

        protected BaseFluentWebElement form(By by) {
            SingleResult single = this.single(by, "form");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements forms(By by) {
            return this.newFluentWebElements(this.multiple(by, "form"));
        }

        protected BaseFluentWebElement textarea() {
            SingleResult single = this.single(By.tagName((String)"textarea"), "textarea");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements textareas() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"textarea"), "textarea"));
        }

        protected BaseFluentWebElement textarea(By by) {
            SingleResult single = this.single(by, "textarea");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements textareas(By by) {
            return this.newFluentWebElements(this.multiple(by, "textarea"));
        }

        protected BaseFluentWebElement option() {
            SingleResult single = this.single(By.tagName((String)"option"), "option");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements options() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"option"), "option"));
        }

        protected BaseFluentWebElement option(By by) {
            SingleResult single = this.single(by, "option");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements options(By by) {
            return this.newFluentWebElements(this.multiple(by, "option"));
        }

        protected BaseFluentWebElement li() {
            SingleResult single = this.single(By.tagName((String)"li"), "li");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElement li(By by) {
            SingleResult single = this.single(by, "li");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements lis() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"li"), "li"));
        }

        protected BaseFluentWebElements lis(By by) {
            return this.newFluentWebElements(this.multiple(by, "li"));
        }

        protected BaseFluentWebElement map() {
            SingleResult single = this.single(By.tagName((String)"map"), "map");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements maps() {
            return this.newFluentWebElements(this.multiple(By.tagName((String)"map"), "map"));
        }

        protected BaseFluentWebElement map(By by) {
            SingleResult single = this.single(by, "map");
            return this.newFluentWebElement(this.delegate, single.getResult(), single.getCtx());
        }

        protected BaseFluentWebElements maps(By by) {
            return this.newFluentWebElements(this.multiple(by, "map"));
        }

        protected BaseFluentWebElement newFluentWebElement(WebDriver delegate, WebElementHolder result, Context context) {
            return new FluentWebElement(delegate, result, context, this.monitor, this.booleanInsteadOfNotFoundException);
        }

        public TestableString url() {
            CurrentUrl execution = new CurrentUrl();
            Context ctx = Context.singular(this.context, "url");
            return new TestableString(execution, ctx, this.monitor).within(this.getPeriod());
        }

        protected Period getPeriod() {
            return null;
        }

        public TestableString title() {
            GetTitle execution = new GetTitle();
            Context ctx = Context.singular(this.context, "title");
            return new TestableString(execution, ctx, this.monitor).within(this.getPeriod());
        }

        protected abstract FluentWebElements makeFluentWebElements(List<FluentWebElement> var1, Context var2, Monitor var3);

        protected final By fixupBy(By by, String tagName) {
            if (by.getClass().getName().equals("org.openqa.selenium.By$ByXPath")) {
                by = By.xpath((String)(".//" + tagName + "[" + by.toString().substring(by.toString().indexOf(":") + 1).trim() + "]"));
            } else if (by.getClass().getName().equals("org.openqa.selenium.By$ByClassName")) {
                by = FluentBy.composite(new By.ByTagName(tagName), (By.ByClassName)by);
            } else if (by instanceof FluentBy.NotByAttribute) {
                by = By.xpath((String)(".//" + tagName + "[" + ((FluentBy.NotByAttribute)by).nameAndValue() + "]"));
            }
            return by;
        }

        protected final void assertTagIs(String is, String shouldBe) {
            if (!is.equalsIgnoreCase(shouldBe)) {
                throw new AssertionError((Object)("tag was incorrect, should have been " + shouldBe + " but was " + is));
            }
        }

        protected abstract WebElement findElement(By var1, Context var2, SearchContext var3);

        protected abstract List<WebElement> findElements(By var1, Context var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SingleResult single(By by, String tagName) {
            WebElementHolder result;
            By by2 = this.fixupBy(by, tagName);
            Context ctx = this.contextualize(by2, tagName);
            try {
                this.changeTimeout();
                FindElement execution = new FindElement(by2, tagName, ctx, this.getSearchContext());
                WebElement found = this.executeAndWrapReThrowIfNeeded(execution, null, ctx, true);
                result = new WebElementHolder(this.getSearchContext(), found, by2);
            }
            finally {
                this.resetTimeout();
            }
            return new SingleResult(result, ctx);
        }

        private Context contextualize(By by, String tagName) {
            if (by.toString().equals("By.tagName: " + tagName)) {
                by = null;
            }
            return Context.singular(this.context, tagName, by);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MultipleResult multiple(By by, String tagName) {
            List<WebElement> result;
            By by2 = this.fixupBy(by, tagName);
            Context ctx = Context.plural(this.context, tagName, by);
            try {
                this.changeTimeout();
                FindElements execution = new FindElements(by2, tagName, ctx);
                result = this.executeAndWrapReThrowIfNeeded(execution, null, ctx, true);
            }
            finally {
                this.resetTimeout();
            }
            return new MultipleResult(result, ctx);
        }

        protected static FluentExecutionStopped wrapRuntimeException(Context ctx, RuntimeException e) {
            FluentExecutionStopped rv = null;
            rv = e instanceof StaleElementReferenceException ? new FluentExecutionStopped.BecauseOfStaleElement(BaseFluentWebDriver.replacePkgNames(e) + ctx, e) : (e instanceof NothingMatches ? new FluentExecutionStopped.BecauseNothingMatchesInFilter("Nothing matched filter, during invocation of: " + ctx) : new FluentExecutionStopped(BaseFluentWebDriver.replacePkgNames(e) + ctx, e));
            return rv;
        }

        private static String replacePkgNames(Throwable e) {
            return e.getClass().getName().replace("java.lang.", "").replace("org.openqa.selenium.", "") + " during invocation of: ";
        }

        protected static FluentExecutionStopped wrapAssertionError(Context ctx, AssertionError e) {
            return new FluentExecutionStopped(BaseFluentWebDriver.replacePkgNames((Throwable)((Object)e)) + ctx, (Throwable)((Object)e));
        }

        protected <T> T executeAndWrapReThrowIfNeeded(Execution<T> execution, WebElementHolder currentElement, Context ctx, boolean expectedToBeThere) {
            execution.withWebElementHolder(currentElement);
            Monitor.Timer timer = this.monitor.start(ctx.toString().substring(2));
            boolean success = false;
            try {
                T t = execution.doExecution();
                success = true;
                T t2 = t;
                return t2;
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                FluentExecutionStopped ex = BaseFluentWebDriver.wrapRuntimeException(ctx, e);
                if (expectedToBeThere) {
                    throw this.monitor.exceptionDuringExecution(ex, this.currentWebElement(execution));
                }
                throw ex;
            }
            catch (AssertionError e) {
                FluentExecutionStopped ex = BaseFluentWebDriver.wrapAssertionError(ctx, e);
                if (expectedToBeThere) {
                    throw this.monitor.exceptionDuringExecution(ex, this.currentWebElement(execution));
                }
                throw ex;
            }
            finally {
                timer.end(success);
            }
        }

        private <T> WebElement currentWebElement(Execution<T> execution) {
            SearchContext searchContext;
            WebElement webElement = execution.getWebElement();
            if (webElement == null && execution instanceof FindElement && (searchContext = ((FindElement)execution).searchContext) instanceof WebElement) {
                webElement = (WebElement)searchContext;
            }
            return webElement;
        }

        protected void changeTimeout() {
        }

        protected void resetTimeout() {
        }

        protected final WebElement retryingFindIt(By by, SearchContext searchContext) {
            long endMillis = this.getPeriod().getEndMillis(System.currentTimeMillis());
            WebDriverException exceptionCausingRetry = null;
            boolean toRetry = true;
            WebElement it = null;
            while (toRetry && endMillis - System.currentTimeMillis() > 0L) {
                try {
                    it = this.actualFindElement(by, this.context, searchContext);
                    toRetry = false;
                    return it;
                }
                catch (WebDriverException e) {
                    exceptionCausingRetry = e;
                }
            }
            throw exceptionCausingRetry;
        }

        protected final List<WebElement> retryingFindThem(By by) {
            long endMillis = this.getPeriod().getEndMillis(System.currentTimeMillis());
            WebDriverException exceptionCausingRetry = null;
            boolean toRetry = true;
            List<WebElement> them = null;
            while (toRetry && endMillis - System.currentTimeMillis() > 0L) {
                try {
                    them = this.actualFindElements(by, this.context);
                    toRetry = false;
                    return them;
                }
                catch (WebDriverException e) {
                    exceptionCausingRetry = e;
                }
            }
            if (toRetry) {
                throw exceptionCausingRetry;
            }
            return them;
        }

        protected abstract WebElement actualFindElement(By var1, Context var2, SearchContext var3);

        protected abstract List<WebElement> actualFindElements(By var1, Context var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class GetTitle
        extends Execution<String> {
            private GetTitle() {
            }

            @Override
            public String execute() {
                return BaseFluentWebDriver.this.delegate.getTitle();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CurrentUrl
        extends Execution<String> {
            private CurrentUrl() {
            }

            @Override
            public String execute() {
                return BaseFluentWebDriver.this.delegate.getCurrentUrl();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FindElements
        extends Execution<List<WebElement>> {
            private final By by2;
            private final String tagName;
            private final Context ctx;

            public FindElements(By by2, String tagName, Context ctx) {
                this.by2 = by2;
                this.tagName = tagName;
                this.ctx = ctx;
            }

            @Override
            public List<WebElement> execute() {
                List<WebElement> results = BaseFluentWebDriver.this.findElements(this.by2, this.ctx);
                if (!BaseFluentWebDriver.GENERIC_TAG.equals(this.tagName)) {
                    for (WebElement webElement : results) {
                        BaseFluentWebDriver.this.assertTagIs(webElement.getTagName(), this.tagName);
                    }
                }
                return results;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class MultipleResult {
            private final List<WebElement> result;
            private final Context ctx;

            public MultipleResult(List<WebElement> result, Context ctx) {
                this.result = result;
                this.ctx = ctx;
            }

            public List<WebElement> getResult() {
                return this.result;
            }

            public Context getCtx() {
                return this.ctx;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FindElement
        extends Execution<WebElement> {
            private final By by2;
            private final String tagName;
            private final Context ctx;
            private final SearchContext searchContext;

            public FindElement(By by2, String tagName, Context ctx, SearchContext searchContext) {
                this.by2 = by2;
                this.tagName = tagName;
                this.ctx = ctx;
                this.searchContext = searchContext;
            }

            @Override
            public WebElement execute() {
                if (BaseFluentWebDriver.this.booleanInsteadOfNotFoundException) {
                    try {
                        BaseFluentWebDriver.this.findElement(this.by2, this.ctx, this.searchContext);
                        return new FoundOrNotFound(true);
                    }
                    catch (NotFoundException e) {
                        return new FoundOrNotFound(false);
                    }
                }
                WebElement it = BaseFluentWebDriver.this.findElement(this.by2, this.ctx, this.searchContext);
                if (!BaseFluentWebDriver.GENERIC_TAG.equals(this.tagName)) {
                    BaseFluentWebDriver.this.assertTagIs(it.getTagName(), this.tagName);
                }
                return it;
            }
        }

        public static class SingleResult {
            private final WebElementHolder result;
            private final Context ctx;

            public SingleResult(WebElementHolder result, Context ctx) {
                this.result = result;
                this.ctx = ctx;
            }

            public WebElementHolder getResult() {
                return this.result;
            }

            public Context getCtx() {
                return this.ctx;
            }
        }
    }
}

