/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.Period;

public abstract class RetryAfterStaleElement {
    public abstract void toRetry();

    public void stopAfter(Period period) {
        boolean again = true;
        long start = System.currentTimeMillis();
        long endMillis = period.getEndMillis(start);
        FluentExecutionStopped ex = null;
        while (again && System.currentTimeMillis() < endMillis) {
            ex = null;
            try {
                this.toRetry();
                again = false;
            }
            catch (FluentExecutionStopped.BecauseOfStaleElement e) {
                ex = e;
            }
        }
        if (ex != null) {
            ex.setDuration(System.currentTimeMillis() - start);
            throw ex;
        }
    }
}

