/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.concurrent.TimeUnit;

public abstract class Period {
    public abstract int howLong();

    public abstract TimeUnit timeUnit();

    public abstract long getEndMillis(long var1);

    public static Period millis(int millis) {
        return new Milliseconds(millis);
    }

    public static Period secs(int secs) {
        return new Seconds(secs);
    }

    public static Period mins(int mins) {
        return new Minutes(mins);
    }

    public static class Milliseconds
    extends Period {
        private final int millis;

        public Milliseconds(int millis) {
            this.millis = millis;
        }

        @Override
        public int howLong() {
            return this.millis;
        }

        @Override
        public TimeUnit timeUnit() {
            return TimeUnit.MILLISECONDS;
        }

        @Override
        public final long getEndMillis(long from) {
            return from + (long)this.millis;
        }

        public String toString() {
            return "millis(" + this.millis + ")";
        }
    }

    public static class Minutes
    extends Seconds {
        private final int mins;

        public Minutes(int mins) {
            super(mins * 60);
            this.mins = mins;
        }

        @Override
        public int howLong() {
            return this.mins;
        }

        @Override
        public TimeUnit timeUnit() {
            return TimeUnit.MINUTES;
        }

        @Override
        public String toString() {
            return "mins(" + this.mins + ")";
        }
    }

    public static class Seconds
    extends Milliseconds {
        private final int secs;

        public Seconds(int secs) {
            super(secs * 1000);
            this.secs = secs;
        }

        @Override
        public int howLong() {
            return this.secs;
        }

        @Override
        public TimeUnit timeUnit() {
            return TimeUnit.SECONDS;
        }

        @Override
        public String toString() {
            return "secs(" + this.secs + ")";
        }
    }
}

