/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentWebDriver;
import org.seleniumhq.selenium.fluent.recording.OnFluentSomething;
import org.seleniumhq.selenium.fluent.recording.RetryStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentRecording {
    private final List<OnFluentSomething> onFluentSomethings;
    private final RetryStrategy[] retryStrategies;
    private final int millisToSleep;

    public FluentRecording(List<OnFluentSomething> onFluentSomethings, int millisToSleep, RetryStrategy ... retryStrategies) {
        this.onFluentSomethings = onFluentSomethings;
        this.retryStrategies = retryStrategies;
        this.millisToSleep = millisToSleep;
    }

    public Object playback(FluentWebDriver driver) {
        long start = System.currentTimeMillis();
        int retries = 0;
        RuntimeException lastRE = null;
        AssertionError lastAE = null;
        boolean goAgain = true;
        while (goAgain) {
            lastAE = null;
            lastRE = null;
            goAgain = false;
            try {
                Object last = driver;
                for (OnFluentSomething o : this.onFluentSomethings) {
                    last = o.dispatch(last);
                }
                return last;
            }
            catch (FluentExecutionStopped e) {
                lastRE = e;
                goAgain = this.retry(e, start, retries);
            }
            catch (RuntimeException e) {
                lastRE = e;
                goAgain = this.retry(e, start, retries);
            }
            catch (AssertionError e) {
                lastAE = e;
                goAgain = this.retry((Throwable)((Object)e), start, retries);
            }
            if (!goAgain) continue;
            try {
                Thread.sleep(this.millisToSleep);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++retries;
        }
        if (lastRE != null) {
            if (lastRE instanceof FluentExecutionStopped && retries > 0) {
                ((FluentExecutionStopped)lastRE).setRetries(retries).setDuration(System.currentTimeMillis() - start);
            }
            throw lastRE;
        }
        throw lastAE;
    }

    private boolean retry(Throwable e, long start, int retries) {
        boolean shouldRetry = this.retryStrategies.length > 0;
        for (RetryStrategy retryStrategy : this.retryStrategies) {
            shouldRetry &= retryStrategy.shouldRetry(e, start, retries);
        }
        return shouldRetry;
    }
}

