/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.BaseFluentWebDriver;
import org.seleniumhq.selenium.fluent.BaseFluentWebElement;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.WebElementValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElement
extends BaseFluentWebElement {
    protected final WebElement currentElement;

    public FluentWebElement(WebDriver delegate, WebElement currentElement, BaseFluentWebDriver.Context context) {
        super(delegate, context);
        this.currentElement = currentElement;
    }

    protected WebElement getWebElement() {
        return this.currentElement;
    }

    @Override
    protected WebElement findIt(By by) {
        return this.actualFindIt(by);
    }

    @Override
    protected List<WebElement> findThem(By by) {
        return this.actualFindThem(by);
    }

    @Override
    protected WebElement actualFindIt(By by) {
        return this.currentElement.findElement(by);
    }

    @Override
    protected List<WebElement> actualFindThem(By by) {
        return this.currentElement.findElements(by);
    }

    public FluentWebElement click() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "click");
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentWebElement.this.currentElement.click();
                return true;
            }
        }, ctx);
        return new FluentWebElement(this.delegate, this.currentElement, ctx);
    }

    public FluentWebElement clearField() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "clearField");
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentWebElement.this.currentElement.clear();
                return true;
            }
        }, ctx);
        return new FluentWebElement(this.delegate, this.currentElement, ctx);
    }

    public FluentWebElement submit() {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentWebElement.this.currentElement.submit();
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "submit"));
        return new FluentWebElement(this.delegate, this.currentElement, this.context);
    }

    public FluentWebElement sendKeys(final CharSequence ... keysToSend) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentWebElement.this.currentElement.sendKeys(keysToSend);
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "sendKeys", null, this.charSeqArrayAsHumanString(keysToSend)));
        return new FluentWebElement(this.delegate, this.currentElement, this.context);
    }

    @Override
    public TestableString getTagName() {
        return new TestableString(this.getPeriod(), new Execution<String>(){

            @Override
            public String execute() {
                return FluentWebElement.this.currentElement.getTagName();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getTagName"));
    }

    @Override
    public boolean isSelected() {
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                return FluentWebElement.this.currentElement.isSelected();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "isSelected"));
    }

    @Override
    public boolean isEnabled() {
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                return FluentWebElement.this.currentElement.isEnabled();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "isEnabled"));
    }

    @Override
    public boolean isDisplayed() {
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                return FluentWebElement.this.currentElement.isDisplayed();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "isDisplayed"));
    }

    @Override
    public Point getLocation() {
        return this.decorateExecution(new Execution<Point>(){

            @Override
            public Point execute() {
                return FluentWebElement.this.currentElement.getLocation();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getLocation"));
    }

    @Override
    public Dimension getSize() {
        return this.decorateExecution(new Execution<Dimension>(){

            @Override
            public Dimension execute() {
                return FluentWebElement.this.currentElement.getSize();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getSize"));
    }

    @Override
    public TestableString getCssValue(final String cssName) {
        return new TestableString(this.getPeriod(), new Execution<String>(){

            @Override
            public String execute() {
                return FluentWebElement.this.currentElement.getCssValue(cssName);
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getCssValue", null, cssName));
    }

    @Override
    public TestableString getAttribute(final String attr) {
        return new TestableString(this.getPeriod(), new Execution<String>(){

            @Override
            public String execute() {
                return FluentWebElement.this.currentElement.getAttribute(attr);
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getAttribute", null, attr));
    }

    @Override
    public TestableString getText() {
        return new TestableString(this.getPeriod(), new Execution<String>(){

            @Override
            public String execute() {
                return FluentWebElement.this.currentElement.getText();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getText"));
    }

    public WebElementValue<Point> location() {
        return new WebElementValue<Point>(this.currentElement.getLocation(), BaseFluentWebDriver.Context.singular(this.context, "location"));
    }

    public WebElementValue<Dimension> size() {
        return new WebElementValue<Dimension>(this.currentElement.getSize(), BaseFluentWebDriver.Context.singular(this.context, "size"));
    }

    public WebElementValue<String> cssValue(String name) {
        return new WebElementValue<String>(this.currentElement.getCssValue(name), BaseFluentWebDriver.Context.singular(this.context, "cssValue"));
    }

    public WebElementValue<String> attribute(String name) {
        return new WebElementValue<String>(this.currentElement.getAttribute(name), BaseFluentWebDriver.Context.singular(this.context, "attribute"));
    }

    public WebElementValue<String> tagName() {
        return new WebElementValue<String>(this.currentElement.getTagName(), BaseFluentWebDriver.Context.singular(this.context, "tagName"));
    }

    public WebElementValue<Boolean> selected() {
        return new WebElementValue<Boolean>(this.currentElement.isSelected(), BaseFluentWebDriver.Context.singular(this.context, "selected"));
    }

    public WebElementValue<Boolean> enabled() {
        return new WebElementValue<Boolean>(this.currentElement.isEnabled(), BaseFluentWebDriver.Context.singular(this.context, "enabled"));
    }

    public WebElementValue<Boolean> displayed() {
        return new WebElementValue<Boolean>(this.currentElement.isDisplayed(), BaseFluentWebDriver.Context.singular(this.context, "isDisplayed"));
    }

    public WebElementValue<String> text() {
        return new WebElementValue<String>(this.currentElement.getText(), BaseFluentWebDriver.Context.singular(this.context, "text()"));
    }

    @Override
    public FluentWebElement within(Period period) {
        return new RetryingFluentWebElement(this.delegate, this.currentElement, BaseFluentWebDriver.Context.singular(this.context, "within", null, period), period);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RetryingFluentWebElement
    extends FluentWebElement {
        private final Period period;

        public RetryingFluentWebElement(WebDriver webDriver, WebElement currentElement, BaseFluentWebDriver.Context context, Period period) {
            super(webDriver, currentElement, context);
            this.period = period;
        }

        @Override
        protected Period getPeriod() {
            return this.period;
        }

        @Override
        protected WebElement findIt(By by) {
            return this.retryingFindIt(by);
        }

        @Override
        protected List<WebElement> findThem(By by) {
            return this.retryingFindThem(by);
        }

        @Override
        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
        }

        @Override
        protected void resetTimeout() {
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

