/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.concurrent.TimeUnit;

public abstract class Period {
    public abstract int howLong();

    public abstract TimeUnit timeUnit();

    public abstract long getEndMillis(long var1);

    public static Period millis(int millis) {
        return new Milliseconds(millis);
    }

    public static Period secs(int secs) {
        return new Seconds(secs);
    }

    public static Period mins(int mins) {
        return new Minutes(mins);
    }

    public static class Milliseconds
    extends Period {
        private final int millis;

        public Milliseconds(int millis) {
            this.millis = millis;
        }

        public int howLong() {
            return this.millis;
        }

        public TimeUnit timeUnit() {
            return TimeUnit.MILLISECONDS;
        }

        public long getEndMillis(long from) {
            return from + (long)this.millis;
        }

        public String toString() {
            return "millis(" + this.millis + ")";
        }
    }

    public static class Minutes
    extends Period {
        private final int mins;

        public Minutes(int mins) {
            this.mins = mins;
        }

        public int howLong() {
            return this.mins;
        }

        public TimeUnit timeUnit() {
            return TimeUnit.MINUTES;
        }

        public long getEndMillis(long from) {
            return from + (long)(this.mins * 1000 * 60);
        }

        public String toString() {
            return "mins(" + this.mins + ")";
        }
    }

    public static class Seconds
    extends Period {
        private final int secs;

        public Seconds(int secs) {
            this.secs = secs;
        }

        public int howLong() {
            return this.secs;
        }

        public TimeUnit timeUnit() {
            return TimeUnit.SECONDS;
        }

        public long getEndMillis(long from) {
            return from + (long)(this.secs * 1000);
        }

        public String toString() {
            return "secs(" + this.secs + ")";
        }
    }
}

