/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.StaleElementReferenceException;
import org.seleniumhq.selenium.fluent.BaseFluentWebDriver;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestableString
implements CharSequence {
    private String is;
    private final Period within;
    private final Execution<String> execution;
    private final BaseFluentWebDriver.Context context;

    public TestableString(Period within, Execution<String> execution, BaseFluentWebDriver.Context ctx) {
        this.within = within;
        this.execution = execution;
        this.context = ctx;
        if (within == null && execution == null && ctx == null) {
            return;
        }
        if (within == null) {
            try {
                this.is = execution.execute();
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
            }
            catch (AssertionError e) {
                throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
            }
        }
    }

    public void shouldBe(String shouldBe) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldBe", null, shouldBe);
        try {
            if (!(this.within == null || this.is != null && this.is.equals(shouldBe))) {
                boolean passed;
                long endMillis = this.within.getEndMillis(System.currentTimeMillis());
                do {
                    this.assignValueIfNeeded();
                    boolean bl = passed = this.is != null && this.is.equals(shouldBe);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((Object)this.is, (Matcher)CoreMatchers.equalTo((Object)shouldBe));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    private void assignValueIfNeeded() {
        if (this.is != null) {
            return;
        }
        this.is = this.execution.execute();
    }

    public void shouldNotBe(String shouldNotBe) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldNotBe", null, shouldNotBe);
        try {
            if (this.within != null && (this.is == null || this.is.equals(shouldNotBe))) {
                boolean passed;
                long endMillis = this.within.getEndMillis(System.currentTimeMillis());
                do {
                    this.assignValueIfNeeded();
                    boolean bl = passed = this.is != null && !this.is.equals(shouldNotBe);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((Object)this.is, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)shouldNotBe)));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (StaleElementReferenceException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, (RuntimeException)((Object)e));
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    public void shouldContain(String shouldContain) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldContain", null, shouldContain);
        try {
            if (this.within != null && (this.is == null || this.is.indexOf(shouldContain) == -1)) {
                boolean passed;
                long endMillis = this.within.getEndMillis(System.currentTimeMillis());
                do {
                    this.assignValueIfNeeded();
                    boolean bl = passed = this.is != null && this.is.indexOf(shouldContain) > -1;
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((Object)this.is, (Matcher)Matchers.containsString((String)shouldContain));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (StaleElementReferenceException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, (RuntimeException)((Object)e));
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    public void shouldNotContain(String shouldNotContain) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldNotContain", null, shouldNotContain);
        try {
            if (this.within != null && (this.is == null || this.is.indexOf(shouldNotContain) > -1)) {
                boolean passed;
                long endMillis = this.within.getEndMillis(System.currentTimeMillis());
                do {
                    this.assignValueIfNeeded();
                    boolean bl = passed = this.is != null && this.is.indexOf(shouldNotContain) == -1;
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((Object)this.is, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)shouldNotContain)));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (StaleElementReferenceException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, (RuntimeException)((Object)e));
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    @Override
    public int length() {
        this.assignValueIfNeeded();
        return this.is.length();
    }

    @Override
    public char charAt(int i) {
        this.assignValueIfNeeded();
        return this.is.charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        this.assignValueIfNeeded();
        return this.is.subSequence(i, i1);
    }

    public boolean equals(Object o) {
        this.assignValueIfNeeded();
        if (this == o) {
            return true;
        }
        return o.equals(this.is);
    }

    public int hashCode() {
        this.assignValueIfNeeded();
        return this.is.hashCode();
    }

    @Override
    public String toString() {
        this.assignValueIfNeeded();
        return this.is;
    }

    public String replace(CharSequence from, CharSequence to) {
        return this.is.replace(from, to);
    }
}

