/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.FluentBy;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentMatcher;
import org.seleniumhq.selenium.fluent.FluentSelect;
import org.seleniumhq.selenium.fluent.FluentSelects;
import org.seleniumhq.selenium.fluent.FluentWebDriver;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.FluentWebElements;
import org.seleniumhq.selenium.fluent.NothingMatches;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFluentWebDriver
implements FluentWebDriver {
    private static final RuntimeException AN_EXCEPTION = new RuntimeException();
    protected final WebDriver delegate;
    protected final Context context;

    public BaseFluentWebDriver(WebDriver delegate, Context context) {
        this.delegate = delegate;
        this.context = context;
    }

    @Override
    public FluentWebElement span() {
        SingleResult single = this.single(By.tagName((String)"span"), "span");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElement span(By by) {
        SingleResult single = this.single(by, "span");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements spans() {
        MultipleResult multiple = this.multiple(By.tagName((String)"span"), "span");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    private FluentWebElements newFluentWebElements(List<WebElement> result, Context ctx) {
        ArrayList<FluentWebElement> elems = new ArrayList<FluentWebElement>();
        for (WebElement aResult : result) {
            elems.add(new FluentWebElement(this.delegate, aResult, ctx));
        }
        return new FluentWebElements(this.delegate, elems, ctx);
    }

    private FluentSelects newFluentSelects(List<WebElement> result, Context ctx) {
        ArrayList<FluentWebElement> elems = new ArrayList<FluentWebElement>();
        for (WebElement aResult : result) {
            elems.add(new FluentSelect(this.delegate, aResult, ctx));
        }
        return new FluentSelects(this.delegate, elems, ctx);
    }

    @Override
    public FluentWebElements spans(By by) {
        MultipleResult multiple = this.multiple(by, "span");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement div() {
        SingleResult single = this.single(By.tagName((String)"div"), "div");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElement div(By by) {
        SingleResult single = this.single(by, "div");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements divs() {
        MultipleResult multiple = this.multiple(By.tagName((String)"div"), "div");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElements divs(By by) {
        MultipleResult multiple = this.multiple(by, "div");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement button() {
        SingleResult single = this.single(By.tagName((String)"button"), "button");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElement button(By by) {
        SingleResult single = this.single(by, "button");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements buttons() {
        MultipleResult multiple = this.multiple(By.tagName((String)"button"), "button");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElements buttons(By by) {
        MultipleResult multiple = this.multiple(by, "button");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement link() {
        SingleResult single = this.single(By.tagName((String)"a"), "a");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElement link(By by) {
        SingleResult single = this.single(by, "a");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements links() {
        MultipleResult multiple = this.multiple(By.tagName((String)"a"), "a");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElements links(By by) {
        MultipleResult multiple = this.multiple(by, "a");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement input() {
        SingleResult single = this.single(By.tagName((String)"input"), "input");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElement input(By by) {
        SingleResult single = this.single(by, "input");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements inputs() {
        MultipleResult multiple = this.multiple(By.tagName((String)"input"), "input");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElements inputs(By by) {
        MultipleResult multiple = this.multiple(by, "input");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentSelect select() {
        SingleResult single = this.single(By.tagName((String)"select"), "select");
        return new FluentSelect(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentSelect select(By by) {
        SingleResult single = this.single(by, "select");
        return new FluentSelect(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentSelects selects() {
        MultipleResult multiple = this.multiple(By.tagName((String)"select"), "select");
        return this.newFluentSelects(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentSelects selects(By by) {
        MultipleResult multiple = this.multiple(by, "select");
        return this.newFluentSelects(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement h1() {
        SingleResult single = this.single(By.tagName((String)"h1"), "h1");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElement h1(By by) {
        SingleResult single = this.single(by, "h1");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements h1s() {
        MultipleResult multiple = this.multiple(By.tagName((String)"h1"), "h1");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElements h1s(By by) {
        MultipleResult multiple = this.multiple(by, "h1");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement h2() {
        SingleResult single = this.single(By.tagName((String)"h2"), "h2");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElement h2(By by) {
        SingleResult single = this.single(by, "h2");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements h2s() {
        MultipleResult multiple = this.multiple(By.tagName((String)"h2"), "h2");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElements h2s(By by) {
        MultipleResult multiple = this.multiple(by, "h2");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement h3() {
        SingleResult single = this.single(By.tagName((String)"h3"), "h3");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements h3s() {
        MultipleResult multiple = this.multiple(By.tagName((String)"h3"), "h3");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement h3(By by) {
        SingleResult single = this.single(by, "h3");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements h3s(By by) {
        MultipleResult multiple = this.multiple(by, "h3");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement h4() {
        SingleResult single = this.single(By.tagName((String)"h4"), "h4");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements h4s() {
        MultipleResult multiple = this.multiple(By.tagName((String)"h4"), "h4");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement h4(By by) {
        SingleResult single = this.single(by, "h4");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements h4s(By by) {
        MultipleResult multiple = this.multiple(by, "h4");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement p() {
        SingleResult single = this.single(By.tagName((String)"p"), "p");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements ps() {
        MultipleResult multiple = this.multiple(By.tagName((String)"p"), "p");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement p(By by) {
        SingleResult single = this.single(by, "p");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements ps(By by) {
        MultipleResult multiple = this.multiple(by, "p");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement img() {
        SingleResult single = this.single(By.tagName((String)"img"), "img");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements imgs() {
        MultipleResult multiple = this.multiple(By.tagName((String)"img"), "img");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement img(By by) {
        SingleResult single = this.single(by, "img");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements imgs(By by) {
        MultipleResult multiple = this.multiple(by, "img");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement table() {
        SingleResult single = this.single(By.tagName((String)"table"), "table");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements tables() {
        MultipleResult multiple = this.multiple(By.tagName((String)"table"), "table");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement table(By by) {
        SingleResult single = this.single(by, "table");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements tables(By by) {
        MultipleResult multiple = this.multiple(by, "table");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement fieldset() {
        SingleResult single = this.single(By.tagName((String)"fieldset"), "fieldset");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements fieldsets() {
        MultipleResult multiple = this.multiple(By.tagName((String)"fieldset"), "fieldset");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement fieldset(By by) {
        SingleResult single = this.single(by, "fieldset");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements fieldsets(By by) {
        MultipleResult multiple = this.multiple(by, "fieldset");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement legend() {
        SingleResult single = this.single(By.tagName((String)"legend"), "legend");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements legends() {
        MultipleResult multiple = this.multiple(By.tagName((String)"legend"), "legend");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement legend(By by) {
        SingleResult single = this.single(by, "legend");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements legends(By by) {
        MultipleResult multiple = this.multiple(by, "legend");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement tr() {
        SingleResult single = this.single(By.tagName((String)"tr"), "tr");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements trs() {
        MultipleResult multiple = this.multiple(By.tagName((String)"tr"), "tr");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement tr(By by) {
        SingleResult single = this.single(by, "tr");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements trs(By by) {
        MultipleResult multiple = this.multiple(by, "tr");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement td() {
        SingleResult single = this.single(By.tagName((String)"td"), "td");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements tds() {
        MultipleResult multiple = this.multiple(By.tagName((String)"td"), "td");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement td(By by) {
        SingleResult single = this.single(by, "td");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements tds(By by) {
        MultipleResult multiple = this.multiple(by, "td");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement th() {
        SingleResult single = this.single(By.tagName((String)"th"), "th");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements ths() {
        MultipleResult multiple = this.multiple(By.tagName((String)"th"), "th");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement th(By by) {
        SingleResult single = this.single(by, "th");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements ths(By by) {
        MultipleResult multiple = this.multiple(by, "th");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement ul() {
        SingleResult single = this.single(By.tagName((String)"ul"), "ul");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements uls() {
        MultipleResult multiple = this.multiple(By.tagName((String)"ul"), "ul");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement ul(By by) {
        SingleResult single = this.single(by, "ul");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements uls(By by) {
        MultipleResult multiple = this.multiple(by, "ul");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement ol() {
        SingleResult single = this.single(By.tagName((String)"ol"), "ol");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements ols() {
        MultipleResult multiple = this.multiple(By.tagName((String)"ol"), "ol");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement ol(By by) {
        SingleResult single = this.single(by, "ol");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements ols(By by) {
        MultipleResult multiple = this.multiple(by, "ol");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement form() {
        SingleResult single = this.single(By.tagName((String)"form"), "form");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements forms() {
        MultipleResult multiple = this.multiple(By.tagName((String)"form"), "form");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement form(By by) {
        SingleResult single = this.single(by, "form");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements forms(By by) {
        MultipleResult multiple = this.multiple(by, "form");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement textarea() {
        SingleResult single = this.single(By.tagName((String)"textarea"), "textarea");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements textareas() {
        MultipleResult multiple = this.multiple(By.tagName((String)"textarea"), "textarea");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement textarea(By by) {
        SingleResult single = this.single(by, "textarea");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements textareas(By by) {
        MultipleResult multiple = this.multiple(by, "textarea");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement option() {
        SingleResult single = this.single(By.tagName((String)"option"), "option");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements options() {
        MultipleResult multiple = this.multiple(By.tagName((String)"option"), "option");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement option(By by) {
        SingleResult single = this.single(by, "option");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements options(By by) {
        MultipleResult multiple = this.multiple(by, "option");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement li() {
        SingleResult single = this.single(By.tagName((String)"li"), "li");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElement li(By by) {
        SingleResult single = this.single(by, "li");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements lis() {
        MultipleResult multiple = this.multiple(By.tagName((String)"li"), "li");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElements lis(By by) {
        MultipleResult multiple = this.multiple(by, "li");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement map() {
        SingleResult single = this.single(By.tagName((String)"map"), "map");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements maps() {
        MultipleResult multiple = this.multiple(By.tagName((String)"map"), "map");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public FluentWebElement map(By by) {
        SingleResult single = this.single(by, "map");
        return new FluentWebElement(this.delegate, single.getResult(), single.getCtx());
    }

    @Override
    public FluentWebElements maps(By by) {
        MultipleResult multiple = this.multiple(by, "map");
        return this.newFluentWebElements(multiple.getResult(), multiple.getCtx());
    }

    @Override
    public TestableString url() {
        Execution<String> execution = new Execution<String>(){

            @Override
            public String execute() {
                return BaseFluentWebDriver.this.delegate.getCurrentUrl();
            }
        };
        Context ctx = Context.singular(this.context, "url");
        return new TestableString(execution, ctx).within(this.getPeriod());
    }

    protected Period getPeriod() {
        return null;
    }

    @Override
    public TestableString title() {
        Execution<String> execution = new Execution<String>(){

            @Override
            public String execute() {
                return BaseFluentWebDriver.this.delegate.getTitle();
            }
        };
        Context ctx = Context.singular(this.context, "title");
        return new TestableString(execution, ctx).within(this.getPeriod());
    }

    protected abstract FluentWebElements makeFluentWebElements(List<FluentWebElement> var1, Context var2);

    protected final By fixupBy(By by, String tagName) {
        if (by.getClass().getName().equals("org.openqa.selenium.By$ByXPath")) {
            by = By.xpath((String)(".//" + tagName + "[" + by.toString().substring(by.toString().indexOf(":") + 1).trim() + "]"));
        }
        if (by.getClass().getName().equals("org.openqa.selenium.By$ByClassName")) {
            by = FluentBy.composite(By.tagName((String)tagName), by);
        }
        return by;
    }

    protected final void assertTagIs(String is, String shouldBe) {
        if (!is.equals(shouldBe)) {
            throw new AssertionError((Object)("tag was incorrect, should have been " + shouldBe + " but was " + is));
        }
    }

    protected abstract WebElement findIt(By var1);

    protected abstract List<WebElement> findThem(By var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleResult single(By by, String tagName) {
        WebElement result;
        By by2 = this.fixupBy(by, tagName);
        Context ctx = this.contextualize(by, tagName);
        try {
            this.changeTimeout();
            FindIt execution = new FindIt(by2, tagName);
            result = this.decorateExecution(execution, ctx);
        }
        finally {
            this.resetTimeout();
        }
        return new SingleResult(result, ctx);
    }

    private Context contextualize(By by, String tagName) {
        if (by.toString().equals("By.tagName: " + tagName)) {
            by = null;
        }
        return Context.singular(this.context, tagName, by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultipleResult multiple(By by, String tagName) {
        List<WebElement> result;
        By by2 = this.fixupBy(by, tagName);
        Context ctx = Context.plural(this.context, tagName, by);
        try {
            this.changeTimeout();
            FindThem execution = new FindThem(by2, tagName);
            result = this.decorateExecution(execution, ctx);
        }
        finally {
            this.resetTimeout();
        }
        return new MultipleResult(result, ctx);
    }

    protected static RuntimeException decorateRuntimeException(Context ctx, RuntimeException e) {
        FluentExecutionStopped rv = null;
        rv = e instanceof StaleElementReferenceException ? new FluentExecutionStopped.BecauseOfStaleElement(BaseFluentWebDriver.replacePkgNames(e) + ctx, e) : (e instanceof NothingMatches ? new FluentExecutionStopped.BecauseNothingMatchesInFilter(BaseFluentWebDriver.replacePkgNames(e) + ctx) : new FluentExecutionStopped(BaseFluentWebDriver.replacePkgNames(e) + ctx, e));
        return rv;
    }

    private static String replacePkgNames(Throwable e) {
        return e.getClass().getName().replace("java.lang.", "").replace("org.openqa.selenium.", "") + " during invocation of: ";
    }

    protected static RuntimeException decorateAssertionError(Context ctx, AssertionError e) {
        FluentExecutionStopped rv = new FluentExecutionStopped(BaseFluentWebDriver.replacePkgNames((Throwable)((Object)e)) + ctx, (Throwable)((Object)e));
        return rv;
    }

    protected <T> T decorateExecution(Execution<T> execution, Context ctx) {
        long start = System.currentTimeMillis();
        try {
            return execution.execute();
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    protected void changeTimeout() {
    }

    protected void resetTimeout() {
    }

    protected final WebElement retryingFindIt(By by) {
        long endMillis = this.getPeriod().getEndMillis(System.currentTimeMillis());
        Throwable exceptionCausingRetry = new RuntimeException();
        WebElement it = null;
        while (exceptionCausingRetry != null && endMillis - System.currentTimeMillis() > 0L) {
            try {
                it = this.actualFindIt(by);
                exceptionCausingRetry = null;
                return it;
            }
            catch (WebDriverException e) {
                exceptionCausingRetry = e;
            }
        }
        if (exceptionCausingRetry != null) {
            throw exceptionCausingRetry;
        }
        return it;
    }

    protected final List<WebElement> retryingFindThem(By by) {
        long endMillis = this.getPeriod().getEndMillis(System.currentTimeMillis());
        Throwable exceptionCausingRetry = AN_EXCEPTION;
        List<WebElement> them = null;
        while (exceptionCausingRetry != null && endMillis - System.currentTimeMillis() > 0L) {
            try {
                them = this.actualFindThem(by);
                exceptionCausingRetry = null;
                return them;
            }
            catch (WebDriverException e) {
                exceptionCausingRetry = e;
            }
        }
        if (exceptionCausingRetry != null) {
            throw exceptionCausingRetry;
        }
        return them;
    }

    protected abstract WebElement actualFindIt(By var1);

    protected abstract List<WebElement> actualFindThem(By var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindThem
    implements Execution<List<WebElement>> {
        private final By by2;
        private final String tagName;

        public FindThem(By by2, String tagName) {
            this.by2 = by2;
            this.tagName = tagName;
        }

        @Override
        public List<WebElement> execute() {
            List<WebElement> results = BaseFluentWebDriver.this.findThem(this.by2);
            for (WebElement webElement : results) {
                BaseFluentWebDriver.this.assertTagIs(webElement.getTagName(), this.tagName);
            }
            return results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultipleResult {
        private final List<WebElement> result;
        private final Context ctx;

        public MultipleResult(List<WebElement> result, Context ctx) {
            this.result = result;
            this.ctx = ctx;
        }

        public List<WebElement> getResult() {
            return this.result;
        }

        public Context getCtx() {
            return this.ctx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindIt
    implements Execution<WebElement> {
        private final By by2;
        private final String tagName;

        public FindIt(By by2, String tagName) {
            this.by2 = by2;
            this.tagName = tagName;
        }

        @Override
        public WebElement execute() {
            WebElement it = BaseFluentWebDriver.this.findIt(this.by2);
            BaseFluentWebDriver.this.assertTagIs(it.getTagName(), this.tagName);
            return it;
        }
    }

    public static class SingleResult {
        private final WebElement result;
        private final Context ctx;

        public SingleResult(WebElement result, Context ctx) {
            this.result = result;
            this.ctx = ctx;
        }

        public WebElement getResult() {
            return this.result;
        }

        public Context getCtx() {
            return this.ctx;
        }
    }

    public static class ContextElem {
        private final String tagName;
        private final By by;
        private final Object arg;

        public ContextElem(String tagName, By by, Object arg) {
            this.tagName = tagName;
            this.by = by;
            this.arg = arg;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(".").append(this.tagName);
            if (this.by == null && this.arg == null) {
                return sb.append("()").toString();
            }
            if (this.by != null) {
                return sb.append("(").append(this.by).append(")").toString();
            }
            String quote = "'";
            if (this.arg instanceof Number || this.arg instanceof Period || this.arg instanceof FluentMatcher) {
                quote = "";
            }
            return sb.append("(").append(quote).append(this.arg).append(quote).append(")").toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Context
    implements Iterable<ContextElem> {
        private List<ContextElem> elems = new ArrayList<ContextElem>();

        @Override
        public Iterator<ContextElem> iterator() {
            return Collections.unmodifiableList(this.elems).iterator();
        }

        public static Context singular(Context previous, String tagName, By by) {
            return Context.make(previous, tagName, by, null);
        }

        private static Context make(Context previous, String tagName, By by, Object arg) {
            Context ctx = new Context();
            if (previous != null) {
                ctx.elems.addAll(previous.elems);
            }
            ctx.elems.add(new ContextElem(tagName, by, arg));
            return ctx;
        }

        public static Context plural(Context previous, String tagName, By by) {
            return Context.make(previous, tagName + "s", by, null);
        }

        public static Context singular(Context previous, String tagName) {
            return Context.make(previous, tagName, null, null);
        }

        public static Context singular(Context context, String tagName, Object arg) {
            return Context.make(context, tagName, null, arg);
        }

        public static Context singular(Context previous, String tagName, By by, Object arg) {
            return Context.make(previous, tagName, by, arg);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("?");
            for (ContextElem elem : this.elems) {
                sb.append(elem.toString());
            }
            return sb.toString();
        }
    }
}

