/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByXPath;

public abstract class FluentBy {
    public static By strictClassName(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        if (className.matches(".*\\s+.*")) {
            throw new InvalidSelectorException("Compound class names are not supported. Consider searching for one class name and filtering the results.");
        }
        return new ByStrictClassName(className);
    }

    public static By attribute(String name) {
        return FluentBy.attribute(name, null);
    }

    public static By attribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find elements when the attribute name is null");
        }
        return new ByAttribute(name, value);
    }

    public static ByComposite composite(By ... bys) {
        if (bys == null) {
            throw new IllegalArgumentException("Cannot make composite with no varargs of Bys");
        }
        if (!(bys.length == 2 && (bys[0] instanceof By.ByTagName || bys[1] instanceof By.ByClassName && bys[1] instanceof ByAttribute))) {
            throw new IllegalArgumentException("can only do this with By.tagName followed one of By.className or FluentBy.attribute");
        }
        return new ByComposite(bys);
    }

    public static ByLast last(By by) {
        if (by instanceof ByAttribute) {
            return new ByLast((ByAttribute)by);
        }
        throw new UnsupportedOperationException("last() not allowed for " + by.getClass().getName() + " type");
    }

    public static ByLast last() {
        return new ByLast();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByAttribute
    extends By {
        private final String name;
        private final String value;

        public ByAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public WebElement findElement(SearchContext context) {
            return this.makeByXPath().findElement(context);
        }

        By makeByXPath() {
            return By.xpath((String)this.makeXPath());
        }

        String makeXPath() {
            return ".//*[" + this.nameAndValue() + "]";
        }

        private String nameAndValue() {
            return "@" + this.name + this.val();
        }

        private String val() {
            return this.value == null ? "" : " = '" + this.value + "'";
        }

        public List<WebElement> findElements(SearchContext context) {
            return this.makeByXPath().findElements(context);
        }

        public String toString() {
            return "FluentBy.attribute: " + this.name + this.val();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByStrictClassName
    extends By {
        private final String className;

        public ByStrictClassName(String className) {
            this.className = className;
        }

        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)context).findElementsByClassName(this.className);
            }
            return ((FindsByXPath)context).findElementsByXPath(".//*[@class = '" + this.className + "']");
        }

        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)context).findElementByClassName(this.className);
            }
            return ((FindsByXPath)context).findElementByXPath(".//*[@class = '" + this.className + "']");
        }

        public String toString() {
            return "FluentBy.strictClassName: " + this.className;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByComposite
    extends By {
        private final By[] bys;

        public ByComposite(By ... bys) {
            this.bys = bys;
        }

        public List<WebElement> findElements(SearchContext context) {
            return this.makeByXPath().findElements(context);
        }

        private String containingWord(String attribute, String word) {
            return "contains(concat(' ',normalize-space(@" + attribute + "),' '),' " + word + " ')";
        }

        By makeByXPath() {
            String xpathExpression = this.makeXPath();
            return By.xpath((String)xpathExpression);
        }

        String makeXPath() {
            String xpathExpression = ".//" + this.getTagName();
            if (this.bys[1] instanceof By.ByClassName) {
                String className = this.bys[1].toString().substring("By.className: ".length());
                xpathExpression = xpathExpression + "[" + this.containingWord("class", className) + "]";
            } else if (this.bys[1] instanceof ByAttribute) {
                ByAttribute by = (ByAttribute)this.bys[1];
                xpathExpression = xpathExpression + "[" + by.nameAndValue() + "]";
            }
            return xpathExpression;
        }

        private String getTagName() {
            return this.bys[0].toString().substring("By.tagName: ".length());
        }

        public WebElement findElement(SearchContext context) {
            return this.makeByXPath().findElement(context);
        }

        public String toString() {
            return "FluentBy.composite(" + Arrays.asList(this.bys) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByLast
    extends By {
        private final String orig;
        private final ByAttribute by;

        public ByLast(ByAttribute by) {
            this.by = by;
            this.orig = by.makeXPath();
        }

        public ByLast() {
            this.orig = ".//*[]";
            this.by = null;
        }

        public List<WebElement> findElements(SearchContext context) {
            return this.makeXPath().findElements(context);
        }

        By makeXPath() {
            return By.xpath((String)(this.orig.substring(0, this.orig.length() - 1) + " and position() = last()]").replace("[ and ", "["));
        }

        public WebElement findElement(SearchContext context) {
            return this.makeXPath().findElement(context);
        }

        public String toString() {
            return "FluentBy.last(" + (this.by == null ? "" : this.by) + ")";
        }
    }
}

