/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.seleniumhq.selenium.fluent.FluentRecording;
import org.seleniumhq.selenium.fluent.FluentSelect;
import org.seleniumhq.selenium.fluent.FluentSelects;
import org.seleniumhq.selenium.fluent.FluentWebDriverImpl;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.FluentWebElements;
import org.seleniumhq.selenium.fluent.RetryingFluentWebDriverExecutor;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.WebElementValue;
import org.seleniumhq.selenium.fluent.recording.NoRetryStrategy;
import org.seleniumhq.selenium.fluent.recording.OnFluentSomething;
import org.seleniumhq.selenium.fluent.recording.RecordingFluentSelect;
import org.seleniumhq.selenium.fluent.recording.RecordingFluentSelects;
import org.seleniumhq.selenium.fluent.recording.RecordingFluentTestableString;
import org.seleniumhq.selenium.fluent.recording.RecordingFluentWebDriver;
import org.seleniumhq.selenium.fluent.recording.RecordingFluentWebElement;
import org.seleniumhq.selenium.fluent.recording.RecordingFluentWebElementValue;
import org.seleniumhq.selenium.fluent.recording.RecordingFluentWebElements;
import org.seleniumhq.selenium.fluent.recording.RetryStrategy;

public class FluentRecorder {
    private RetryStrategy[] retryStrategies;
    private List<OnFluentSomething> list = new ArrayList<OnFluentSomething>();

    public FluentRecorder() {
        this.retryStrategies = new RetryStrategy[]{new NoRetryStrategy()};
    }

    public FluentRecorder(RetryStrategy ... retryStrategies) {
        this.retryStrategies = retryStrategies;
    }

    public FluentWebElement fluentWebElement(OnFluentSomething recording) {
        this.list.add(recording);
        return new RecordingFluentWebElement(this);
    }

    public FluentWebElements fluentWebElements(OnFluentSomething recording) {
        this.list.add(recording);
        return new RecordingFluentWebElements(this);
    }

    public FluentSelect fluentSelect(OnFluentSomething recording) {
        this.list.add(recording);
        return new RecordingFluentSelect(this);
    }

    public FluentSelects fluentSelects(OnFluentSomething recording) {
        this.list.add(recording);
        return new RecordingFluentSelects(this);
    }

    public FluentWebDriverImpl fluentWebDriverImpl(OnFluentSomething recording) {
        this.list.add(recording);
        return new RecordingFluentWebDriver(this);
    }

    public TestableString testableString(OnFluentSomething recording) {
        this.list.add(recording);
        return new RecordingFluentTestableString(this);
    }

    public Point point(OnFluentSomething recording) {
        this.list.add(recording);
        return new Point(0, 0);
    }

    public Dimension dimension(OnFluentSomething recording) {
        this.list.add(recording);
        return new Dimension(-1, -1);
    }

    public WebElementValue webElementValue(OnFluentSomething recording) {
        this.list.add(recording);
        return new RecordingFluentWebElementValue(this);
    }

    public boolean returnsBoolean(OnFluentSomething recording) {
        this.list.add(recording);
        return false;
    }

    public void returnsNothing(OnFluentSomething recording) {
        this.list.add(recording);
    }

    public FluentRecording recording() {
        return this.recording(50);
    }

    public FluentRecording recording(int millisToSleepBetweenRetries) {
        RetryingFluentWebDriverExecutor fwde = new RetryingFluentWebDriverExecutor(millisToSleepBetweenRetries, this.retryStrategies);
        return new FluentRecording(Collections.unmodifiableList(this.list), fwde);
    }
}

