/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.seleniumhq.selenium.fluent.BaseFluentWebDriver;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentSelect
extends FluentWebElement {
    private Select currentSelect;

    public FluentSelect(WebDriver delegate, WebElement currentElement, BaseFluentWebDriver.Context context) {
        super(delegate, currentElement, context);
    }

    private FluentSelect(WebDriver delegate, Select currentSelect, WebElement currentElement, BaseFluentWebDriver.Context context) {
        super(delegate, currentElement, context);
        this.currentSelect = currentSelect;
    }

    public boolean isMultiple() {
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                return FluentSelect.this.getSelect().isMultiple();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "isMultiple"));
    }

    public List<WebElement> getOptions() {
        return this.decorateExecution(new Execution<List<WebElement>>(){

            @Override
            public List<WebElement> execute() {
                return FluentSelect.this.getSelect().getOptions();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getOptions"));
    }

    public List<WebElement> getAllSelectedOptions() {
        return this.decorateExecution(new Execution<List<WebElement>>(){

            @Override
            public List<WebElement> execute() {
                return FluentSelect.this.getSelect().getAllSelectedOptions();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getAllSelectedOptions"));
    }

    public WebElement getFirstSelectedOption() {
        return this.decorateExecution(new Execution<WebElement>(){

            @Override
            public WebElement execute() {
                return FluentSelect.this.getSelect().getFirstSelectedOption();
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "getFirstSelectedOption"));
    }

    public FluentSelect selectByVisibleText(final String text) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().selectByVisibleText(text);
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "selectByVisibleText", null, text));
        return new FluentSelect(this.delegate, this.currentElement, this.context);
    }

    public FluentSelect selectByIndex(final int index) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().selectByIndex(index);
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "selectByIndex", null, index));
        return new FluentSelect(this.delegate, this.currentElement, this.context);
    }

    public FluentSelect selectByValue(final String value) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().selectByValue(value);
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "selectByValue", null, value));
        return new FluentSelect(this.delegate, this.currentElement, this.context);
    }

    public FluentSelect deselectAll() {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().deselectAll();
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "deselectAll"));
        return new FluentSelect(this.delegate, this.currentElement, this.context);
    }

    public FluentSelect deselectByValue(final String value) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().deselectByValue(value);
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "deselectByValue", null, value));
        return new FluentSelect(this.delegate, this.currentElement, this.context);
    }

    public FluentSelect deselectByIndex(final int index) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().deselectByIndex(index);
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "deselectByIndex", null, index));
        return new FluentSelect(this.delegate, this.currentElement, this.context);
    }

    public FluentSelect deselectByVisibleText(final String text) {
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                FluentSelect.this.getSelect().deselectByVisibleText(text);
                return true;
            }
        }, BaseFluentWebDriver.Context.singular(this.context, "deselectByVisibleText", null, text));
        return new FluentSelect(this.delegate, this.currentElement, this.context);
    }

    protected synchronized Select getSelect() {
        if (this.currentSelect == null) {
            this.currentSelect = new Select(this.currentElement);
        }
        return this.currentSelect;
    }

    @Override
    public FluentSelect within(Period period) {
        return new MorePatientFluentSelect(this.delegate, BaseFluentWebDriver.Context.singular(this.context, "within", null, period), this.currentSelect, this.currentElement, period);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MorePatientFluentSelect
    extends FluentSelect {
        private final Period period;

        public MorePatientFluentSelect(WebDriver webDriver, BaseFluentWebDriver.Context context, Select currentSelect, WebElement currentElement, Period period) {
            super(webDriver, currentSelect, currentElement, context);
            this.period = period;
        }

        @Override
        protected WebElement findIt(By by) {
            return this.retryingFindIt(by);
        }

        @Override
        protected List<WebElement> findThem(By by) {
            return this.retryingFindThem(by);
        }

        @Override
        protected Period getPeriod() {
            return this.period;
        }

        @Override
        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
        }

        @Override
        protected void resetTimeout() {
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

