/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.BaseFluentWebDriver;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.FluentWebElements;
import org.seleniumhq.selenium.fluent.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebDriverImpl
extends BaseFluentWebDriver {
    public FluentWebDriverImpl(WebDriver delegate) {
        super(delegate, null);
    }

    protected FluentWebDriverImpl(WebDriver delegate, BaseFluentWebDriver.Context context) {
        super(delegate, context);
    }

    @Override
    protected FluentWebElements makeFluentWebElements(List<FluentWebElement> results, BaseFluentWebDriver.Context context) {
        return new FluentWebElements(this.delegate, results, context);
    }

    @Override
    protected WebElement findIt(By by) {
        return this.actualFindIt(by);
    }

    @Override
    protected List<WebElement> findThem(By by) {
        return this.actualFindThem(by);
    }

    @Override
    protected final WebElement actualFindIt(By by) {
        return this.delegate.findElement(by);
    }

    @Override
    protected final List<WebElement> actualFindThem(By by) {
        return this.delegate.findElements(by);
    }

    @Override
    public FluentWebDriverImpl within(Period period) {
        return new RetryingFluentWebDriver(this.delegate, period, BaseFluentWebDriver.Context.singular(this.context, "within", null, period));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RetryingFluentWebDriver
    extends FluentWebDriverImpl {
        private final Period period;

        public RetryingFluentWebDriver(WebDriver webDriver, Period period, BaseFluentWebDriver.Context context) {
            super(webDriver, context);
            this.period = period;
        }

        @Override
        protected WebElement findIt(By by) {
            return this.retryingFindIt(by);
        }

        @Override
        protected List<WebElement> findThem(By by) {
            return this.retryingFindThem(by);
        }

        @Override
        protected Period getPeriod() {
            return this.period;
        }

        @Override
        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
        }

        @Override
        protected void resetTimeout() {
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

