/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.BaseFluentWebDriver;
import org.seleniumhq.selenium.fluent.BaseFluentWebElement;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.FluentMatcher;
import org.seleniumhq.selenium.fluent.FluentSelect;
import org.seleniumhq.selenium.fluent.FluentSelects;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.NothingMatches;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElements
extends BaseFluentWebElement
implements List<FluentWebElement> {
    private final List<FluentWebElement> currentElements;

    public FluentWebElements(WebDriver delegate, List<FluentWebElement> currentElements, BaseFluentWebDriver.Context context) {
        super(delegate, context);
        this.currentElements = currentElements;
    }

    public FluentWebElements click() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "click");
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                for (FluentWebElement webElement : FluentWebElements.this) {
                    webElement.click();
                }
                return true;
            }
        }, ctx);
        return this.makeFluentWebElements(this, ctx);
    }

    public FluentWebElements clearField() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "clearField");
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                for (FluentWebElement webElement : FluentWebElements.this) {
                    webElement.getWebElement().clear();
                }
                return true;
            }
        }, ctx);
        return this.makeFluentWebElements(this, ctx);
    }

    public FluentWebElements submit() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "submit");
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                for (FluentWebElement webElement : FluentWebElements.this) {
                    webElement.submit();
                }
                return true;
            }
        }, ctx);
        return this.makeFluentWebElements(this, ctx);
    }

    public FluentWebElements sendKeys(final CharSequence ... keysToSend) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "sendKeys", this.charSeqArrayAsHumanString(keysToSend));
        this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                for (FluentWebElement webElement : FluentWebElements.this) {
                    webElement.sendKeys(keysToSend);
                }
                return true;
            }
        }, ctx);
        return this.makeFluentWebElements(this, ctx);
    }

    @Override
    public boolean isSelected() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "isSelected");
        boolean areSelected = this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                boolean areSelected = true;
                for (FluentWebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isSelected();
                }
                return areSelected;
            }
        }, ctx);
        return areSelected;
    }

    @Override
    public boolean isEnabled() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "isEnabled");
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                boolean areSelected = true;
                for (FluentWebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isEnabled();
                }
                return areSelected;
            }
        }, ctx);
    }

    @Override
    public boolean isDisplayed() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "isDisplayed");
        return this.decorateExecution(new Execution<Boolean>(){

            @Override
            public Boolean execute() {
                boolean areSelected = true;
                for (FluentWebElement webElement : FluentWebElements.this) {
                    areSelected &= webElement.isDisplayed();
                }
                return areSelected;
            }
        }, ctx);
    }

    @Override
    public TestableString getText() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "getText");
        Execution<String> execution = new Execution<String>(){

            @Override
            public String execute() {
                String text = "";
                for (FluentWebElement webElement : FluentWebElements.this) {
                    text = text + webElement.getText();
                }
                return text;
            }
        };
        return new TestableString(execution, ctx).within(this.getPeriod());
    }

    @Override
    protected final WebElement findIt(By by) {
        throw this.meaningless("findIt('" + by + "')");
    }

    @Override
    protected final List<WebElement> findThem(By by) {
        throw this.meaningless("findThem('" + by + "')");
    }

    @Override
    protected final WebElement actualFindIt(By by) {
        throw this.meaningless("findIt('" + by + "')");
    }

    @Override
    protected final List<WebElement> actualFindThem(By by) {
        throw this.meaningless("findThem('" + by + "')");
    }

    @Override
    public final Point getLocation() {
        throw this.meaningless("getLocation()");
    }

    private UnsupportedOperationException meaningless(String invocation) {
        return new UnsupportedOperationException(invocation + " has no meaning for multiple elements");
    }

    @Override
    public final TestableString getCssValue(String cssName) {
        throw this.meaningless("getCssValue('" + cssName + "')");
    }

    @Override
    public final TestableString getAttribute(String attrName) {
        throw this.meaningless("getAttribute('" + attrName + "')");
    }

    @Override
    public final TestableString getTagName() {
        throw this.meaningless("getTagName()");
    }

    @Override
    public final Dimension getSize() {
        throw this.meaningless("getSize()");
    }

    @Override
    public FluentWebElements within(Period p) {
        throw this.meaningless("within(" + p + ")");
    }

    public FluentWebElements filter(final FluentMatcher matcher) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "filter", null, matcher);
        List<FluentWebElement> subset = this.decorateExecution(new Execution<List<FluentWebElement>>(){

            @Override
            public List<FluentWebElement> execute() {
                ArrayList<FluentWebElement> results = new ArrayList<FluentWebElement>();
                for (FluentWebElement webElement : FluentWebElements.this) {
                    if (!matcher.matches(webElement.getWebElement())) continue;
                    results.add(webElement);
                }
                if (results.size() == 0) {
                    throw new NothingMatches();
                }
                return results;
            }
        }, ctx);
        return this.makeFluentWebElements(subset, ctx);
    }

    public FluentWebElement first(final FluentMatcher matcher) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "first", null, matcher);
        FluentWebElement first = this.decorateExecution(new Execution<FluentWebElement>(){

            @Override
            public FluentWebElement execute() {
                FluentWebElement result = null;
                for (FluentWebElement webElement : FluentWebElements.this) {
                    if (!matcher.matches(webElement.getWebElement())) continue;
                    result = webElement;
                    break;
                }
                if (result == null) {
                    throw new NothingMatches();
                }
                return result;
            }
        }, ctx);
        return first;
    }

    @Override
    public void clear() {
        this.currentElements.clear();
    }

    @Override
    public int size() {
        return this.currentElements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentElements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.currentElements.contains(o);
    }

    @Override
    public Iterator<FluentWebElement> iterator() {
        return this.currentElements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.currentElements.toArray();
    }

    @Override
    public <FluentWebElement> FluentWebElement[] toArray(FluentWebElement[] ts) {
        return this.currentElements.toArray(ts);
    }

    @Override
    public boolean add(FluentWebElement webElement) {
        return this.currentElements.add(webElement);
    }

    @Override
    public boolean remove(Object o) {
        return this.currentElements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.currentElements.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends FluentWebElement> webElements) {
        return this.currentElements.addAll(webElements);
    }

    @Override
    public boolean addAll(int i, Collection<? extends FluentWebElement> webElements) {
        return this.currentElements.addAll(webElements);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.currentElements.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.currentElements.retainAll(objects);
    }

    @Override
    public FluentWebElement get(int i) {
        return this.currentElements.get(i);
    }

    @Override
    public FluentWebElement set(int i, FluentWebElement webElement) {
        return this.currentElements.set(i, webElement);
    }

    @Override
    public void add(int i, FluentWebElement webElement) {
        this.currentElements.add(i, webElement);
    }

    @Override
    public FluentWebElement remove(int i) {
        return this.currentElements.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.currentElements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.currentElements.lastIndexOf(o);
    }

    @Override
    public ListIterator<FluentWebElement> listIterator() {
        return this.currentElements.listIterator();
    }

    @Override
    public ListIterator<FluentWebElement> listIterator(int i) {
        return this.currentElements.listIterator(i);
    }

    @Override
    public List<FluentWebElement> subList(int i, int i1) {
        return this.currentElements.subList(i, i1);
    }

    private UnsupportedOperationException notSupported() {
        return new UnsupportedOperationException("not supported for FluentWebElements");
    }

    @Override
    public final TestableString title() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement span() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement span(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements spans() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements spans(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement div() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement div(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements divs() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements divs(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement button() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement button(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements buttons() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements buttons(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement link() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement link(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements links() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements links(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement input() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement input(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements inputs() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements inputs(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentSelect select() {
        throw this.notSupported();
    }

    @Override
    public final FluentSelect select(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentSelects selects() {
        throw this.notSupported();
    }

    @Override
    public final FluentSelects selects(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement h1() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement h1(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements h1s() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements h1s(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement h2() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement h2(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements h2s() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements h2s(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement h3() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements h3s() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement h3(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements h3s(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement h4() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements h4s() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement h4(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements h4s(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement p() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements ps() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement p(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements ps(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement img() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements imgs() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement img(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements imgs(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement table() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements tables() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement table(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements tables(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement fieldset() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements fieldsets() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement fieldset(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements fieldsets(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement legend() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements legends() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement legend(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements legends(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement tr() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements trs() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement tr(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements trs(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement td() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements tds() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement td(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements tds(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement th() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements ths() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement th(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements ths(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement ul() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements uls() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement ul(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements uls(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement ol() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements ols() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement ol(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements ols(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement form() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements forms() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement form(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements forms(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement textarea() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements textareas() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement textarea(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements textareas(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement option() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements options() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement option(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements options(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement li() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement li(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements lis() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements lis(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement map() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements maps() {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElement map(By by) {
        throw this.notSupported();
    }

    @Override
    public final FluentWebElements maps(By by) {
        throw this.notSupported();
    }

    @Override
    public final TestableString url() {
        throw this.notSupported();
    }
}

