/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.hamcrest.core.IsEqual;
import org.hamcrest.internal.SelfDescribingValueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matchable<T> {
    private T val;
    private final T shouldOrShouldNotBe;
    private final String context;
    private final boolean shouldOrShouldNot;

    public Matchable(T val, T shouldOrShouldNotBe, String context, boolean shouldOrShouldNot) {
        this.val = val;
        this.shouldOrShouldNotBe = shouldOrShouldNotBe;
        this.context = context;
        this.shouldOrShouldNot = shouldOrShouldNot;
    }

    public Matchable<T> match() {
        Matcher matcher = IsEqual.equalTo(this.shouldOrShouldNotBe);
        boolean passed = matcher.matches(this.val);
        StringDescription desc = new StringDescription();
        matcher.describeTo((Description)desc);
        if (this.shouldOrShouldNot & !passed || !this.shouldOrShouldNot & passed) {
            String s = this.context + " ~ but " + this.was(matcher, desc);
            throw new RuntimeException(s);
        }
        return this;
    }

    private String was(Matcher<T> matcher, StringDescription desc) {
        if (matcher instanceof IsEqual && !this.shouldOrShouldNot) {
            return "was.";
        }
        return "was " + this.appendValue(this.val);
    }

    public String appendValue(Object value) {
        String retVal = "";
        if (value == null) {
            retVal = retVal + this.append("null");
        } else if (value instanceof String) {
            retVal = retVal + this.toJavaSyntax((String)value);
        } else if (value instanceof Character) {
            retVal = retVal + this.append('\"');
            retVal = retVal + this.toJavaSyntax(((Character)value).charValue());
            retVal = retVal + this.append('\"');
        } else if (value instanceof Short) {
            retVal = retVal + this.append('<');
            retVal = retVal + this.append(String.valueOf(value));
            retVal = retVal + this.append("s>");
        } else if (value instanceof Long) {
            retVal = retVal + this.append('<');
            retVal = retVal + this.append(String.valueOf(value));
            retVal = retVal + this.append("L>");
        } else if (value instanceof Float) {
            retVal = retVal + this.append('<');
            retVal = retVal + this.append(String.valueOf(value));
            retVal = retVal + this.append("F>");
        } else if (value.getClass().isArray()) {
            retVal = retVal + this.appendValueList("[", ", ", "]", (Object[])value);
        } else {
            retVal = retVal + this.append('<');
            retVal = retVal + this.append(String.valueOf(value));
            retVal = retVal + this.append('>');
        }
        return retVal;
    }

    public String appendValueList(String start, String separator, String end, T ... values) {
        return this.appendValueList(start, separator, end, (Iterable<T>)Arrays.asList(values));
    }

    public String appendValueList(String start, String separator, String end, Iterable<T> values) {
        return this.appendValueList(start, separator, end, values.iterator());
    }

    private String appendValueList(String start, String separator, String end, Iterator<T> values) {
        return this.appendList(start, separator, end, (Iterator<SelfDescribing>)new SelfDescribingValueIterator(values));
    }

    private String appendList(String start, String separator, String end, Iterator<? extends SelfDescribing> i) {
        String retVal = "";
        boolean separate = false;
        retVal = retVal + this.append(start);
        while (i.hasNext()) {
            if (separate) {
                this.append(separator);
            }
            retVal = retVal + this.appendDescriptionOf(i.next());
            separate = true;
        }
        retVal = retVal + this.append(end);
        return retVal;
    }

    public String appendDescriptionOf(SelfDescribing value) {
        return value.toString();
    }

    protected String append(char chr) {
        return "" + chr;
    }

    protected String append(String str) {
        String retVal = "";
        for (int i = 0; i < str.length(); ++i) {
            retVal = retVal + this.append(str.charAt(i));
        }
        return retVal;
    }

    private String toJavaSyntax(String unformatted) {
        String retVal = "";
        retVal = retVal + this.append('\"');
        for (int i = 0; i < unformatted.length(); ++i) {
            retVal = retVal + this.toJavaSyntax(unformatted.charAt(i));
        }
        retVal = retVal + this.append('\"');
        return retVal;
    }

    private String toJavaSyntax(char ch) {
        switch (ch) {
            case '\"': {
                return this.append("\\\"");
            }
            case '\n': {
                return this.append("\\n");
            }
            case '\r': {
                return this.append("\\r");
            }
            case '\t': {
                return this.append("\\t");
            }
        }
        return this.append(ch);
    }

    public T value() {
        return this.val;
    }
}

