/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentWebDriver;
import org.seleniumhq.selenium.fluent.FluentWebDriverExecutor;
import org.seleniumhq.selenium.fluent.recording.RetryStrategy;

public class RetryingFluentWebDriverExecutor
implements FluentWebDriverExecutor {
    private final int millisToSleep;
    private final RetryStrategy[] retryStrategies;

    public RetryingFluentWebDriverExecutor(int millisToSleep, RetryStrategy ... retryStrategies) {
        this.millisToSleep = millisToSleep;
        this.retryStrategies = retryStrategies;
    }

    public Object playback(FluentWebDriver driver, FluentWebDriverExecutor.FluentWebDriverExecution execution) {
        long start = System.currentTimeMillis();
        int retries = 0;
        RuntimeException lastRE = null;
        AssertionError lastAE = null;
        boolean goAgain = true;
        while (goAgain) {
            lastAE = null;
            lastRE = null;
            goAgain = false;
            try {
                return execution.execute(driver);
            }
            catch (FluentExecutionStopped e) {
                lastRE = e;
                goAgain = this.retry(e, start, retries);
            }
            catch (RuntimeException e) {
                lastRE = e;
                goAgain = this.retry(e, start, retries);
            }
            catch (AssertionError e) {
                lastAE = e;
                goAgain = this.retry((Throwable)((Object)e), start, retries);
            }
            if (!goAgain) continue;
            try {
                Thread.sleep(this.millisToSleep);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++retries;
        }
        if (lastRE != null) {
            if (lastRE instanceof FluentExecutionStopped && retries > 0) {
                ((FluentExecutionStopped)lastRE).setRetries(retries).setDuration(System.currentTimeMillis() - start);
            }
            throw lastRE;
        }
        throw lastAE;
    }

    private boolean retry(Throwable e, long start, int retries) {
        boolean shouldRetry = this.retryStrategies.length > 0;
        for (RetryStrategy retryStrategy : this.retryStrategies) {
            shouldRetry &= retryStrategy.shouldRetry(e, start, retries);
        }
        return shouldRetry;
    }
}

