/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.seleniumhq.selenium.fluent.BaseFluentWebDriver;
import org.seleniumhq.selenium.fluent.Execution;
import org.seleniumhq.selenium.fluent.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestableString {
    private String is;
    private final Period within;
    private final Execution<String> execution;
    private final BaseFluentWebDriver.Context context;

    public TestableString(Execution<String> execution, BaseFluentWebDriver.Context ctx) {
        this(null, execution, ctx);
    }

    private TestableString(Period within, Execution<String> execution, BaseFluentWebDriver.Context ctx) {
        this.within = within;
        this.execution = execution;
        this.context = ctx;
    }

    public void shouldBe(String shouldBe) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldBe", null, shouldBe);
        long start = System.currentTimeMillis();
        try {
            if (!shouldBe.equals(this.is)) {
                if (this.within != null) {
                    boolean passed;
                    long endMillis = this.calcEndMillis();
                    do {
                        this.is = this.execution.execute();
                        boolean bl = passed = this.is != null && this.is.equals(shouldBe);
                    } while (System.currentTimeMillis() < endMillis && !passed);
                } else {
                    this.assignValueIfNeeded();
                }
            }
            MatcherAssert.assertThat((String)this.durationIfNotZero(start), (Object)this.is, (Matcher)CoreMatchers.equalTo((Object)shouldBe));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    public TestableString within(Period period) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "within", null, period);
        return new TestableString(period, this.execution, ctx);
    }

    private void assignValueIfNeeded() {
        if (this.is != null) {
            return;
        }
        this.is = this.execution.execute();
    }

    public void shouldNotBe(String shouldNotBe) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldNotBe", null, shouldNotBe);
        long start = System.currentTimeMillis();
        try {
            this.assignValueIfNeeded();
            if (shouldNotBe.equals(this.is) && this.within != null) {
                boolean passed;
                long endMillis = this.calcEndMillis();
                do {
                    this.is = this.execution.execute();
                    boolean bl = passed = this.is != null && !this.is.equals(shouldNotBe);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)this.durationIfNotZero(start), (Object)this.is, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)shouldNotBe)));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    public void shouldContain(String shouldContain) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldContain", null, shouldContain);
        long start = System.currentTimeMillis();
        try {
            this.assignValueIfNeeded();
            if (this.is.indexOf(shouldContain) == -1 && this.within != null) {
                boolean passed;
                long endMillis = this.calcEndMillis();
                do {
                    this.is = this.execution.execute();
                    boolean bl = passed = this.is != null && this.is.indexOf(shouldContain) > -1;
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)this.durationIfNotZero(start), (Object)this.is, (Matcher)Matchers.containsString((String)shouldContain));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    private String durationIfNotZero(long start) {
        long duration = System.currentTimeMillis() - start;
        if (duration > 0L) {
            return "(after " + duration + " ms)";
        }
        return "";
    }

    private long calcEndMillis() {
        return this.within.getEndMillis(System.currentTimeMillis());
    }

    public void shouldNotContain(String shouldNotContain) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldNotContain", null, shouldNotContain);
        long start = System.currentTimeMillis();
        try {
            this.assignValueIfNeeded();
            if (this.is.indexOf(shouldNotContain) > -1 && this.within != null) {
                boolean passed;
                long endMillis = this.calcEndMillis();
                do {
                    this.is = this.execution.execute();
                    boolean bl = passed = this.is != null && this.is.indexOf(shouldNotContain) == -1;
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)this.durationIfNotZero(start), (Object)this.is, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)shouldNotContain)));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    public String toString() {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "toString", null, "");
        long start = System.currentTimeMillis();
        this.assignValueAndWrapExceptionsIfNeeded(ctx, start);
        return this.is;
    }

    protected String assignValueAndWrapExceptionsIfNeeded(BaseFluentWebDriver.Context ctx, long start) {
        try {
            this.assignValueIfNeeded();
            return this.is;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    public void shouldMatch(String regex) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldMatch", null, regex);
        long start = System.currentTimeMillis();
        MatchesRegex matcher = new MatchesRegex(regex);
        try {
            this.assignValueIfNeeded();
            if (this.is != null && !matcher.matches(this.is) && this.within != null) {
                boolean passed;
                long endMillis = this.calcEndMillis();
                do {
                    this.is = this.execution.execute();
                    boolean bl = passed = this.is != null && matcher.matches(this.is);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)this.durationIfNotZero(start), (Object)this.is, (Matcher)matcher);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    public void shouldNotMatch(String regex) {
        BaseFluentWebDriver.Context ctx = BaseFluentWebDriver.Context.singular(this.context, "shouldNotMatch", null, regex);
        long start = System.currentTimeMillis();
        MatchesRegex matcher = new MatchesRegex(regex);
        try {
            this.assignValueIfNeeded();
            if (this.is != null && matcher.matches(this.is) && this.within != null) {
                boolean passed;
                long endMillis = this.calcEndMillis();
                do {
                    this.is = this.execution.execute();
                    boolean bl = passed = this.is != null && !matcher.matches(this.is);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)this.durationIfNotZero(start), (Object)this.is, (Matcher)CoreMatchers.not((Matcher)matcher));
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BaseFluentWebDriver.decorateRuntimeException(ctx, e);
        }
        catch (AssertionError e) {
            throw BaseFluentWebDriver.decorateAssertionError(ctx, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchesRegex
    extends BaseMatcher<String> {
        private final String regex;
        private final Pattern pattern;

        public MatchesRegex(String regex) {
            this.regex = regex;
            this.pattern = Pattern.compile(regex, 8);
        }

        public void describeTo(Description description) {
            description.appendText("a string matching /" + this.regex + "/");
        }

        public final void describeMismatch(Object item, Description description) {
            description.appendText("was ").appendValue(item);
        }

        public final boolean matches(Object item) {
            return this.pattern.matcher((String)item).find();
        }
    }
}

