/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.cli;

import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class WrappedPrintWriter
extends PrintWriter {
    private final int lineLength;
    private final int indentBy;
    private int position = 0;

    public WrappedPrintWriter(OutputStream out, int lineLength, int indentBy) {
        this(new OutputStreamWriter(out), lineLength, indentBy);
    }

    public WrappedPrintWriter(Writer out, int lineLength, int indentBy) {
        super(out);
        Preconditions.checkArgument((lineLength > 10 ? 1 : 0) != 0, (Object)"Lines must be 10 or more characters.");
        Preconditions.checkArgument((indentBy >= 0 ? 1 : 0) != 0, (Object)"An indent cannot be less than 0.");
        this.lineLength = lineLength;
        this.indentBy = indentBy;
    }

    @Override
    public void write(int c) {
        if (c == 10) {
            super.write(c);
            this.position = 0;
        } else {
            if (this.position > this.lineLength && Character.isWhitespace(c)) {
                super.write(10);
                for (int i = 0; i < this.indentBy; ++i) {
                    super.write(32);
                }
                this.position = this.indentBy;
                return;
            }
            super.write(c);
            ++this.position;
        }
        this.flush();
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(buf[off + i]);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(off + i));
        }
    }
}

