/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.docker;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.docker.Docker;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.ImageNamePredicate;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.docker.DockerSessionFactory;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class DockerOptions {
    private static final Logger LOG = Logger.getLogger(DockerOptions.class.getName());
    private static final Json JSON = new Json();
    private final Config config;

    public DockerOptions(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    private URL getDockerUrl() {
        try {
            String raw = this.config.get("docker", "url").orElseThrow(() -> new ConfigException("No docker url configured", new Object[0]));
            return new URL(raw);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isEnabled(HttpClient.Factory clientFactory) {
        if (!this.config.getAll("docker", "configs").isPresent()) {
            return false;
        }
        URL url = this.getDockerUrl();
        HttpClient client = clientFactory.createClient(url);
        try {
            HttpResponse response = client.execute(new HttpRequest(HttpMethod.GET, "/_ping"));
            if (response.getStatus() != 200) {
                LOG.warning(String.format("Docker config enabled, but daemon unreachable: %s", url));
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to ping docker daemon. Docker disabled: " + e.getMessage());
            return false;
        }
    }

    public void configure(HttpClient.Factory clientFactory, LocalNode.Builder node) throws IOException {
        if (!this.isEnabled(clientFactory)) {
            return;
        }
        List<String> allConfigs = this.config.getAll("docker", "configs").orElseThrow(() -> new DockerException("Unable to find docker configs"));
        HashMultimap kinds = HashMultimap.create();
        for (int i = 0; i < allConfigs.size(); ++i) {
            String imageName = allConfigs.get(i);
            if (++i == allConfigs.size()) {
                throw new DockerException("Unable to find JSON config");
            }
            Capabilities stereotype = (Capabilities)JSON.toType(allConfigs.get(i), Capabilities.class);
            kinds.put((Object)imageName, (Object)stereotype);
        }
        HttpClient client = clientFactory.createClient(new URL("http://localhost:2375"));
        Docker docker = new Docker(client);
        this.loadImages(docker, kinds.keySet().toArray(new String[0]));
        int maxContainerCount = Runtime.getRuntime().availableProcessors();
        kinds.forEach((name, caps) -> {
            Image image = docker.findImage(new ImageNamePredicate((String)name)).orElseThrow(() -> new DockerException(String.format("Cannot find image matching: %s", name)));
            for (int i = 0; i < maxContainerCount; ++i) {
                node.add((Capabilities)caps, new DockerSessionFactory(clientFactory, docker, image, (Capabilities)caps));
            }
            LOG.info(String.format("Mapping %s to docker image %s %d times", caps, name, maxContainerCount));
        });
    }

    private void loadImages(Docker docker, String ... imageNames) {
        CompletableFuture<Void> cd = CompletableFuture.allOf((CompletableFuture[])Arrays.stream(imageNames).map(entry -> {
            int index = entry.lastIndexOf(58);
            if (index == -1) {
                throw new RuntimeException("Unable to determine tag from " + entry);
            }
            String name = entry.substring(0, index);
            String version = entry.substring(index + 1);
            return CompletableFuture.supplyAsync(() -> docker.pull(name, version));
        }).toArray(CompletableFuture[]::new));
        try {
            cd.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

