/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;

public abstract class BaseActiveSession
implements ActiveSession {
    private final Session session;
    private final Dialect downstream;
    private final Dialect upstream;

    protected BaseActiveSession(SessionId id, URL url, Dialect downstream, Dialect upstream, Capabilities capabilities) {
        URI uri = null;
        try {
            uri = Objects.requireNonNull(url).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.session = new Session(Objects.requireNonNull(id), uri, (Capabilities)ImmutableCapabilities.copyOf((Capabilities)Objects.requireNonNull(capabilities)));
        this.downstream = Objects.requireNonNull(downstream);
        this.upstream = Objects.requireNonNull(upstream);
    }

    @Override
    public SessionId getId() {
        return this.session.getId();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.session.getCapabilities();
    }

    @Override
    public URI getUri() {
        return this.session.getUri();
    }

    @Override
    public Dialect getUpstreamDialect() {
        return this.upstream;
    }

    @Override
    public Dialect getDownstreamDialect() {
        return this.downstream;
    }

    public Session asSession() {
        return this.session;
    }
}

