/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.ForwardWebDriverCommand;
import org.openqa.selenium.grid.node.GetNodeSession;
import org.openqa.selenium.grid.node.IsSessionOwner;
import org.openqa.selenium.grid.node.NewNodeSession;
import org.openqa.selenium.grid.node.StatusHandler;
import org.openqa.selenium.grid.node.StopNodeSession;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.HandlerNotFoundException;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.DistributedTracer;

public abstract class Node
implements Predicate<HttpRequest>,
CommandHandler {
    protected final DistributedTracer tracer;
    private final UUID id;
    private final URI uri;
    private final Routes routes;

    protected Node(DistributedTracer tracer, UUID id, URI uri) {
        this.tracer = Objects.requireNonNull(tracer);
        this.id = Objects.requireNonNull(id);
        this.uri = Objects.requireNonNull(uri);
        Json json = new Json();
        this.routes = Routes.combine(Routes.matching(req -> HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).map(this::isSessionOwner).orElse(false)).using(() -> new ForwardWebDriverCommand(this)), Routes.get("/se/grid/node/owner/{sessionId}").using(params -> new IsSessionOwner(this, json, new SessionId((String)params.get("sessionId")))), Routes.delete("/se/grid/node/session/{sessionId}").using(params -> new StopNodeSession(this, new SessionId((String)params.get("sessionId")))), Routes.get("/se/grid/node/session/{sessionId}").using(params -> new GetNodeSession(this, json, new SessionId((String)params.get("sessionId")))), Routes.post("/se/grid/node/session").using(() -> new NewNodeSession(this, json)), Routes.get("/se/grid/node/status").using((req, res) -> {
            HttpResponse cfr_ignored_0 = (HttpResponse)res.setContent(Contents.utf8String((CharSequence)json.toJson((Object)this.getStatus())));
        }), Routes.get("/status").using(() -> new StatusHandler(this, json))).build();
    }

    public UUID getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public abstract Optional<CreateSessionResponse> newSession(CreateSessionRequest var1);

    public abstract void executeWebDriverCommand(HttpRequest var1, HttpResponse var2);

    public abstract Session getSession(SessionId var1) throws NoSuchSessionException;

    public abstract void stop(SessionId var1) throws NoSuchSessionException;

    protected abstract boolean isSessionOwner(SessionId var1);

    public abstract boolean isSupporting(Capabilities var1);

    public abstract NodeStatus getStatus();

    public abstract HealthCheck getHealthCheck();

    @Override
    public boolean test(HttpRequest req) {
        return this.routes.match(req).isPresent();
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Optional<CommandHandler> handler = this.routes.match(req);
        if (!handler.isPresent()) {
            throw new HandlerNotFoundException(req);
        }
        handler.get().execute(req, resp);
    }
}

