/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.node.BaseActiveSession;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.ProtocolConverter;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public abstract class ProtocolConvertingSession
extends BaseActiveSession {
    private final CommandHandler handler;
    private final String killUrl;

    protected ProtocolConvertingSession(HttpClient client, SessionId id, URL url, Dialect downstream, Dialect upstream, Capabilities capabilities) {
        super(id, url, downstream, upstream, capabilities);
        Objects.requireNonNull(client);
        this.handler = downstream.equals((Object)upstream) ? new ReverseProxyHandler(client) : new ProtocolConverter(client, downstream, upstream);
        this.killUrl = "/session/" + id;
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        this.handler.execute(req, resp);
        if (req.getMethod() == HttpMethod.DELETE && this.killUrl.equals(req.getUri())) {
            this.stop();
        }
    }
}

