/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.logging.Logger;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;

public class EventBusConfig {
    private static final Logger LOG = Logger.getLogger(EventBus.class.getName());
    private static final String DEFAULT_CLASS = "org.openqa.selenium.events.zeromq.ZeroMqEventBus";
    private final Config config;
    private EventBus bus;

    public EventBusConfig(Config config) {
        this.config = Objects.requireNonNull(config, "Config must be set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBus getEventBus() {
        if (this.bus == null) {
            EventBusConfig eventBusConfig = this;
            synchronized (eventBusConfig) {
                if (this.bus == null) {
                    this.bus = this.createBus();
                }
            }
        }
        return this.bus;
    }

    private EventBus createBus() {
        String clazzName = this.config.get("events", "implementation").orElse(DEFAULT_CLASS);
        LOG.info("Creating event bus: " + clazzName);
        try {
            Class<?> busClazz = Class.forName(clazzName);
            Method create = busClazz.getMethod("create", Config.class);
            if (!Modifier.isStatic(create.getModifiers())) {
                throw new IllegalArgumentException(String.format("Event bus class %s's `create(Config)` method must be static", clazzName));
            }
            if (!EventBus.class.isAssignableFrom(create.getReturnType())) {
                throw new IllegalArgumentException(String.format("Event bus class %s's `create(Config)` method must return an EventBus", clazzName));
            }
            return (EventBus)create.invoke(null, this.config);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Event bus class %s must have a static `create(Config)` method", clazzName));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to find event bus class: " + clazzName, e);
        }
    }
}

