/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class AddToSessionMap
implements CommandHandler {
    private final Json json;
    private final SessionMap sessions;

    AddToSessionMap(Json json, SessionMap sessions) {
        this.json = Objects.requireNonNull(json);
        this.sessions = Objects.requireNonNull(sessions);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) {
        Session session = (Session)this.json.toType(Contents.string((HttpMessage)req), Session.class);
        Objects.requireNonNull(session, "Session to add must be set");
        this.sessions.add(session);
        resp.setContent(Contents.utf8String((CharSequence)this.json.toJson((Object)ImmutableMap.of((Object)"value", (Object)true))));
    }
}

