/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.remote;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class RemoteSessionMap
extends SessionMap {
    public static final Json JSON = new Json();
    private final HttpClient client;

    public RemoteSessionMap(HttpClient client) {
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public boolean add(Session session) {
        Objects.requireNonNull(session, "Session must be set");
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/se/grid/session");
        request.setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)session)));
        return (Boolean)this.makeRequest(request, (Type)((Object)Boolean.class));
    }

    @Override
    public Session get(SessionId id) {
        Objects.requireNonNull(id, "Session ID must be set");
        Session session = (Session)this.makeRequest(new HttpRequest(HttpMethod.GET, "/se/grid/session/" + id), (Type)((Object)Session.class));
        if (session == null) {
            throw new NoSuchSessionException("Unable to find session with ID: " + id);
        }
        return session;
    }

    @Override
    public void remove(SessionId id) {
        Objects.requireNonNull(id, "Session ID must be set");
        this.makeRequest(new HttpRequest(HttpMethod.DELETE, "/se/grid/session/" + id), (Type)((Object)Void.class));
    }

    private <T> T makeRequest(HttpRequest request, Type typeOfT) {
        try {
            HttpResponse response = this.client.execute(request);
            return Values.get(response, typeOfT);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

