/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.remote.http.HttpRequest;

public class PredicatedRoute
extends Route<PredicatedRoute> {
    private Supplier<CommandHandler> handlerFunc;
    private final Predicate<HttpRequest> predicate;

    PredicatedRoute(Predicate<HttpRequest> predicate) {
        this.predicate = Objects.requireNonNull(predicate);
    }

    public PredicatedRoute using(Supplier<CommandHandler> handlerSupplier) {
        Objects.requireNonNull(handlerSupplier);
        this.handlerFunc = handlerSupplier;
        return this;
    }

    public PredicatedRoute using(CommandHandler handlerInstance) {
        Objects.requireNonNull(handlerInstance);
        this.handlerFunc = () -> handlerInstance;
        return this;
    }

    @Override
    protected void validate() {
        if (this.handlerFunc == null) {
            throw new IllegalStateException("Handler for route is required");
        }
    }

    @Override
    protected CommandHandler newHandler(HttpRequest request) {
        if (!this.predicate.test(request)) {
            return this.getFallback();
        }
        return this.handlerFunc.get();
    }
}

