/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.ElementConverter;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.w3c.dom.Node;

public class HtmlUnitElementFinder {
    public static WebElement findElement(HtmlUnitDriver driver, By locator) {
        return ElementConverter.HtmlUnitElementConverter.getElementObject(driver, locator).findElement(locator);
    }

    public static List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
        return ElementConverter.HtmlUnitElementConverter.getElementObject(driver, locator).findElements(locator);
    }

    private static List<WebElement> convertRawDomElementsToWebElements(HtmlUnitDriver driver, List<DomElement> nodes) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>(nodes.size());
        for (DomElement node : nodes) {
            elements.add(driver.toWebElement(node));
        }
        return elements;
    }

    public static abstract class ElementObject {
        private final HtmlUnitDriver driver;

        public ElementObject(HtmlUnitDriver driver) {
            this.driver = driver;
        }

        protected HtmlUnitDriver getDriver() {
            return this.driver;
        }

        public WebElement findElement(By locator) {
            List<WebElement> elements = this.findElements(locator);
            if (!elements.isEmpty()) {
                return elements.get(0);
            }
            throw new NoSuchElementException("Unable to locate element");
        }

        public abstract List<WebElement> findElements(By var1);

        protected static By.Remotable getRemotable(By locator) {
            if (!(locator instanceof By.Remotable)) {
                throw new IllegalStateException("Cannot convert locator to Remotable");
            }
            return (By.Remotable)locator;
        }

        protected SgmlPage getLastPage() {
            Page lastPage = this.driver.getWindowManager().lastPage();
            if (!(lastPage instanceof SgmlPage)) {
                throw new IllegalStateException("Current page is not a SgmlPage");
            }
            return (SgmlPage)lastPage;
        }

        protected static String getValue(By locator) {
            By.Remotable remote = ElementObject.getRemotable(locator);
            return (String)remote.getRemoteParameters().value();
        }
    }

    public static class FindByXPath
    extends ElementObject {
        public FindByXPath(HtmlUnitDriver driver) {
            super(driver);
        }

        @Override
        public WebElement findElement(By locator) {
            Object node;
            SgmlPage lastPage = this.getLastPage();
            String value = FindByXPath.getValue(locator);
            try {
                node = lastPage.getFirstByXPath(value);
            }
            catch (Exception ex) {
                throw new InvalidSelectorException(String.format("The xpath expression '%s' cannot be evaluated", value), (Throwable)ex);
            }
            if (node == null) {
                throw new NoSuchElementException("Unable to locate a node using " + value);
            }
            if (node instanceof DomElement) {
                return this.getDriver().toWebElement((DomElement)node);
            }
            throw new InvalidSelectorException(String.format("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", value, node.getClass()));
        }

        @Override
        public List<WebElement> findElements(By locator) {
            List nodes;
            SgmlPage lastPage;
            try {
                lastPage = this.getLastPage();
            }
            catch (IllegalStateException e) {
                return Collections.emptyList();
            }
            String value = FindByXPath.getValue(locator);
            try {
                nodes = lastPage.getByXPath(value);
            }
            catch (RuntimeException ex) {
                throw new InvalidSelectorException(String.format("The xpath expression '%s' cannot be evaluated", value), (Throwable)ex);
            }
            ArrayList<WebElement> elements = new ArrayList<WebElement>(nodes.size());
            for (Object node : nodes) {
                if (!(node instanceof DomElement)) {
                    throw new InvalidSelectorException(String.format("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", value, node.getClass()));
                }
                elements.add(this.getDriver().toWebElement((DomElement)node));
            }
            return elements;
        }
    }

    public static class FindByTagName
    extends ElementObject {
        public FindByTagName(HtmlUnitDriver driver) {
            super(driver);
        }

        @Override
        public WebElement findElement(By locator) {
            DomNodeList allElements = this.getLastPage().getElementsByTagName(FindByTagName.getValue(locator));
            if (allElements.getLength() > 0) {
                return this.getDriver().toWebElement((DomElement)((HtmlElement)allElements.item(0)));
            }
            throw new NoSuchElementException("Unable to locate element with name: " + FindByTagName.getValue(locator));
        }

        @Override
        public List<WebElement> findElements(By locator) {
            SgmlPage lastPage;
            String name = FindByTagName.getValue(locator);
            if ("".equals(name)) {
                throw new InvalidSelectorException("Unable to locate element by xpath for " + this.getLastPage());
            }
            try {
                lastPage = this.getLastPage();
            }
            catch (IllegalStateException e) {
                return Collections.emptyList();
            }
            DomNodeList allElements = lastPage.getElementsByTagName(name);
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>(allElements.getLength());
            for (int i = 0; i < allElements.getLength(); ++i) {
                Node item = allElements.item(i);
                if (!(item instanceof DomElement)) continue;
                toReturn.add(this.getDriver().toWebElement((DomElement)item));
            }
            return toReturn;
        }
    }

    public static class FindByCssSelector
    extends ElementObject {
        public FindByCssSelector(HtmlUnitDriver driver) {
            super(driver);
        }

        @Override
        public WebElement findElement(By locator) {
            DomNode node;
            try {
                node = this.getLastPage().querySelector(FindByCssSelector.getValue(locator));
            }
            catch (CSSException ex) {
                throw new NoSuchElementException("Unable to locate element using css", (Throwable)ex);
            }
            if (node instanceof DomElement) {
                return this.getDriver().toWebElement((DomElement)node);
            }
            throw new NoSuchElementException("Returned node (" + node + ") was not a DOM element");
        }

        @Override
        public List<WebElement> findElements(By locator) {
            DomNodeList allNodes;
            try {
                allNodes = this.getLastPage().querySelectorAll(FindByCssSelector.getValue(locator));
            }
            catch (CSSException ex) {
                throw new NoSuchElementException("Unable to locate element using css", (Throwable)ex);
            }
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
            for (DomNode node : allNodes) {
                if (node instanceof DomElement) {
                    toReturn.add(this.getDriver().toWebElement((DomElement)node));
                    continue;
                }
                throw new NoSuchElementException("Returned node was not a DOM element");
            }
            return toReturn;
        }
    }

    public static class FindByClassName
    extends ElementObject {
        public FindByClassName(HtmlUnitDriver driver) {
            super(driver);
        }

        private String checkValue(By locator) {
            String value = FindByClassName.getValue(locator);
            if (value.indexOf(32) != -1) {
                throw new NoSuchElementException("Compound class names not permitted");
            }
            return value;
        }

        @Override
        public WebElement findElement(By locator) {
            return new FindByCssSelector(this.getDriver()).findElement(By.cssSelector((String)("." + this.checkValue(locator))));
        }

        @Override
        public List<WebElement> findElements(By locator) {
            return new FindByCssSelector(this.getDriver()).findElements(By.cssSelector((String)("." + this.checkValue(locator))));
        }
    }

    public static class FindByPartialLinkText
    extends ElementObject {
        public FindByPartialLinkText(HtmlUnitDriver driver) {
            super(driver);
        }

        @Override
        public List<WebElement> findElements(By locator) {
            SgmlPage lastPage = this.getLastPage();
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find links for " + lastPage);
            }
            List anchors = ((HtmlPage)lastPage).getAnchors();
            ArrayList<WebElement> elements = new ArrayList<WebElement>();
            for (HtmlAnchor anchor : anchors) {
                if (!anchor.asNormalizedText().contains(FindByPartialLinkText.getValue(locator))) continue;
                elements.add(this.getDriver().toWebElement((DomElement)anchor));
            }
            return elements;
        }
    }

    public static class FindByLinkText
    extends ElementObject {
        public FindByLinkText(HtmlUnitDriver driver) {
            super(driver);
        }

        @Override
        public List<WebElement> findElements(By locator) {
            SgmlPage lastPage = this.getLastPage();
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find links for " + lastPage);
            }
            ArrayList<WebElement> elements = new ArrayList<WebElement>();
            List anchors = ((HtmlPage)lastPage).getAnchors();
            String value = FindByLinkText.getValue(locator);
            for (HtmlAnchor anchor : anchors) {
                if (!value.trim().equals(anchor.asNormalizedText().trim())) continue;
                elements.add(this.getDriver().toWebElement((DomElement)anchor));
            }
            return elements;
        }
    }

    public static class FindByName
    extends ElementObject {
        public FindByName(HtmlUnitDriver driver) {
            super(driver);
        }

        @Override
        public List<WebElement> findElements(By locator) {
            SgmlPage lastPage = this.getLastPage();
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find elements by id for " + lastPage);
            }
            List allElements = ((HtmlPage)lastPage).getElementsByName(FindByName.getValue(locator));
            return HtmlUnitElementFinder.convertRawDomElementsToWebElements(this.getDriver(), allElements);
        }
    }

    public static class FindByID
    extends ElementObject {
        public FindByID(HtmlUnitDriver driver) {
            super(driver);
        }

        @Override
        public WebElement findElement(By locator) {
            SgmlPage lastPage = this.getLastPage();
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find elements by id for " + lastPage);
            }
            By.Remotable remote = FindByID.getRemotable(locator);
            String id = (String)remote.getRemoteParameters().value();
            DomElement element = ((HtmlPage)lastPage).getElementById(id);
            if (element == null) {
                throw new NoSuchElementException("Unable to locate element with ID: '" + id + "'");
            }
            return this.getDriver().toWebElement(element);
        }

        @Override
        public List<WebElement> findElements(By locator) {
            SgmlPage lastPage = this.getLastPage();
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find elements by id for " + lastPage);
            }
            List allElements = ((HtmlPage)lastPage).getElementsById(FindByID.getValue(locator));
            return HtmlUnitElementFinder.convertRawDomElementsToWebElements(this.getDriver(), allElements);
        }
    }
}

