/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.seleniumhq.jetty9.io.Connection;
import org.seleniumhq.jetty9.io.EndPoint;
import org.seleniumhq.jetty9.io.ManagedSelector;
import org.seleniumhq.jetty9.util.annotation.ManagedAttribute;
import org.seleniumhq.jetty9.util.annotation.ManagedObject;
import org.seleniumhq.jetty9.util.component.ContainerLifeCycle;
import org.seleniumhq.jetty9.util.component.Dumpable;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;
import org.seleniumhq.jetty9.util.thread.ReservedThreadExecutor;
import org.seleniumhq.jetty9.util.thread.Scheduler;
import org.seleniumhq.jetty9.util.thread.ThreadPool;

@ManagedObject(value="Manager of the NIO Selectors")
public abstract class SelectorManager
extends ContainerLifeCycle
implements Dumpable {
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private long _connectTimeout = 15000L;
    private long _selectorIndex;
    private int _reservedThreads = -1;

    public static int defaultSchedulers(Executor executor) {
        if (executor instanceof ThreadPool) {
            int threads = ((ThreadPool)executor).getThreads();
            int cpus = Runtime.getRuntime().availableProcessors();
            return Math.max(1, Math.min(cpus / 2, threads / 16));
        }
        return Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler) {
        this(executor, scheduler, -1);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        if (selectors <= 0) {
            selectors = SelectorManager.defaultSchedulers(executor);
        }
        this.executor = executor;
        this.scheduler = scheduler;
        this._selectors = new ManagedSelector[selectors];
    }

    @ManagedAttribute(value="The Executor")
    public Executor getExecutor() {
        return this.executor;
    }

    @ManagedAttribute(value="The Scheduler")
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @ManagedAttribute(value="The Connection timeout (ms)")
    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long milliseconds) {
        this._connectTimeout = milliseconds;
    }

    @ManagedAttribute(value="The number of reserved producer threads")
    public int getReservedThreads() {
        return this._reservedThreads;
    }

    public void setReservedThreads(int threads) {
        this._reservedThreads = threads;
    }

    protected void execute(Runnable task) {
        this.executor.execute(task);
    }

    @ManagedAttribute(value="The number of NIO Selectors")
    public int getSelectorCount() {
        return this._selectors.length;
    }

    private ManagedSelector chooseSelector(SelectableChannel channel) {
        ManagedSelector candidate1 = null;
        if (channel != null) {
            try {
                byte[] addr;
                SocketAddress remote;
                if (channel instanceof SocketChannel && (remote = ((SocketChannel)channel).getRemoteAddress()) instanceof InetSocketAddress && (addr = ((InetSocketAddress)remote).getAddress().getAddress()) != null) {
                    int s = addr[addr.length - 1] & 0xFF;
                    candidate1 = this._selectors[s % this.getSelectorCount()];
                }
            }
            catch (IOException x) {
                LOG.ignore(x);
            }
        }
        long s = this._selectorIndex++;
        int index = (int)(s % (long)this.getSelectorCount());
        ManagedSelector candidate2 = this._selectors[index];
        if (candidate1 == null || candidate1.size() >= candidate2.size() * 2) {
            return candidate2;
        }
        return candidate1;
    }

    public void connect(SelectableChannel channel, Object attachment) {
        ManagedSelector set;
        ManagedSelector managedSelector = set = this.chooseSelector(channel);
        Objects.requireNonNull(managedSelector);
        set.submit(managedSelector.new ManagedSelector.Connect(channel, attachment));
    }

    public void accept(SelectableChannel channel) {
        this.accept(channel, null);
    }

    public void accept(SelectableChannel channel, Object attachment) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector(channel);
        Objects.requireNonNull(managedSelector);
        selector.submit(managedSelector.new ManagedSelector.Accept(channel, attachment));
    }

    public Closeable acceptor(SelectableChannel server) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector(null);
        Objects.requireNonNull(managedSelector);
        ManagedSelector.Acceptor acceptor = managedSelector.new ManagedSelector.Acceptor(server);
        selector.submit(acceptor);
        return acceptor;
    }

    protected void accepted(SelectableChannel channel) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doStart() throws Exception {
        this.addBean((Object)new ReservedThreadExecutor(this.getExecutor(), this._reservedThreads), true);
        for (int i = 0; i < this._selectors.length; ++i) {
            ManagedSelector selector;
            this._selectors[i] = selector = this.newSelector(i);
            this.addBean(selector);
        }
        super.doStart();
    }

    protected ManagedSelector newSelector(int id) {
        return new ManagedSelector(this, id);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (ManagedSelector selector : this._selectors) {
            this.removeBean(selector);
        }
    }

    protected void endPointOpened(EndPoint endpoint) {
    }

    protected void endPointClosed(EndPoint endpoint) {
    }

    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
        }
        catch (Throwable x) {
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, x);
            } else {
                LOG.debug("Exception while notifying connection " + connection, x);
            }
            throw x;
        }
    }

    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
        }
        catch (Throwable x) {
            LOG.debug("Exception while notifying connection " + connection, x);
        }
    }

    protected boolean doFinishConnect(SelectableChannel channel) throws IOException {
        return ((SocketChannel)channel).finishConnect();
    }

    protected boolean isConnectionPending(SelectableChannel channel) {
        return ((SocketChannel)channel).isConnectionPending();
    }

    protected SelectableChannel doAccept(SelectableChannel server) throws IOException {
        return ((ServerSocketChannel)server).accept();
    }

    protected void connectionFailed(SelectableChannel channel, Throwable ex, Object attachment) {
        LOG.warn(String.format("%s - %s", channel, attachment), ex);
    }

    protected Selector newSelector() throws IOException {
        return Selector.open();
    }

    protected abstract EndPoint newEndPoint(SelectableChannel var1, ManagedSelector var2, SelectionKey var3) throws IOException;

    public abstract Connection newConnection(SelectableChannel var1, EndPoint var2, Object var3) throws IOException;
}

