/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.lift;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.lift.TestContext;
import org.openqa.selenium.lift.find.Finder;
import org.openqa.selenium.lift.match.NumericalMatchers;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebDriverTestContext
implements TestContext {
    private WebDriver driver;
    private final Clock clock;
    private final Sleeper sleeper;

    public WebDriverTestContext(WebDriver driver) {
        this(driver, (Clock)new SystemClock(), Sleeper.SYSTEM_SLEEPER);
    }

    WebDriverTestContext(WebDriver driver, Clock clock, Sleeper sleeper) {
        this.driver = driver;
        this.clock = clock;
        this.sleeper = sleeper;
    }

    @Override
    public void quit() {
        this.driver.quit();
    }

    @Override
    public void goTo(String url) {
        this.driver.get(url);
    }

    @Override
    public void assertPresenceOf(Finder<WebElement, WebDriver> finder) {
        this.assertPresenceOf(NumericalMatchers.atLeast(1), finder);
    }

    @Override
    public void assertPresenceOf(Matcher<Integer> cardinalityConstraint, Finder<WebElement, WebDriver> finder) {
        Collection<WebElement> foundElements = finder.findFrom(this.driver);
        if (!cardinalityConstraint.matches((Object)foundElements.size())) {
            StringDescription description = new StringDescription();
            description.appendText("\nExpected: ").appendDescriptionOf(cardinalityConstraint).appendText(" ").appendDescriptionOf(finder).appendText("\n     got: ").appendValue((Object)foundElements.size()).appendText(" ").appendDescriptionOf(finder).appendText("\n");
            this.failWith(description.toString());
        }
    }

    @Override
    public void type(String input, Finder<WebElement, WebDriver> finder) {
        WebElement element = this.findOneElementTo("type into", finder);
        element.sendKeys(new CharSequence[]{input});
    }

    @Override
    public void clickOn(Finder<WebElement, WebDriver> finder) {
        WebElement element = this.findOneElementTo("click on", finder);
        element.click();
    }

    public void clickOnFirst(Finder<WebElement, WebDriver> finder) {
        WebElement element = this.findFirstElementTo("click on", finder);
        element.click();
    }

    private WebElement findFirstElementTo(String action, Finder<WebElement, WebDriver> finder) {
        Collection<WebElement> foundElements = finder.findFrom(this.driver);
        if (foundElements.isEmpty()) {
            this.failWith("could not find element to " + action);
        }
        return foundElements.iterator().next();
    }

    private WebElement findOneElementTo(String action, Finder<WebElement, WebDriver> finder) {
        Collection<WebElement> foundElements = finder.findFrom(this.driver);
        if (foundElements.isEmpty()) {
            this.failWith("could not find element to " + action);
        } else if (foundElements.size() > 1) {
            this.failWith("did not know what to " + action + " - ambiguous");
        }
        return foundElements.iterator().next();
    }

    private void failWith(String message) throws AssertionError {
        throw new AssertionError((Object)message);
    }

    @Override
    public void waitFor(final Finder<WebElement, WebDriver> finder, final long timeoutMillis) {
        ExpectedCondition<Boolean> elementsDisplayedPredicate = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                Collection elements = finder.findFrom(driver);
                for (WebElement webElement : elements) {
                    if (!webElement.isDisplayed()) continue;
                    return true;
                }
                return false;
            }
        };
        long defaultSleepTimeoutMillis = FluentWait.FIVE_HUNDRED_MILLIS.in(TimeUnit.MILLISECONDS);
        long sleepTimeout = timeoutMillis > defaultSleepTimeoutMillis ? defaultSleepTimeoutMillis : timeoutMillis / 2L;
        WebDriverWait wait = new WebDriverWait(this.driver, this.clock, this.sleeper, WebDriverTestContext.millisToSeconds(timeoutMillis), sleepTimeout){

            protected RuntimeException timeoutException(String message, Throwable lastException) {
                throw new AssertionError((Object)("Element was not rendered within " + timeoutMillis + "ms"));
            }
        };
        wait.until((Function)elementsDisplayedPredicate);
    }

    private static long millisToSeconds(long timeoutMillis) {
        return WebDriverTestContext.ceiling((double)timeoutMillis / 1000.0);
    }

    private static long ceiling(double value) {
        long asLong = (long)value;
        int additional = value - (double)asLong > 0.0 ? 1 : 0;
        return asLong + (long)additional;
    }
}

