/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import org.openqa.selenium.Alert;
import org.openqa.selenium.WebDriverException;

public class UnhandledAlertException
extends WebDriverException {
    private final String alertText;

    public UnhandledAlertException(String commandName) {
        this(commandName, (String)null);
    }

    public UnhandledAlertException(String commandName, String alertText) {
        super(commandName);
        this.alertText = alertText;
    }

    public Alert getAlert() {
        return new LocallyStoredAlert(this.alertText);
    }

    private static class LocallyStoredAlert
    implements Alert,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String alertText;

        public LocallyStoredAlert(String alertText) {
            this.alertText = alertText;
        }

        @Override
        public void dismiss() {
            this.throwAlreadyDismissed();
        }

        @Override
        public void accept() {
            this.throwAlreadyDismissed();
        }

        @Override
        public String getText() {
            return this.alertText;
        }

        @Override
        public void sendKeys(String keysToSend) {
            this.throwAlreadyDismissed();
        }

        private void throwAlreadyDismissed() {
            throw new UnsupportedOperationException("Alert was already dismissed");
        }
    }
}

