/*
Copyright 2012 Software Freedom Conservancy

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.openqa.selenium.logging.profiler;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;

public class HttpProfilerLogEntry extends ProfilerLogEntry {

  public HttpProfilerLogEntry(String commandName, boolean isStart) {
    super(EventType.HTTP_COMMAND, constructMessage(EventType.HTTP_COMMAND, commandName, isStart));
  }
  
  private static String constructMessage(EventType eventType, String commandName, boolean isStart) {
    Map<String, ?> map = ImmutableMap.of(
      "event", eventType.toString(),
      "command", commandName,
      "startorend", isStart ? "start" : "end");
    return new Gson().toJson(map);
  }

}
