/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.AbstractCapabilities;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;

public class MutableCapabilities
extends AbstractCapabilities
implements Serializable {
    private static final long serialVersionUID = -112816287184979465L;
    private static final Set<String> OPTION_KEYS;

    public MutableCapabilities() {
    }

    public MutableCapabilities(Capabilities other) {
        this(other.asMap());
    }

    public MutableCapabilities(Map<String, ?> capabilities) {
        capabilities.forEach((key, value) -> {
            if (value != null) {
                this.setCapability((String)key, value);
            }
        });
    }

    @Override
    public MutableCapabilities merge(Capabilities extraCapabilities) {
        if (extraCapabilities == null) {
            return this;
        }
        extraCapabilities.asMap().forEach(this::setCapability);
        return this;
    }

    public void setCapability(String capabilityName, boolean value) {
        this.setCapability(capabilityName, (Object)value);
    }

    public void setCapability(String capabilityName, String value) {
        this.setCapability(capabilityName, (Object)value);
    }

    public void setCapability(String capabilityName, Platform value) {
        this.setCapability(capabilityName, (Object)value);
    }

    @Override
    public void setCapability(String key, Object value) {
        if (OPTION_KEYS.contains(key) && value instanceof Capabilities) {
            this.merge((Capabilities)value);
            return;
        }
        super.setCapability(key, value);
    }

    static {
        HashSet<String> keys = new HashSet<String>();
        keys.add("chromeOptions");
        keys.add("edgeOptions");
        keys.add("goog:chromeOptions");
        keys.add("moz:firefoxOptions");
        keys.add("operaOptions");
        keys.add("se:ieOptions");
        keys.add("safari.options");
        OPTION_KEYS = Collections.unmodifiableSet(keys);
    }
}

