/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;

public class ShutdownHooks {
    private static IdentityHashMap<Thread, Thread> defaultHooks = new IdentityHashMap();
    private static IdentityHashMap<Thread, Thread> atEndHooks = new IdentityHashMap();

    private ShutdownHooks() {
    }

    public static void add(Thread hook, HookExecutionStrategy strategy) {
        if (strategy.equals((Object)HookExecutionStrategy.DEFAULT)) {
            defaultHooks.put(hook, hook);
        } else {
            atEndHooks.put(hook, hook);
        }
    }

    public static void add(Thread hook) {
        ShutdownHooks.add(hook, HookExecutionStrategy.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runShutdownHooks() {
        Class<ShutdownHooks> clazz = ShutdownHooks.class;
        synchronized (ShutdownHooks.class) {
            Set<Thread> threads = defaultHooks.keySet();
            defaultHooks = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            ShutdownHooks.runHooks(threads);
            Class<ShutdownHooks> clazz2 = ShutdownHooks.class;
            synchronized (ShutdownHooks.class) {
                Set<Thread> atEndThreads = atEndHooks.keySet();
                atEndHooks = null;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                ShutdownHooks.runHooks(atEndThreads);
                return;
            }
        }
    }

    private static void runHooks(Collection<Thread> threads) {
        for (Thread hook : threads) {
            hook.start();
        }
        block3: for (Thread hook : threads) {
            while (true) {
                try {
                    hook.join();
                    continue block3;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(ShutdownHooks::runShutdownHooks));
    }

    public static enum HookExecutionStrategy {
        AT_END,
        DEFAULT;

    }
}

